/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info.projectile.behaviours;

import com.google.gson.JsonObject;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.projectile.behaviours.ProjectileBehaviour;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ProjectileBehaviourSummon
extends ProjectileBehaviour {
    public String summonMobId;
    public double summonChance = 0.05;
    public int summonDuration = 60;
    public int summonCountMin = 1;
    public int summonCountMax = 1;
    public double sizeScale = 1.0;

    @Override
    public void loadFromJSON(JsonObject json) {
        this.summonMobId = json.get("summonMobId").getAsString();
        if (json.has("summonChance")) {
            this.summonChance = json.get("summonChance").getAsDouble();
        }
        if (json.has("summonDuration")) {
            this.summonDuration = json.get("summonDuration").getAsInt();
        }
        if (json.has("summonCountMin")) {
            this.summonCountMin = json.get("summonCountMin").getAsInt();
        }
        if (json.has("summonCountMax")) {
            this.summonCountMax = json.get("summonCountMax").getAsInt();
        }
        if (json.has("sizeScale")) {
            this.sizeScale = json.get("sizeScale").getAsDouble();
        }
    }

    @Override
    public void onProjectileImpact(BaseProjectileEntity projectile, World world, BlockPos pos) {
        if (projectile == null || projectile.func_130014_f_().field_72995_K) {
            return;
        }
        EntityType entityType = null;
        CreatureInfo creatureInfo = CreatureManager.getInstance().getCreatureFromId(this.summonMobId);
        if (creatureInfo != null) {
            entityType = creatureInfo.getEntityType();
        } else {
            IForgeRegistryEntry entityTypeObj = GameRegistry.findRegistry(EntityType.class).getValue(new ResourceLocation(this.summonMobId));
            if (entityTypeObj instanceof EntityType) {
                entityType = (EntityType)entityTypeObj;
            }
        }
        if (entityType == null) {
            return;
        }
        int summonCount = this.summonCountMin;
        if (this.summonCountMax > this.summonCountMin) {
            summonCount = this.summonCountMin + projectile.func_130014_f_().field_73012_v.nextInt(this.summonCountMax - this.summonCountMin);
        }
        for (int i = 0; i < summonCount; ++i) {
            if (!(projectile.func_130014_f_().field_73012_v.nextDouble() <= this.summonChance)) continue;
            try {
                Entity entity = entityType.func_200721_a(projectile.func_130014_f_());
                entity.func_70012_b((double)projectile.func_180425_c().func_177958_n(), (double)projectile.func_180425_c().func_177956_o(), (double)projectile.func_180425_c().func_177952_p(), projectile.field_70177_z, 0.0f);
                if (!(entity instanceof BaseCreatureEntity)) continue;
                BaseCreatureEntity entityCreature = (BaseCreatureEntity)entity;
                entityCreature.setMinion(true);
                entityCreature.setTemporary(this.summonDuration * 20);
                entityCreature.setSizeScale(this.sizeScale);
                if (projectile.func_85052_h() instanceof PlayerEntity && entityCreature instanceof TameableCreatureEntity) {
                    TameableCreatureEntity entityTameable = (TameableCreatureEntity)entityCreature;
                    entityTameable.setPlayerOwner((PlayerEntity)projectile.func_85052_h());
                    entityTameable.setSitting(false);
                    entityTameable.setFollowing(true);
                    entityTameable.setPassive(false);
                    entityTameable.setAssist(true);
                    entityTameable.setAggressive(true);
                }
                float randomAngle = 45.0f + 45.0f * projectile.func_130014_f_().field_73012_v.nextFloat();
                if (projectile.func_130014_f_().field_73012_v.nextBoolean()) {
                    randomAngle = -randomAngle;
                }
                BlockPos spawnPos = entityCreature.getFacingPosition((Entity)projectile, -1.0, randomAngle);
                entity.func_70012_b((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p(), projectile.field_70177_z, 0.0f);
                entity.func_130014_f_().func_217376_c(entity);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

