/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.client.renderer.EquipmentRenderer;
import com.lycanitesmobs.core.FileLoader;
import com.lycanitesmobs.core.JSONLoader;
import com.lycanitesmobs.core.StreamLoader;
import com.lycanitesmobs.core.block.BlockBase;
import com.lycanitesmobs.core.block.BlockEquipmentForge;
import com.lycanitesmobs.core.block.BlockMaker;
import com.lycanitesmobs.core.block.BlockSummoningPedestal;
import com.lycanitesmobs.core.block.building.BlockVeswax;
import com.lycanitesmobs.core.block.effect.BlockDoomfire;
import com.lycanitesmobs.core.block.effect.BlockFrostCloud;
import com.lycanitesmobs.core.block.effect.BlockFrostfire;
import com.lycanitesmobs.core.block.effect.BlockFrostweb;
import com.lycanitesmobs.core.block.effect.BlockHellfire;
import com.lycanitesmobs.core.block.effect.BlockIcefire;
import com.lycanitesmobs.core.block.effect.BlockPoisonCloud;
import com.lycanitesmobs.core.block.effect.BlockPoopCloud;
import com.lycanitesmobs.core.block.effect.BlockQuickWeb;
import com.lycanitesmobs.core.block.effect.BlockScorchfire;
import com.lycanitesmobs.core.block.effect.BlockShadowfire;
import com.lycanitesmobs.core.block.fluid.BlockFluidAcid;
import com.lycanitesmobs.core.block.fluid.BlockFluidMoglava;
import com.lycanitesmobs.core.block.fluid.BlockFluidOoze;
import com.lycanitesmobs.core.block.fluid.BlockFluidPoison;
import com.lycanitesmobs.core.info.ItemConfig;
import com.lycanitesmobs.core.info.ItemInfo;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.item.ItemBlockPlacer;
import com.lycanitesmobs.core.item.ItemMobToken;
import com.lycanitesmobs.core.item.LMBlocksGroup;
import com.lycanitesmobs.core.item.LMCreaturesGroup;
import com.lycanitesmobs.core.item.LMEquipmentPartsGroup;
import com.lycanitesmobs.core.item.LMItemsGroup;
import com.lycanitesmobs.core.item.consumable.ItemCleansingCrystal;
import com.lycanitesmobs.core.item.consumable.ItemHalloweenTreat;
import com.lycanitesmobs.core.item.consumable.ItemImmunizer;
import com.lycanitesmobs.core.item.consumable.ItemWinterGift;
import com.lycanitesmobs.core.item.consumable.ItemWinterGiftLarge;
import com.lycanitesmobs.core.item.equipment.ItemEquipment;
import com.lycanitesmobs.core.item.special.ItemSoulgazer;
import com.lycanitesmobs.core.item.special.ItemSoulkey;
import com.lycanitesmobs.core.item.special.ItemSoulstone;
import com.lycanitesmobs.core.item.summoningstaff.ItemStaffBlood;
import com.lycanitesmobs.core.item.summoningstaff.ItemStaffSavage;
import com.lycanitesmobs.core.item.summoningstaff.ItemStaffStable;
import com.lycanitesmobs.core.item.summoningstaff.ItemStaffSturdy;
import com.lycanitesmobs.core.item.summoningstaff.ItemStaffSummoning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Items;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemManager
extends JSONLoader {
    public static ItemManager INSTANCE;
    public static final DeferredRegister<Fluid> FLUIDS;
    public Map<String, ItemInfo> items = new HashMap<String, ItemInfo>();
    public List<ModInfo> loadedGroups = new ArrayList<ModInfo>();
    public ItemConfig config;
    public final ItemGroup itemsGroup = new LMItemsGroup("lycanitesmobs.items");
    public final ItemGroup blocksGroup = new LMBlocksGroup("lycanitesmobs.blocks");
    public final ItemGroup creaturesGroups = new LMCreaturesGroup("lycanitesmobs.creatures");
    public final ItemGroup equipmentPartsGroup = new LMEquipmentPartsGroup("lycanitesmobs.equipmentparts");

    public static ItemManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ItemManager();
        }
        return INSTANCE;
    }

    public void startup(ModInfo modInfo) {
        this.loadItems();
        this.loadAllFromJson(modInfo);
    }

    public void loadAllFromJson(ModInfo modInfo) {
        if (!this.loadedGroups.contains(modInfo)) {
            this.loadedGroups.add(modInfo);
        }
        this.loadAllJson(modInfo, "Items", "items", "name", true, null, FileLoader.COMMON, StreamLoader.COMMON);
        LycanitesMobs.logDebug("Items", "Complete! " + this.items.size() + " JSON Items Loaded In Total.");
    }

    @Override
    public void parseJson(ModInfo modInfo, String loadGroup, JsonObject json) {
        ItemInfo itemInfo = new ItemInfo(modInfo);
        itemInfo.loadFromJSON(json);
        this.items.put(itemInfo.name, itemInfo);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        for (ItemInfo itemInfo : this.items.values()) {
            LycanitesMobs.logDebug("Item", "Registering item: " + itemInfo.getName());
            event.getRegistry().register((IForgeRegistryEntry)itemInfo.getItem());
        }
    }

    public void loadConfig() {
        ItemConfig.loadGlobalSettings();
    }

    public void loadItems() {
        ModInfo modInfo = LycanitesMobs.modInfo;
        Item.Properties itemProperties = new Item.Properties().func_200916_a(this.itemsGroup);
        ObjectManager.addItem("soulgazer", new ItemSoulgazer(new Item.Properties().func_200917_a(1).func_200916_a(this.itemsGroup)));
        ObjectManager.addItem("mobtoken", new ItemMobToken(new Item.Properties(), modInfo));
        ObjectManager.addItem("soulstone", new ItemSoulstone(itemProperties, null));
        Item.Properties equipmentProperties = new Item.Properties().func_200917_a(1).setNoRepair().setTEISR(() -> EquipmentRenderer::new);
        ObjectManager.addItem("equipment", new ItemEquipment(equipmentProperties));
        ObjectManager.addItem("soulkey", new ItemSoulkey(itemProperties, "soulkey", 0));
        ObjectManager.addItem("soulkeydiamond", new ItemSoulkey(itemProperties, "soulkeydiamond", 1));
        ObjectManager.addItem("soulkeyemerald", new ItemSoulkey(itemProperties, "soulkeyemerald", 2));
        ObjectManager.addBlock("summoningpedestal", new BlockSummoningPedestal(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(5.0f, 10.0f).func_200947_a(SoundType.field_185852_e), modInfo));
        ObjectManager.addBlock("equipmentforge_lesser", new BlockEquipmentForge(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(5.0f, 10.0f).func_200947_a(SoundType.field_185848_a), modInfo, 1));
        ObjectManager.addBlock("equipmentforge_greater", new BlockEquipmentForge(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(5.0f, 20.0f).func_200947_a(SoundType.field_185851_d), modInfo, 2));
        ObjectManager.addBlock("equipmentforge_master", new BlockEquipmentForge(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(5.0f, 1000.0f).func_200947_a(SoundType.field_185852_e), modInfo, 3));
        ObjectManager.addItem("immunizer", new ItemImmunizer(itemProperties));
        ObjectManager.addItem("cleansingcrystal", new ItemCleansingCrystal(itemProperties));
        ObjectManager.addItem("halloweentreat", new ItemHalloweenTreat(itemProperties));
        ObjectManager.addItem("wintergift", new ItemWinterGift(itemProperties));
        ObjectManager.addItem("wintergiftlarge", new ItemWinterGiftLarge(itemProperties));
        ObjectManager.addItem("frostyfur", new ItemBlockPlacer(itemProperties, "frostyfur", "frostcloud"));
        ObjectManager.addItem("poisongland", new ItemBlockPlacer(itemProperties, "poisongland", "poisoncloud"));
        ObjectManager.addItem("geistliver", new ItemBlockPlacer(itemProperties, "geistliver", "shadowfire"));
        Item.Properties summoningStaffProperties = new Item.Properties().func_200916_a(this.itemsGroup).func_200917_a(1).func_200918_c(500);
        ObjectManager.addItem("summoningstaff", new ItemStaffSummoning(summoningStaffProperties, "summoningstaff", "summoningstaff"));
        ObjectManager.addItem("stablesummoningstaff", new ItemStaffStable(summoningStaffProperties, "stablesummoningstaff", "staffstable"));
        ObjectManager.addItem("bloodsummoningstaff", new ItemStaffBlood(summoningStaffProperties, "bloodsummoningstaff", "staffblood"));
        ObjectManager.addItem("sturdysummoningstaff", new ItemStaffSturdy(summoningStaffProperties, "sturdysummoningstaff", "staffsturdy"));
        ObjectManager.addItem("savagesummoningstaff", new ItemStaffSavage(summoningStaffProperties, "savagesummoningstaff", "staffsavage"));
        BlockMaker.addStoneBlocks(modInfo, "lush", Blocks.field_196804_gh);
        BlockMaker.addStoneBlocks(modInfo, "desert", Blocks.field_150322_A);
        BlockMaker.addStoneBlocks(modInfo, "shadow", Blocks.field_150343_Z);
        BlockMaker.addStoneBlocks(modInfo, "demon", Items.field_151075_bm);
        ObjectManager.addBlock("soulcubedemonic", new BlockBase(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d), modInfo, "soulcubedemonic"));
        ObjectManager.addBlock("soulcubeundead", new BlockBase(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d), modInfo, "soulcubeundead"));
        ObjectManager.addBlock("propolis", new BlockVeswax(Block.Properties.func_200945_a((Material)Material.field_151571_B).func_200947_a(SoundType.field_211382_m).func_200943_b(0.6f).func_200944_c(), "propolis"));
        ObjectManager.addBlock("veswax", new BlockVeswax(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_185848_a).func_200943_b(0.6f).func_200944_c(), "veswax"));
        Block.Properties fireProperties = Block.Properties.func_200945_a((Material)Material.field_151581_o).func_200944_c().func_200942_a().func_208770_d().func_200947_a(SoundType.field_185854_g);
        ObjectManager.addSound("frostfire", modInfo, "block.frostfire");
        ObjectManager.addBlock("frostfire", new BlockFrostfire(fireProperties));
        ObjectManager.addSound("icefire", modInfo, "block.icefire");
        ObjectManager.addBlock("icefire", new BlockIcefire(fireProperties));
        ObjectManager.addSound("hellfire", modInfo, "block.hellfire");
        ObjectManager.addBlock("hellfire", new BlockHellfire(fireProperties));
        ObjectManager.addSound("doomfire", modInfo, "block.doomfire");
        ObjectManager.addBlock("doomfire", new BlockDoomfire(fireProperties));
        ObjectManager.addSound("scorchfire", modInfo, "block.scorchfire");
        ObjectManager.addBlock("scorchfire", new BlockScorchfire(fireProperties));
        ObjectManager.addSound("shadowfire", modInfo, "block.shadowfire");
        ObjectManager.addBlock("shadowfire", new BlockShadowfire(fireProperties));
        Block.Properties cloudProperties = Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200944_c().func_200942_a().func_208770_d().func_200947_a(SoundType.field_185854_g);
        ObjectManager.addSound("frostcloud", modInfo, "block.frostcloud");
        ObjectManager.addBlock("frostcloud", new BlockFrostCloud(cloudProperties));
        ObjectManager.addSound("poisoncloud", modInfo, "block.poisoncloud");
        ObjectManager.addBlock("poisoncloud", new BlockPoisonCloud(cloudProperties));
        ObjectManager.addSound("poopcloud", modInfo, "block.poopcloud");
        ObjectManager.addBlock("poopcloud", new BlockPoopCloud(cloudProperties));
        Block.Properties webProperties = Block.Properties.func_200945_a((Material)Material.field_151569_G).func_200944_c().func_200942_a().func_208770_d().func_200947_a(SoundType.field_185854_g);
        ObjectManager.addBlock("quickweb", new BlockQuickWeb(webProperties));
        ObjectManager.addBlock("frostweb", new BlockFrostweb(webProperties));
        Block.Properties waterBlockProperties = Block.Properties.func_200945_a((Material)Material.field_151586_h).func_200942_a().func_200943_b(100.0f).func_222380_e();
        Block.Properties lavaBlockProperties = Block.Properties.func_200945_a((Material)Material.field_151587_i).func_200942_a().func_200943_b(100.0f).func_222380_e();
        this.addFluid("ooze", 15007, 3000, 3000, 0, 5, true);
        ObjectManager.addBlock("ooze", (Block)new BlockFluidOoze(() -> (FlowingFluid)ObjectManager.getFluid("ooze").get(), waterBlockProperties, "ooze"));
        ObjectManager.addDamageSource("ooze", new DamageSource("ooze"));
        this.addFluid("moglava", 16733986, 3000, 5000, 1100, 15, true);
        ObjectManager.addBlock("moglava", (Block)new BlockFluidMoglava(() -> (FlowingFluid)ObjectManager.getFluid("moglava").get(), waterBlockProperties, "moglava"));
        this.addFluid("acid", 9159498, 1000, 10, 40, 10, true);
        ObjectManager.addBlock("acid", (Block)new BlockFluidAcid(() -> (FlowingFluid)ObjectManager.getFluid("acid").get(), waterBlockProperties, "acid"));
        ObjectManager.addDamageSource("acid", new DamageSource("acid"));
        this.addFluid("poison", 10233776, 1000, 8, 20, 0, true);
        ObjectManager.addBlock("poison", (Block)new BlockFluidPoison(() -> (FlowingFluid)ObjectManager.getFluid("poison").get(), waterBlockProperties, "poison"));
    }

    public void addFluid(String fluidName, int fluidColor, int density, int viscosity, int temperature, int luminosity, boolean multiply) {
        FluidAttributes.Builder fluidBuilder = FluidAttributes.builder((ResourceLocation)new ResourceLocation("lycanitesmobs", "block/" + fluidName + "_still"), (ResourceLocation)new ResourceLocation("lycanitesmobs", "block/" + fluidName + "_flowing"));
        fluidBuilder.color(fluidColor);
        fluidBuilder.density(density);
        fluidBuilder.viscosity(viscosity);
        fluidBuilder.temperature(temperature);
        fluidBuilder.luminosity(luminosity);
        Supplier<FlowingFluid> flowingFluidSupplier = () -> (FlowingFluid)ObjectManager.getFluid(fluidName).get();
        ForgeFlowingFluid.Properties fluidProperties = new ForgeFlowingFluid.Properties(flowingFluidSupplier, () -> (FlowingFluid)ObjectManager.getFluid(fluidName + "_flowing").get(), fluidBuilder);
        if (multiply) {
            fluidProperties.canMultiply();
        }
        fluidProperties.bucket(() -> ObjectManager.getItem("bucket" + fluidName));
        fluidProperties.block(() -> (FlowingFluidBlock)ObjectManager.getBlock(fluidName));
        ObjectManager.addFluid(fluidName, (RegistryObject<FlowingFluid>)FLUIDS.register(fluidName, () -> new ForgeFlowingFluid.Source(fluidProperties)));
        ObjectManager.addFluid(fluidName + "_flowing", (RegistryObject<FlowingFluid>)FLUIDS.register(fluidName + "_flowing", () -> new ForgeFlowingFluid.Flowing(fluidProperties)));
        ObjectManager.addSound(fluidName, LycanitesMobs.modInfo, "block." + fluidName);
        Item.Properties bucketProperties = new Item.Properties().func_200916_a(this.itemsGroup).func_200919_a(Items.field_151133_ar).func_200917_a(1);
        ObjectManager.addItem("bucket" + fluidName, (Item)new BucketItem(flowingFluidSupplier, bucketProperties).setRegistryName("lycanitesmobs", "bucket" + fluidName));
    }

    static {
        FLUIDS = new DeferredRegister(ForgeRegistries.FLUIDS, "lycanitesmobs");
    }
}

