/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ItemDrop {
    protected String itemId;
    protected String burningItemId;
    protected Map<Integer, String> effectItemIds = new HashMap<Integer, String>();
    public int minAmount = 1;
    public int maxAmount = 1;
    public boolean bonusAmount = true;
    public float chance = 0.0f;
    public int subspeciesID = -1;

    public static ItemDrop createFromJSON(JsonObject json) {
        ItemDrop itemDrop = null;
        if (json.has("item")) {
            String itemId = json.get("item").getAsString();
            itemDrop = new ItemDrop(itemId, 1.0f);
            itemDrop.loadFromJSON(json);
        } else {
            LycanitesMobs.logWarning("", "[JSON] Unable to load item drop from json as it has no item id!");
        }
        return itemDrop;
    }

    public static ItemDrop createFromConfigString(String itemDropString) {
        if (itemDropString != null && itemDropString.length() > 0) {
            String[] customDropValues = itemDropString.split(",");
            String itemId = customDropValues[0];
            int itemMetadata = 0;
            if (customDropValues.length > 1) {
                itemMetadata = Integer.parseInt(customDropValues[1]);
            }
            int amountMin = 1;
            if (customDropValues.length > 2) {
                amountMin = Integer.parseInt(customDropValues[2]);
            }
            int amountMax = 1;
            if (customDropValues.length > 3) {
                amountMax = Integer.parseInt(customDropValues[3]);
            }
            float chance = 1.0f;
            if (customDropValues.length > 4) {
                chance = Float.parseFloat(customDropValues[4]);
            }
            ItemDrop itemDrop = new ItemDrop(itemId, chance);
            itemDrop.setMinAmount(amountMin);
            itemDrop.setMaxAmount(amountMax);
            return itemDrop;
        }
        return null;
    }

    public ItemDrop(String itemId, float chance) {
        this.itemId = itemId;
        this.chance = chance;
    }

    public ItemDrop(CompoundNBT nbtTagCompound) {
        this.read(nbtTagCompound);
    }

    public void loadFromJSON(JsonObject json) {
        if (json.has("minAmount")) {
            this.minAmount = json.get("minAmount").getAsInt();
        }
        if (json.has("maxAmount")) {
            this.maxAmount = json.get("maxAmount").getAsInt();
        }
        if (json.has("bonusAmount")) {
            this.bonusAmount = json.get("bonusAmount").getAsBoolean();
        }
        if (json.has("chance")) {
            this.chance = json.get("chance").getAsFloat();
        }
        if (json.has("subspecies")) {
            this.subspeciesID = json.get("subspecies").getAsInt();
        }
        if (json.has("burningItem")) {
            this.burningItemId = json.get("burningItem").getAsString();
        }
    }

    public ItemDrop setDrop(ItemStack itemStack) {
        this.itemId = itemStack.func_77973_b().getRegistryName().toString();
        return this;
    }

    public ItemDrop setBurningDrop(ItemStack itemStack) {
        this.burningItemId = itemStack.func_77973_b().getRegistryName().toString();
        return this;
    }

    public ItemDrop setEffectDrop(int effectID, ItemStack itemStack) {
        this.effectItemIds.put(effectID, itemStack.func_77973_b().getRegistryName().toString());
        return this;
    }

    public ItemDrop setMinAmount(int amount) {
        this.minAmount = amount;
        return this;
    }

    public ItemDrop setMaxAmount(int amount) {
        this.maxAmount = amount;
        return this;
    }

    public ItemDrop setChance(float chance) {
        this.chance = chance;
        return this;
    }

    public ItemDrop setSubspecies(int subspeciesID) {
        this.subspeciesID = subspeciesID;
        return this;
    }

    public int getQuantity(Random random, int bonus, int multiplier) {
        int min;
        float roll = random.nextFloat();
        if ((roll = Math.max(roll, 0.0f)) > this.chance) {
            return 0;
        }
        int max = this.maxAmount + (this.bonusAmount ? bonus : 0);
        if (max <= (min = this.minAmount)) {
            return min * multiplier;
        }
        float dropRange = (float)(max - min) * (roll /= this.chance);
        int dropAmount = min + Math.round(dropRange);
        return Math.min(dropAmount * multiplier, this.getItemStack().func_77976_d());
    }

    @Nonnull
    public ItemStack getItemStack() {
        if (this.itemId == null) {
            return ItemStack.field_190927_a;
        }
        Item item = (Item)GameRegistry.findRegistry(Item.class).getValue(new ResourceLocation(this.itemId));
        if (item != null) {
            return new ItemStack((IItemProvider)item, 1);
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack getBurningItemStack() {
        if (this.burningItemId == null) {
            return this.getItemStack();
        }
        Item item = (Item)GameRegistry.findRegistry(Item.class).getValue(new ResourceLocation(this.burningItemId));
        if (item != null) {
            return new ItemStack((IItemProvider)item, 1);
        }
        return this.getItemStack();
    }

    @Nonnull
    public ItemStack getEffectItemStack(int effectId) {
        if (!this.effectItemIds.containsKey(effectId)) {
            return ItemStack.field_190927_a;
        }
        Item item = (Item)GameRegistry.findRegistry(Item.class).getValue(new ResourceLocation(this.effectItemIds.get(effectId)));
        if (item != null) {
            return new ItemStack((IItemProvider)item, 1);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getEntityDropItemStack(LivingEntity entity, int quantity) {
        ItemStack itemStack = this.getItemStack();
        if (entity != null) {
            if (entity.func_70027_ad()) {
                itemStack = this.getBurningItemStack();
            }
            for (Object potionEffect : entity.func_70651_bq()) {
                int effectId;
                ItemStack effectStack;
                if (!(potionEffect instanceof EffectInstance) || (effectStack = this.getEffectItemStack(effectId = Effect.func_188409_a((Effect)((EffectInstance)potionEffect).func_188419_a()))).func_190926_b()) continue;
                itemStack = effectStack;
            }
        }
        if (itemStack != null) {
            itemStack.func_190920_e(quantity);
        }
        return itemStack;
    }

    public void read(CompoundNBT nbtTagCompound) {
        if (nbtTagCompound.func_74764_b("ItemId")) {
            this.itemId = nbtTagCompound.func_74779_i("ItemId");
        }
        this.minAmount = nbtTagCompound.func_74762_e("MinAmount");
        this.maxAmount = nbtTagCompound.func_74762_e("MaxAmount");
        if (nbtTagCompound.func_74764_b("BonusAmount")) {
            this.bonusAmount = nbtTagCompound.func_74767_n("BonusAmount");
        }
        this.chance = nbtTagCompound.func_74760_g("Chance");
    }

    public boolean writeToNBT(CompoundNBT nbtTagCompound) {
        if (this.itemId == null) {
            return false;
        }
        nbtTagCompound.func_74778_a("ItemId", this.itemId);
        nbtTagCompound.func_74768_a("MinAmount", this.minAmount);
        nbtTagCompound.func_74768_a("MaxAmount", this.maxAmount);
        nbtTagCompound.func_74757_a("BonusAmount", this.bonusAmount);
        nbtTagCompound.func_74776_a("Chance", this.chance);
        return true;
    }

    public String toConfigString() {
        return this.itemId + "," + this.minAmount + "," + this.maxAmount + "," + this.chance;
    }
}

