/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.FileLoader;
import com.lycanitesmobs.core.JSONLoader;
import com.lycanitesmobs.core.StreamLoader;
import com.lycanitesmobs.core.config.ConfigCreatures;
import com.lycanitesmobs.core.entity.CreatureStats;
import com.lycanitesmobs.core.info.CreatureConfig;
import com.lycanitesmobs.core.info.CreatureGroup;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureSpawnConfig;
import com.lycanitesmobs.core.info.CreatureType;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.spawner.SpawnerMobRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CreatureManager
extends JSONLoader {
    public static CreatureManager INSTANCE;
    public static String[] DIFFICULTY_NAMES;
    public static double[] DIFFICULTY_DEFAULTS;
    public CreatureConfig config;
    public CreatureSpawnConfig spawnConfig;
    public Map<String, CreatureType> creatureTypes = new HashMap<String, CreatureType>();
    public Map<String, CreatureGroup> creatureGroups = new HashMap<String, CreatureGroup>();
    public Map<String, CreatureInfo> creatures = new HashMap<String, CreatureInfo>();
    public Map<Class, CreatureInfo> creatureClassMap = new HashMap<Class, CreatureInfo>();
    public List<ModInfo> loadedMods = new ArrayList<ModInfo>();
    public Map<String, Double> difficultyMultipliers = new HashMap<String, Double>();
    public Map<String, Double> levelMultipliers = new HashMap<String, Double>();
    public double tamedHealthMultiplier = 3.0;
    public boolean dlDungeonsLoaded = false;

    public static CreatureManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CreatureManager();
        }
        return INSTANCE;
    }

    public CreatureManager() {
        this.config = new CreatureConfig();
        this.spawnConfig = new CreatureSpawnConfig();
    }

    public void startup(ModInfo modInfo) {
        this.loadCreatureTypesFromJSON(modInfo);
        this.loadCreatureGroupsFromJSON(modInfo);
        this.loadCreaturesFromJSON(modInfo);
        for (CreatureType creatureType : this.creatureTypes.values()) {
            creatureType.init();
        }
        for (CreatureGroup creatureGroup : this.creatureGroups.values()) {
            creatureGroup.init();
        }
        for (CreatureInfo creatureInfo : this.creatures.values()) {
            creatureInfo.init();
        }
    }

    public void loadCreatureTypesFromJSON(ModInfo modInfo) {
        this.loadAllJson(modInfo, "Creature Type", "creaturetypes", "name", true, null, FileLoader.COMMON, StreamLoader.COMMON);
        LycanitesMobs.logDebug("Creature", "Complete! " + this.creatureTypes.size() + " JSON Creature Types Loaded In Total.");
    }

    public void loadCreatureGroupsFromJSON(ModInfo modInfo) {
        this.loadAllJson(modInfo, "Creature Group", "creaturegroups", "name", true, null, FileLoader.COMMON, StreamLoader.COMMON);
        LycanitesMobs.logDebug("Creature", "Complete! " + this.creatureGroups.size() + " JSON Creature Groups Loaded In Total.");
    }

    public void loadCreaturesFromJSON(ModInfo modInfo) {
        try {
            if (!this.loadedMods.contains(modInfo)) {
                this.loadedMods.add(modInfo);
            }
            this.loadAllJson(modInfo, "Creature", "creatures", "name", true, null, FileLoader.COMMON, StreamLoader.COMMON);
            LycanitesMobs.logDebug("Creature", "Complete! " + this.creatures.size() + " JSON Creatures Loaded In Total.");
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "No Creatures loaded for: " + modInfo.name);
        }
    }

    @Override
    public void parseJson(ModInfo modInfo, String loadGroup, JsonObject json) {
        if ("Creature Type".equals(loadGroup)) {
            CreatureType creatureType = new CreatureType(modInfo);
            creatureType.loadFromJson(json);
            if (this.creatureTypes.containsKey(creatureType.name)) {
                creatureType = this.creatureTypes.get(creatureType.name);
                creatureType.loadFromJson(json);
            }
            this.creatureTypes.put(creatureType.name, creatureType);
            return;
        }
        if ("Creature Group".equals(loadGroup)) {
            CreatureGroup creatureGroup = new CreatureGroup();
            creatureGroup.loadFromJson(json);
            if (this.creatureGroups.containsKey(creatureGroup.name)) {
                creatureGroup = this.creatureGroups.get(creatureGroup.name);
                creatureGroup.loadFromJson(json);
            }
            this.creatureGroups.put(creatureGroup.name, creatureGroup);
            return;
        }
        if ("Creature".equals(loadGroup)) {
            CreatureInfo creatureInfo = new CreatureInfo(modInfo);
            creatureInfo.loadFromJson(json);
            if (this.creatures.containsKey(creatureInfo.name)) {
                creatureInfo = this.creatures.get(creatureInfo.name);
                creatureInfo.loadFromJson(json);
            }
            this.creatures.put(creatureInfo.name, creatureInfo);
            this.creatureClassMap.put(creatureInfo.entityClass, creatureInfo);
        }
    }

    public void loadConfig() {
        this.config.loadConfig();
        this.spawnConfig.loadConfig();
        this.difficultyMultipliers = new HashMap<String, Double>();
        for (String difficultyName : DIFFICULTY_NAMES) {
            for (String statName : CreatureStats.STAT_NAMES) {
                this.difficultyMultipliers.put((difficultyName + "-" + statName).toUpperCase(), (Double)ConfigCreatures.INSTANCE.difficultyMultipliers.get(difficultyName).get(statName).get());
            }
        }
        for (String statName : CreatureStats.STAT_NAMES) {
            this.levelMultipliers.put(statName.toUpperCase(), (Double)ConfigCreatures.INSTANCE.levelMultipliers.get(statName).get());
        }
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        LycanitesMobs.logDebug("Creature", "Forge registering all " + this.creatures.size() + " creatures...");
        for (CreatureInfo creatureInfo : this.creatures.values()) {
            event.getRegistry().register(creatureInfo.getEntityType());
        }
    }

    public void reload() {
        this.loadConfig();
        SpawnerMobRegistry.SPAWNER_MOB_REGISTRIES.clear();
        for (ModInfo group : this.loadedMods) {
            this.loadCreaturesFromJSON(group);
        }
    }

    public CreatureType getCreatureType(String creatureTypeName) {
        if (!this.creatureTypes.containsKey(creatureTypeName)) {
            return null;
        }
        return this.creatureTypes.get(creatureTypeName);
    }

    public CreatureGroup getCreatureGroup(String creatureGroupName) {
        if (!this.creatureGroups.containsKey(creatureGroupName)) {
            return null;
        }
        return this.creatureGroups.get(creatureGroupName);
    }

    @Nullable
    public CreatureInfo getCreature(String creatureName) {
        if (!this.creatures.containsKey(creatureName)) {
            return null;
        }
        return this.creatures.get(creatureName);
    }

    public CreatureInfo getCreature(Class creatureClass) {
        if (!this.creatureClassMap.containsKey(creatureClass)) {
            return null;
        }
        return this.creatureClassMap.get(creatureClass);
    }

    @Nullable
    public EntityType<? extends LivingEntity> getEntityType(String creatureName) {
        CreatureInfo creatureInfo = this.getCreature(creatureName);
        if (creatureInfo == null) {
            return null;
        }
        return creatureInfo.getEntityType();
    }

    public CreatureInfo getCreatureFromId(String entityId) {
        entityId = entityId.replace(".", ":");
        String[] mobIdParts = entityId.toLowerCase().split(":");
        return this.getCreature(mobIdParts[mobIdParts.length - 1]);
    }

    public double getDifficultyMultiplier(String difficultyName, String statName) {
        String key = difficultyName.toUpperCase() + "-" + statName.toUpperCase();
        if (!this.difficultyMultipliers.containsKey(key)) {
            return 1.0;
        }
        return this.difficultyMultipliers.get(key);
    }

    public double getLevelMultiplier(String statName) {
        if (!this.levelMultipliers.containsKey(statName.toUpperCase())) {
            return 1.0;
        }
        return this.levelMultipliers.get(statName.toUpperCase());
    }

    static {
        DIFFICULTY_NAMES = new String[]{"easy", "normal", "hard"};
        DIFFICULTY_DEFAULTS = new double[]{0.8, 1.0, 1.1};
    }
}

