/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.entity.FearEntity;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureKnowledge;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.CreatureType;
import com.lycanitesmobs.core.network.MessageBeastiary;
import com.lycanitesmobs.core.network.MessageCreatureKnowledge;
import com.lycanitesmobs.core.pets.SummonSet;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class Beastiary {
    public ExtendedPlayer extendedPlayer;
    public Map<String, CreatureKnowledge> creatureKnowledgeList = new HashMap<String, CreatureKnowledge>();

    public Beastiary(ExtendedPlayer extendedPlayer) {
        this.extendedPlayer = extendedPlayer;
    }

    public int addCreatureKnowledge(CreatureKnowledge newKnowledge) {
        CreatureInfo creatureInfo = CreatureManager.getInstance().getCreature(newKnowledge.creatureName);
        if (creatureInfo == null) {
            return 0;
        }
        if (creatureInfo.dummy) {
            return 0;
        }
        CreatureKnowledge currentKnowledge = this.getCreatureKnowledge(creatureInfo.getName());
        if (currentKnowledge != null) {
            if (currentKnowledge.rank >= newKnowledge.rank) {
                return 0;
            }
            int rankIncrease = newKnowledge.rank - currentKnowledge.rank;
            currentKnowledge.rank = newKnowledge.rank;
            return rankIncrease;
        }
        this.creatureKnowledgeList.put(newKnowledge.creatureName, newKnowledge);
        return newKnowledge.rank;
    }

    public boolean discoverCreature(Entity entity, int rank, boolean knownMessage) {
        if (!(entity instanceof BaseCreatureEntity)) {
            if (!this.extendedPlayer.player.func_130014_f_().field_72995_K) {
                this.extendedPlayer.player.func_145747_a((ITextComponent)new TranslationTextComponent("message.beastiary.unknown", new Object[0]));
            }
            return false;
        }
        if (entity instanceof FearEntity) {
            return false;
        }
        CreatureInfo creatureInfo = ((BaseCreatureEntity)entity).creatureInfo;
        CreatureKnowledge newKnowledge = new CreatureKnowledge(this.extendedPlayer.getBeastiary(), creatureInfo.getName(), rank);
        int rankChange = this.extendedPlayer.getBeastiary().addCreatureKnowledge(newKnowledge);
        if (rankChange <= 0) {
            if (knownMessage) {
                this.sendKnownMessage(newKnowledge);
            }
            return false;
        }
        this.sendAddedMessage(newKnowledge);
        this.sendToClient(newKnowledge);
        if (this.extendedPlayer.player.func_130014_f_().field_72995_K) {
            for (int i = 0; i < 32; ++i) {
                entity.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197632_y, entity.func_213303_ch().func_82615_a() + (double)(4.0f * this.extendedPlayer.player.func_70681_au().nextFloat()) - 2.0, entity.func_213303_ch().func_82617_b() + (double)(4.0f * this.extendedPlayer.player.func_70681_au().nextFloat()) - 2.0, entity.func_213303_ch().func_82616_c() + (double)(4.0f * this.extendedPlayer.player.func_70681_au().nextFloat()) - 2.0, 0.0, 0.0, 0.0);
            }
        }
        return true;
    }

    public void sendAddedMessage(CreatureKnowledge creatureKnowledge) {
        if (this.extendedPlayer.player.func_130014_f_().field_72995_K || !CreatureManager.getInstance().config.beastiaryKnowledgeMessages) {
            return;
        }
        CreatureInfo creatureInfo = creatureKnowledge.getCreatureInfo();
        ITextComponent message = new TranslationTextComponent("message.beastiary.new.prefix", new Object[0]).func_150258_a(" " + creatureKnowledge.rank + " ").func_150257_a((ITextComponent)new TranslationTextComponent("message.beastiary.new.of", new Object[0])).func_150258_a(" ").func_150257_a(creatureInfo.getTitle()).func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent("message.beastiary.new.suffix", new Object[0]));
        this.extendedPlayer.player.func_145747_a(message);
        if (creatureInfo.isSummonable()) {
            ITextComponent summonMessage = new TranslationTextComponent("message.beastiary.summonable.prefix", new Object[0]).func_150258_a(" ").func_150257_a(creatureInfo.getTitle()).func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent("message.beastiary.summonable.suffix", new Object[0]));
            if (creatureKnowledge.rank >= 3) {
                summonMessage = new TranslationTextComponent("message.beastiary.summonable.skins.prefix", new Object[0]).func_150258_a(" ").func_150257_a(creatureInfo.getTitle()).func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent("message.beastiary.summonable.skins.suffix", new Object[0]));
            } else if (creatureKnowledge.rank == 2) {
                summonMessage = new TranslationTextComponent("message.beastiary.summonable.colors.prefix", new Object[0]).func_150258_a(" ").func_150257_a(creatureInfo.getTitle()).func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent("message.beastiary.summonable.colors.suffix", new Object[0]));
            }
            this.extendedPlayer.player.func_145747_a(summonMessage);
        }
    }

    public void sendKnownMessage(CreatureKnowledge creatureKnowledge) {
        if (this.extendedPlayer.player.func_130014_f_().field_72995_K) {
            return;
        }
        CreatureInfo creatureInfo = creatureKnowledge.getCreatureInfo();
        CreatureKnowledge currentKnowledge = this.extendedPlayer.getBeastiary().getCreatureKnowledge(creatureInfo.getName());
        ITextComponent message = new TranslationTextComponent("message.beastiary.known.prefix", new Object[0]).func_150258_a(" " + currentKnowledge.rank + " ").func_150257_a((ITextComponent)new TranslationTextComponent("message.beastiary.known.of", new Object[0])).func_150258_a(" ").func_150257_a(creatureInfo.getTitle()).func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent("message.beastiary.known.suffix", new Object[0]));
        this.extendedPlayer.player.func_145747_a(message);
    }

    @Nullable
    public CreatureKnowledge getCreatureKnowledge(String creatureName) {
        if (!this.creatureKnowledgeList.containsKey(creatureName)) {
            return null;
        }
        return this.creatureKnowledgeList.get(creatureName);
    }

    public boolean hasKnowledgeRank(String creatureName, int rank) {
        CreatureKnowledge creatureKnowledge = this.getCreatureKnowledge(creatureName);
        if (creatureKnowledge == null) {
            return false;
        }
        return creatureKnowledge.rank >= rank;
    }

    public int getCreaturesDescovered(CreatureType creatureType) {
        if (this.creatureKnowledgeList.size() == 0) {
            return 0;
        }
        int creaturesDescovered = 0;
        for (Map.Entry<String, CreatureKnowledge> creatureKnowledgeEntry : this.creatureKnowledgeList.entrySet()) {
            if (creatureKnowledgeEntry.getValue() == null || creatureKnowledgeEntry.getValue().getCreatureInfo().creatureType != creatureType) continue;
            ++creaturesDescovered;
        }
        return creaturesDescovered;
    }

    public Map<Integer, String> getSummonableList() {
        HashMap<Integer, String> minionList = new HashMap<Integer, String>();
        int minionIndex = 0;
        for (String minionName : this.creatureKnowledgeList.keySet()) {
            if (!SummonSet.isSummonableCreature(minionName)) continue;
            minionList.put(minionIndex++, minionName);
        }
        return minionList;
    }

    public void sendToClient(CreatureKnowledge newKnowledge) {
        if (this.extendedPlayer.player.func_130014_f_().field_72995_K) {
            return;
        }
        MessageCreatureKnowledge message = new MessageCreatureKnowledge(newKnowledge);
        LycanitesMobs.packetHandler.sendToPlayer(message, (ServerPlayerEntity)this.extendedPlayer.getPlayer());
    }

    public void sendAllToClient() {
        MessageBeastiary message = new MessageBeastiary(this);
        LycanitesMobs.packetHandler.sendToPlayer(message, (ServerPlayerEntity)this.extendedPlayer.getPlayer());
    }

    public void readFromNBT(CompoundNBT nbtTagCompound) {
        if (!nbtTagCompound.func_74764_b("CreatureKnowledge")) {
            return;
        }
        this.creatureKnowledgeList.clear();
        ListNBT knowledgeList = nbtTagCompound.func_150295_c("CreatureKnowledge", 10);
        for (int i = 0; i < knowledgeList.size(); ++i) {
            CompoundNBT nbtKnowledge = knowledgeList.func_150305_b(i);
            if (!nbtKnowledge.func_74764_b("CreatureName")) continue;
            String creatureName = nbtKnowledge.func_74779_i("CreatureName");
            int rank = 0;
            if (nbtKnowledge.func_74764_b("Rank")) {
                rank = nbtKnowledge.func_74762_e("Rank");
            } else if (nbtKnowledge.func_74764_b("Completion")) {
                rank = 2;
            }
            CreatureKnowledge creatureKnowledge = new CreatureKnowledge(this, creatureName, rank);
            this.addCreatureKnowledge(creatureKnowledge);
        }
    }

    public void writeToNBT(CompoundNBT nbtTagCompound) {
        ListNBT knowledgeList = new ListNBT();
        for (Map.Entry<String, CreatureKnowledge> creatureKnowledgeEntry : this.creatureKnowledgeList.entrySet()) {
            CreatureKnowledge creatureKnowledge = creatureKnowledgeEntry.getValue();
            CompoundNBT nbtKnowledge = new CompoundNBT();
            nbtKnowledge.func_74778_a("CreatureName", creatureKnowledge.creatureName);
            nbtKnowledge.func_74768_a("Rank", creatureKnowledge.rank);
            knowledgeList.add((Object)nbtKnowledge);
        }
        nbtTagCompound.func_218657_a("CreatureKnowledge", (INBT)knowledgeList);
    }
}

