/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.projectile;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupBoss;
import com.lycanitesmobs.core.EffectBase;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.creature.EntityRahovart;
import com.lycanitesmobs.core.info.ObjectLists;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityShadowfireBarrier
extends BaseProjectileEntity {
    public Entity shootingEntity;

    public EntityShadowfireBarrier(EntityType<? extends BaseProjectileEntity> entityType, World world) {
        super(entityType, world);
    }

    public EntityShadowfireBarrier(EntityType<? extends BaseProjectileEntity> entityType, World world, LivingEntity par2LivingEntity) {
        super(entityType, world, par2LivingEntity);
    }

    public EntityShadowfireBarrier(EntityType<? extends BaseProjectileEntity> entityType, World world, double par2, double par4, double par6) {
        super(entityType, world, par2, par4, par6);
    }

    @Override
    public void setup() {
        this.entityName = "shadowfirebarrier";
        this.modInfo = LycanitesMobs.modInfo;
        this.setDamage(10);
        this.setProjectileScale(20.0f);
        this.movement = false;
        this.ripper = true;
        this.pierceBlocks = true;
        this.projectileLife = 40;
        this.animationFrameMax = 19;
        this.textureTiling = 2;
        this.field_70145_X = true;
        this.waterProof = true;
        this.lavaProof = true;
    }

    public boolean func_70027_ad() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_130014_f_().field_72995_K) {
            List list = this.func_130014_f_().func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(this.func_213322_ci().func_82615_a(), this.func_213322_ci().func_82617_b(), this.func_213322_ci().func_82616_c()).func_72321_a(1.0, 1.0, 1.0));
            for (int j = 0; j < list.size(); ++j) {
                Entity entity = (Entity)list.get(j);
                this.func_70184_a((RayTraceResult)new EntityRayTraceResult(entity));
            }
        }
    }

    @Override
    public boolean func_70072_I() {
        return false;
    }

    @Override
    public boolean onEntityLivingDamage(LivingEntity livingEntity) {
        EffectInstance blindness;
        EffectInstance effect;
        EffectBase decay = ObjectManager.getEffect("decay");
        if (decay != null && livingEntity.func_70687_e(effect = new EffectInstance((Effect)decay, 100, 0))) {
            livingEntity.func_195064_c(effect);
        }
        if (livingEntity.func_70687_e(blindness = new EffectInstance(Effects.field_76440_q, 100, 0))) {
            livingEntity.func_195064_c(blindness);
        }
        return true;
    }

    @Override
    public boolean canDamage(LivingEntity targetEntity) {
        LivingEntity owner = this.func_85052_h();
        if (owner == null && targetEntity instanceof EntityRahovart) {
            return false;
        }
        return super.canDamage(targetEntity);
    }

    @Override
    public void onDamage(LivingEntity target, float damage, boolean attackSuccess) {
        for (EffectInstance potionEffect : target.func_70651_bq().toArray(new EffectInstance[target.func_70651_bq().size()])) {
            if (!ObjectLists.inEffectList("buffs", potionEffect.func_188419_a())) continue;
            target.func_195063_d(potionEffect.func_188419_a());
        }
        boolean obliterate = true;
        if (target instanceof PlayerEntity) {
            obliterate = false;
        } else if (target instanceof TameableEntity) {
            obliterate = !(((TameableEntity)target).func_70902_q() instanceof PlayerEntity);
        } else if (target instanceof TameableCreatureEntity) {
            boolean bl = obliterate = !(((TameableCreatureEntity)target).getOwner() instanceof PlayerEntity);
        }
        if (target instanceof IGroupBoss) {
            obliterate = false;
        }
        if (obliterate) {
            target.func_70606_j(0.0f);
        }
        super.onDamage(target, damage, attackSuccess);
    }

    @Override
    public SoundEvent getLaunchSound() {
        return ObjectManager.getSound("hellfirewall");
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBrightnessForRender() {
        return 0xF000F0;
    }
}

