/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.projectile;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.info.CreatureManager;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityPoop
extends BaseProjectileEntity {
    public Entity shootingEntity;

    public EntityPoop(EntityType<? extends BaseProjectileEntity> entityType, World world) {
        super(entityType, world);
    }

    public EntityPoop(EntityType<? extends BaseProjectileEntity> entityType, World world, LivingEntity entityLivingBase) {
        super(entityType, world, entityLivingBase);
    }

    public EntityPoop(EntityType<? extends BaseProjectileEntity> entityType, World world, double x, double y, double z) {
        super(entityType, world, x, y, z);
    }

    @Override
    public void setup() {
        this.entityName = "poop";
        this.modInfo = LycanitesMobs.modInfo;
        this.setDamage(2);
        this.setProjectileScale(1.0f);
    }

    @Override
    public boolean onEntityLivingDamage(LivingEntity entityLiving) {
        entityLiving.func_195064_c(new EffectInstance(Effects.field_76421_d, this.getEffectDuration(3), 0));
        entityLiving.func_195064_c(new EffectInstance(Effects.field_76431_k, this.getEffectDuration(5), 0));
        return true;
    }

    @Override
    public boolean canDestroyBlock(BlockPos pos) {
        Block block = this.func_130014_f_().func_180495_p(pos).func_177230_c();
        if (ObjectManager.getBlock("PoisonCloud") != null && block == ObjectManager.getBlock("PoisonCloud")) {
            return true;
        }
        if (ObjectManager.getBlock("PoopCloud") != null && block == ObjectManager.getBlock("PoopCloud")) {
            return true;
        }
        if (ObjectManager.getBlock("FrostCloud") != null && block == ObjectManager.getBlock("FrostCloud")) {
            return true;
        }
        return super.canDestroyBlock(pos);
    }

    @Override
    public void placeBlock(World world, BlockPos pos) {
        world.func_175656_a(pos, ObjectManager.getBlock("poopcloud").func_176223_P());
    }

    @Override
    public void onImpactVisuals() {
        if (this.func_130014_f_().field_72995_K && !CreatureManager.getInstance().config.disableBlockParticles) {
            for (int i = 0; i < 8; ++i) {
                this.func_130014_f_().func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_196661_l.func_176223_P()), this.func_213303_ch().func_82615_a(), this.func_213303_ch().func_82617_b(), this.func_213303_ch().func_82616_c(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public SoundEvent getLaunchSound() {
        return ObjectManager.getSound("poop");
    }
}

