/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.projectile;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.client.TextureManager;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.entity.creature.EntityRahovart;
import com.lycanitesmobs.core.entity.projectile.EntityHellfireBarrierPart;
import com.lycanitesmobs.core.entity.projectile.EntityHellfireWall;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityHellfireBarrier
extends BaseProjectileEntity {
    public EntityHellfireWall[][] hellfireWalls;
    protected int hellfireWidth = 5;
    protected int hellfireHeight = 3;
    protected int hellfireSize = 10;
    public boolean wall = false;
    public int time = 0;
    public int timeMax = 40;
    public float angle = 90.0f;
    public double rotation = 0.0;

    public EntityHellfireBarrier(EntityType<? extends BaseProjectileEntity> entityType, World world) {
        super(entityType, world);
    }

    public EntityHellfireBarrier(EntityType<? extends BaseProjectileEntity> entityType, World world, LivingEntity par2LivingEntity) {
        super(entityType, world, par2LivingEntity);
    }

    public EntityHellfireBarrier(EntityType<? extends BaseProjectileEntity> entityType, World world, double par2, double par4, double par6) {
        super(entityType, world, par2, par4, par6);
    }

    @Override
    public void setup() {
        this.entityName = "hellfirebarrier";
        this.modInfo = LycanitesMobs.modInfo;
        this.setDamage(0);
        this.setProjectileScale(0.0f);
        this.movement = false;
        this.ripper = true;
        this.pierceBlocks = true;
        this.projectileLife = 100;
        this.animationFrameMax = 59;
        this.field_70145_X = true;
    }

    public boolean func_70027_ad() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        double z;
        double x;
        double rotationRadians;
        int col;
        int row;
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.time++ >= this.timeMax) {
            this.func_70106_y();
        }
        if (this.hellfireWalls == null) {
            this.hellfireWalls = new EntityHellfireWall[this.hellfireHeight][this.hellfireWidth];
            for (row = 0; row < this.hellfireHeight; ++row) {
                for (col = 0; col < this.hellfireWidth; ++col) {
                    this.hellfireWalls[row][col] = this.func_85052_h() != null ? (this.wall ? new EntityHellfireWall(ProjectileManager.getInstance().oldProjectileTypes.get(EntityHellfireWall.class), this.func_130014_f_(), this.func_85052_h()) : new EntityHellfireBarrierPart(ProjectileManager.getInstance().oldProjectileTypes.get(EntityHellfireBarrierPart.class), this.func_130014_f_(), this.func_85052_h())) : (this.wall ? new EntityHellfireWall(ProjectileManager.getInstance().oldProjectileTypes.get(EntityHellfireWall.class), this.func_130014_f_(), this.func_213303_ch().func_82615_a(), this.func_213303_ch().func_82617_b() + (double)(this.hellfireSize * row), this.func_213303_ch().func_82616_c()) : new EntityHellfireBarrierPart(ProjectileManager.getInstance().oldProjectileTypes.get(EntityHellfireBarrierPart.class), this.func_130014_f_(), this.func_213303_ch().func_82615_a(), this.func_213303_ch().func_82617_b() + (double)(this.hellfireSize * row), this.func_213303_ch().func_82616_c()));
                    rotationRadians = Math.toRadians(this.rotation);
                    x = (double)((float)col / (float)this.hellfireWidth * (float)(this.hellfireSize * (this.hellfireWidth - 1))) * Math.cos(rotationRadians) + Math.sin(rotationRadians);
                    z = (double)((float)col / (float)this.hellfireWidth * (float)(this.hellfireSize * (this.hellfireWidth - 1))) * Math.sin(rotationRadians) - Math.cos(rotationRadians);
                    this.hellfireWalls[row][col].func_70107_b(this.func_213303_ch().func_82615_a() + x, this.func_213303_ch().func_82617_b() + (double)(this.hellfireSize * row), this.func_213303_ch().func_82616_c() + z);
                    this.hellfireWalls[row][col].projectileLife = 40;
                    this.func_130014_f_().func_217376_c((Entity)this.hellfireWalls[row][col]);
                    this.hellfireWalls[row][col].setProjectileScale((float)this.hellfireSize * 2.5f);
                }
            }
        }
        for (row = 0; row < this.hellfireHeight; ++row) {
            for (col = 0; col < this.hellfireWidth; ++col) {
                rotationRadians = Math.toRadians(this.rotation);
                x = (double)((float)col / (float)this.hellfireWidth * (float)(this.hellfireSize * (this.hellfireWidth - 1))) * Math.cos(rotationRadians) + Math.sin(rotationRadians);
                z = (double)((float)col / (float)this.hellfireWidth * (float)(this.hellfireSize * (this.hellfireWidth - 1))) * Math.sin(rotationRadians) - Math.cos(rotationRadians);
                this.hellfireWalls[row][col].func_70107_b(this.func_213303_ch().func_82615_a() + x, this.func_213303_ch().func_82617_b() + (double)(this.hellfireSize * row), this.func_213303_ch().func_82616_c() + z);
                this.hellfireWalls[row][col].projectileLife = 40;
                if (this.func_70089_S()) continue;
                this.hellfireWalls[row][col].func_70106_y();
            }
        }
    }

    @Override
    public boolean onEntityLivingDamage(LivingEntity entityLiving) {
        if (!entityLiving.func_70045_F()) {
            entityLiving.func_70015_d(this.getEffectDuration(10) / 20);
        }
        return true;
    }

    @Override
    public boolean canDamage(LivingEntity targetEntity) {
        LivingEntity owner = this.func_85052_h();
        if (owner == null && targetEntity instanceof EntityRahovart) {
            return false;
        }
        return super.canDamage(targetEntity);
    }

    @Override
    public SoundEvent getLaunchSound() {
        return ObjectManager.getSound("hellfirewave");
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBrightnessForRender() {
        return 0xF000F0;
    }

    @Override
    public ResourceLocation getTexture() {
        if (TextureManager.getTexture("hellfirewall") == null) {
            TextureManager.addTexture("hellfirewall", this.modInfo, "textures/items/hellfirewall.png");
        }
        return TextureManager.getTexture("hellfirewall");
    }
}

