/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.navigate;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.navigate.CreatureNodeProcessor;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.PathType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class CreaturePathNavigator
extends PathNavigator {
    public BaseCreatureEntity entityCreature;
    protected BlockPos climbTargetPos;

    public CreaturePathNavigator(BaseCreatureEntity entityCreature, World world) {
        super((MobEntity)entityCreature, world);
        this.entityCreature = entityCreature;
    }

    protected PathFinder func_179679_a(int searchRange) {
        this.field_179695_a = new CreatureNodeProcessor();
        this.field_179695_a.func_186317_a(true);
        return new PathFinder(this.field_179695_a, searchRange);
    }

    protected boolean func_75485_k() {
        if (this.entityCreature.isFlying()) {
            return true;
        }
        if (this.entityCreature.func_70090_H()) {
            return this.entityCreature.canWade() || this.entityCreature.isStrongSwimmer();
        }
        return this.field_75515_a.field_70122_E || this.field_75515_a.func_184218_aH();
    }

    public void setCanOpenDoors(boolean setBreakDoors) {
        this.field_179695_a.func_186321_b(setBreakDoors);
    }

    public boolean getCanOpenDoors() {
        return this.field_179695_a.func_186324_d();
    }

    public void setEnterDoors(boolean setBreakDoors) {
        this.field_179695_a.func_186317_a(setBreakDoors);
    }

    public boolean getEnterDoors() {
        return this.field_179695_a.func_186323_c();
    }

    public Path func_179680_a(BlockPos pos, int i) {
        return super.func_179680_a(this.getSuitableDestination(pos), i);
    }

    public Path func_75494_a(Entity entity, int i) {
        return this.func_179680_a(new BlockPos(entity), i);
    }

    protected BlockPos getSuitableDestination(BlockPos pos) {
        BlockState targetBlockState = this.field_75513_b.func_180495_p(pos);
        if (targetBlockState.isAir((IBlockReader)this.field_75513_b, pos)) {
            if (this.entityCreature.isFlying()) {
                return pos;
            }
            return this.getGround(pos);
        }
        if (!targetBlockState.func_185904_a().func_76220_a()) {
            return pos;
        }
        return this.getSurface(pos);
    }

    protected Vec3d func_75502_i() {
        return new Vec3d(this.field_75515_a.func_213303_ch().func_82615_a(), (double)this.getPathablePosY(), this.field_75515_a.func_213303_ch().func_82616_c());
    }

    protected int getPathablePosY() {
        if (this.entityCreature.func_204231_K() && this.entityCreature.shouldFloat() && !this.entityCreature.shouldDive()) {
            int posY = (int)this.field_75515_a.func_174813_aQ().field_72338_b;
            Block block = this.field_75513_b.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_75515_a.func_213303_ch().func_82615_a()), posY, MathHelper.func_76128_c((double)this.field_75515_a.func_213303_ch().func_82616_c()))).func_177230_c();
            int searchCount = 0;
            while (this.isSwimmableBlock(block)) {
                block = this.field_75513_b.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_75515_a.func_213303_ch().func_82615_a()), ++posY, MathHelper.func_76128_c((double)this.field_75515_a.func_213303_ch().func_82616_c()))).func_177230_c();
                if (++searchCount <= 16) continue;
                return (int)this.field_75515_a.func_174813_aQ().field_72338_b;
            }
            return posY;
        }
        return (int)(this.field_75515_a.func_174813_aQ().field_72338_b + 0.5);
    }

    public boolean func_75497_a(Entity targetEntity, double speedIn) {
        Path path = this.func_75494_a(targetEntity, 1);
        if (path != null) {
            return this.func_75484_a(path, speedIn);
        }
        if (this.entityCreature.canClimb()) {
            this.climbTargetPos = new BlockPos(targetEntity);
            this.field_75511_d = speedIn;
            return true;
        }
        return false;
    }

    protected boolean isSwimmableBlock(Block block) {
        return this.isSwimmableBlock(block, 0);
    }

    protected boolean isSwimmableBlock(Block block, int cachedCheck) {
        if (block == null || block == Blocks.field_150350_a) {
            return false;
        }
        if (cachedCheck == 1 || this.isWaterBlock(block)) {
            return !this.entityCreature.waterDamage();
        }
        if (cachedCheck == 2 || this.isLavaBlock(block)) {
            return !this.entityCreature.canBurn();
        }
        if (cachedCheck == 3 || this.isOozeBlock(block)) {
            return !this.entityCreature.canFreeze();
        }
        return false;
    }

    protected boolean isWaterBlock(Block block) {
        return block == Blocks.field_150355_j;
    }

    protected boolean isLavaBlock(Block block) {
        return block == Blocks.field_150353_l || block == ObjectManager.getBlock("purelava");
    }

    protected boolean isOozeBlock(Block block) {
        return block == ObjectManager.getBlock("ooze");
    }

    public boolean func_188555_b(BlockPos pos) {
        if (this.entityCreature.isFlying() || this.entityCreature.func_204231_K() && this.entityCreature.isStrongSwimmer()) {
            BlockState blockState = this.field_75513_b.func_180495_p(pos);
            if (blockState.func_185904_a().func_76224_d()) {
                return this.entityCreature.isStrongSwimmer();
            }
            return !blockState.func_185904_a().func_76220_a();
        }
        return super.func_188555_b(pos);
    }

    public BlockPos getGround(BlockPos pos) {
        BlockPos resultPos = pos.func_177977_b();
        while (resultPos.func_177956_o() > 0 && this.field_75513_b.func_180495_p(resultPos).isAir((IBlockReader)this.field_75513_b, resultPos)) {
            resultPos = resultPos.func_177977_b();
        }
        if (resultPos.func_177956_o() > 0) {
            return resultPos.func_177984_a();
        }
        while (resultPos.func_177956_o() < this.field_75513_b.func_217301_I() && this.field_75513_b.func_180495_p(resultPos).isAir((IBlockReader)this.field_75513_b, resultPos)) {
            resultPos = resultPos.func_177984_a();
        }
        return resultPos;
    }

    public BlockPos getSurface(BlockPos pos) {
        BlockPos resultPos = pos.func_177984_a();
        while (resultPos.func_177956_o() < this.field_75513_b.func_217301_I() && !this.field_75513_b.func_180495_p(resultPos).isAir((IBlockReader)this.field_75513_b, resultPos)) {
            resultPos = resultPos.func_177984_a();
        }
        if (resultPos.func_177956_o() == this.field_75513_b.func_217301_I() && !this.field_75513_b.func_180495_p(resultPos).isAir((IBlockReader)this.field_75513_b, resultPos)) {
            return pos;
        }
        return resultPos;
    }

    protected boolean func_75493_a(Vec3d startVec, Vec3d endVec, int sizeX, int sizeY, int sizeZ) {
        if (this.entityCreature.isFlying() || this.entityCreature.func_204231_K()) {
            Vec3d vec3d = new Vec3d(endVec.field_72450_a, endVec.field_72448_b + (double)this.field_75515_a.func_213302_cg() * 0.5, endVec.field_72449_c);
            RayTraceResult.Type directTraceType = this.field_75513_b.func_217299_a(new RayTraceContext(startVec, vec3d, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this.field_75515_a)).func_216346_c();
            return directTraceType == RayTraceResult.Type.MISS;
        }
        int startX = MathHelper.func_76128_c((double)startVec.field_72450_a);
        int startZ = MathHelper.func_76128_c((double)startVec.field_72449_c);
        double distanceX = endVec.field_72450_a - startVec.field_72450_a;
        double distanceY = endVec.field_72449_c - startVec.field_72449_c;
        double distance = distanceX * distanceX + distanceY * distanceY;
        if (distance < 1.0E-8) {
            return false;
        }
        double d3 = 1.0 / Math.sqrt(distance);
        if (!this.isSafeToStandAt(startX, (int)startVec.field_72448_b, startZ, sizeX += 2, sizeY, sizeZ += 2, startVec, distanceX *= d3, distanceY *= d3)) {
            return false;
        }
        sizeX -= 2;
        sizeZ -= 2;
        double scanSpeedX = 1.0 / Math.abs(distanceX);
        double scanSpeedZ = 1.0 / Math.abs(distanceY);
        double scanX = (double)startX - startVec.field_72450_a;
        double scanZ = (double)startZ - startVec.field_72449_c;
        if (distanceX >= 0.0) {
            scanX += 1.0;
        }
        if (distanceY >= 0.0) {
            scanZ += 1.0;
        }
        scanX /= distanceX;
        scanZ /= distanceY;
        int scanPosX = distanceX < 0.0 ? -1 : 1;
        int scanPosZ = distanceY < 0.0 ? -1 : 1;
        int scanEndX = MathHelper.func_76128_c((double)endVec.field_72450_a);
        int scanEndZ = MathHelper.func_76128_c((double)endVec.field_72449_c);
        int scanDistanceX = scanEndX - startX;
        int scanDistanceZ = scanEndZ - startZ;
        do {
            if (scanDistanceX * scanPosX <= 0 && scanDistanceZ * scanPosZ <= 0) {
                return true;
            }
            if (scanX < scanZ) {
                scanX += scanSpeedX;
                scanDistanceX = scanEndX - (startX += scanPosX);
                continue;
            }
            scanZ += scanSpeedZ;
            scanDistanceZ = scanEndZ - (startZ += scanPosZ);
        } while (this.isSafeToStandAt(startX, MathHelper.func_76128_c((double)startVec.field_72448_b), startZ, sizeX, sizeY, sizeZ, startVec, distanceX, distanceY));
        return false;
    }

    protected boolean isSafeToStandAt(int x, int y, int z, int sizeX, int sizeY, int sizeZ, Vec3d startVec, double distanceX, double distanceZ) {
        sizeX = Math.min(sizeX, 2);
        sizeY = Math.min(sizeY, 3);
        int i = x - sizeX / 2;
        int j = z - (sizeZ = Math.min(sizeZ, 2)) / 2;
        if (!this.isPositionClear(i, y, j, sizeX, sizeY, sizeZ, startVec, distanceX, distanceZ)) {
            return false;
        }
        for (int k = i; k < i + sizeX; ++k) {
            for (int l = j; l < j + sizeZ; ++l) {
                double d0 = (double)k + 0.5 - startVec.field_72450_a;
                double d1 = (double)l + 0.5 - startVec.field_72449_c;
                if (!(d0 * distanceX + d1 * distanceZ >= 0.0)) continue;
                PathNodeType pathnodetype = this.field_179695_a.func_186319_a((IBlockReader)this.field_75513_b, k, y - 1, l, this.field_75515_a, sizeX, sizeY, sizeZ, true, true);
                if (pathnodetype == PathNodeType.WATER) {
                    return false;
                }
                if (pathnodetype == PathNodeType.LAVA) {
                    return false;
                }
                if (pathnodetype == PathNodeType.OPEN) {
                    return false;
                }
                pathnodetype = this.field_179695_a.func_186319_a((IBlockReader)this.field_75513_b, k, y, l, this.field_75515_a, sizeX, sizeY, sizeZ, true, true);
                float f = this.field_75515_a.func_184643_a(pathnodetype);
                if (f < 0.0f || f >= 8.0f) {
                    return false;
                }
                if (!this.entityCreature.canBurn() || pathnodetype != PathNodeType.DAMAGE_FIRE && pathnodetype != PathNodeType.DANGER_FIRE && pathnodetype != PathNodeType.DAMAGE_OTHER) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isPositionClear(int x, int y, int z, int sizeX, int sizeY, int sizeZ, Vec3d startVec, double distanceScaleX, double distanceScaleZ) {
        double distanceZ;
        BlockPos blockPos;
        double distanceX;
        Iterator blockPosIterator = BlockPos.func_218278_a((BlockPos)new BlockPos(x, y, z), (BlockPos)new BlockPos(x + sizeX - 1, y + sizeY - 1, z + sizeZ - 1)).iterator();
        do {
            if (blockPosIterator.hasNext()) continue;
            return true;
        } while ((distanceX = (double)(blockPos = (BlockPos)blockPosIterator.next()).func_177958_n() + 0.5 - startVec.field_72450_a) * distanceScaleX + (distanceZ = (double)blockPos.func_177952_p() + 0.5 - startVec.field_72449_c) * distanceScaleZ < 0.0 || this.field_75513_b.func_180495_p(blockPos).func_196957_g((IBlockReader)this.field_75513_b, blockPos, PathType.LAND));
        return false;
    }

    protected void func_75487_m() {
        super.func_75487_m();
        for (int i = 0; i < this.field_75514_c.func_75874_d(); ++i) {
            PathPoint pathpoint = this.field_75514_c.func_75877_a(i);
            PathPoint pathpoint1 = i + 1 < this.field_75514_c.func_75874_d() ? this.field_75514_c.func_75877_a(i + 1) : null;
            BlockState iblockstate = this.field_75513_b.func_180495_p(new BlockPos(pathpoint.field_75839_a, pathpoint.field_75837_b, pathpoint.field_75838_c));
            Block block = iblockstate.func_177230_c();
            if (block != Blocks.field_150383_bp) continue;
            this.field_75514_c.func_186309_a(i, pathpoint.func_186283_a(pathpoint.field_75839_a, pathpoint.field_75837_b + 1, pathpoint.field_75838_c));
            if (pathpoint1 == null || pathpoint.field_75837_b < pathpoint1.field_75837_b) continue;
            this.field_75514_c.func_186309_a(i + 1, pathpoint1.func_186283_a(pathpoint1.field_75839_a, pathpoint.field_75837_b + 1, pathpoint1.field_75838_c));
        }
        if (this.entityCreature.daylightBurns()) {
            if (this.field_75513_b.func_175710_j(new BlockPos(MathHelper.func_76128_c((double)this.field_75515_a.func_213303_ch().func_82615_a()), (int)(this.field_75515_a.func_174813_aQ().field_72338_b + 0.5), MathHelper.func_76128_c((double)this.field_75515_a.func_213303_ch().func_82616_c())))) {
                return;
            }
            for (int j = 0; j < this.field_75514_c.func_75874_d(); ++j) {
                PathPoint pathpoint2 = this.field_75514_c.func_75877_a(j);
                if (!this.field_75513_b.func_175710_j(new BlockPos(pathpoint2.field_75839_a, pathpoint2.field_75837_b, pathpoint2.field_75838_c))) continue;
                this.field_75514_c.func_186309_a(j, pathpoint2.func_186283_a(pathpoint2.field_75839_a, pathpoint2.field_75837_b + 1, pathpoint2.field_75838_c));
                return;
            }
        }
    }

    protected void func_75508_h() {
        float entityWidth = this.field_75515_a.func_213305_a((Pose)Pose.STANDING).field_220315_a;
        Vec3d currentPos = this.func_75502_i();
        if (this.entityCreature.isFlying() || this.entityCreature.func_204231_K()) {
            float entitySize = entityWidth * entityWidth;
            if (currentPos.func_72436_e(this.field_75514_c.func_75881_a((Entity)this.field_75515_a, this.field_75514_c.func_75873_e())) < (double)entitySize) {
                this.field_75514_c.func_75875_a();
            }
            int pathIndexRange = 6;
            for (int pathIndex = Math.min(this.field_75514_c.func_75873_e() + pathIndexRange, this.field_75514_c.func_75874_d() - 1); pathIndex > this.field_75514_c.func_75873_e(); --pathIndex) {
                Vec3d pathVector = this.field_75514_c.func_75881_a((Entity)this.field_75515_a, pathIndex);
                if (!(pathVector.func_72436_e(currentPos) <= 36.0) || !this.func_75493_a(currentPos, pathVector, 0, 0, 0)) continue;
                this.field_75514_c.func_75872_c(pathIndex);
                break;
            }
            this.func_179677_a(currentPos);
            return;
        }
        this.field_188561_o = entityWidth > 0.75f ? entityWidth : 0.75f - entityWidth / 2.0f;
        Vec3d pathTargetPos = this.field_75514_c.func_186310_f();
        if (Math.abs(this.field_75515_a.func_213303_ch().func_82615_a() - (pathTargetPos.field_72450_a + (double)(entityWidth + 1.0f) / 2.0)) < (double)this.field_188561_o && Math.abs(this.field_75515_a.func_213303_ch().func_82616_c() - (pathTargetPos.field_72449_c + (double)(entityWidth + 1.0f) / 2.0)) < (double)this.field_188561_o && Math.abs(this.field_75515_a.func_213303_ch().func_82617_b() - pathTargetPos.field_72448_b) < 1.0) {
            this.field_75514_c.func_75872_c(this.field_75514_c.func_75873_e() + 1);
        }
        this.func_179677_a(currentPos);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void func_75501_e() {
        block10: {
            block11: {
                block12: {
                    if (!this.func_75500_f() && !this.entityCreature.hasAttackTarget()) {
                        PathPoint finalPoint = this.func_75505_d().func_75870_c();
                        Vec3d finalVec = new Vec3d((double)finalPoint.field_75839_a, (double)finalPoint.field_75837_b, (double)finalPoint.field_75838_c);
                        if (this.entityCreature.func_195048_a(finalVec) <= (double)this.entityCreature.func_213305_a((Pose)Pose.STANDING).field_220315_a) {
                            this.func_75499_g();
                        }
                    }
                    if (!this.func_75500_f() || !this.entityCreature.canClimb() || this.climbTargetPos == null) break block10;
                    double d0 = this.field_75515_a.func_213305_a((Pose)Pose.STANDING).field_220315_a * this.field_75515_a.func_213305_a((Pose)Pose.STANDING).field_220315_a;
                    Vec3d vec3d = new Vec3d((Vec3i)this.climbTargetPos);
                    if (!(this.field_75515_a.func_195048_a(vec3d) >= d0)) break block11;
                    if (this.field_75515_a.func_213303_ch().func_82617_b() <= (double)this.climbTargetPos.func_177956_o()) break block12;
                    Vec3d vec3d2 = new Vec3d((double)this.climbTargetPos.func_177958_n(), (double)MathHelper.func_76128_c((double)this.field_75515_a.func_213303_ch().func_82617_b()), (double)this.climbTargetPos.func_177952_p());
                    if (!(this.field_75515_a.func_195048_a(vec3d2) >= d0)) break block11;
                }
                this.field_75515_a.func_70605_aq().func_75642_a((double)this.climbTargetPos.func_177958_n(), (double)this.climbTargetPos.func_177956_o(), (double)this.climbTargetPos.func_177952_p(), this.field_75511_d);
                return;
            }
            this.climbTargetPos = null;
            return;
        }
        if (this.func_75500_f()) return;
        ++this.field_75510_g;
        if (this.field_188562_p) {
            this.func_188554_j();
        }
        if (this.func_75485_k()) {
            this.func_75508_h();
        } else if (this.field_75514_c != null && this.field_75514_c.func_75873_e() < this.field_75514_c.func_75874_d()) {
            Vec3d vec3d = this.func_75502_i();
            Vec3d vec3d1 = this.field_75514_c.func_75881_a((Entity)this.field_75515_a, this.field_75514_c.func_75873_e());
            if (vec3d.field_72448_b > vec3d1.field_72448_b && !this.field_75515_a.field_70122_E && MathHelper.func_76128_c((double)vec3d.field_72450_a) == MathHelper.func_76128_c((double)vec3d1.field_72450_a) && MathHelper.func_76128_c((double)vec3d.field_72449_c) == MathHelper.func_76128_c((double)vec3d1.field_72449_c)) {
                this.field_75514_c.func_75872_c(this.field_75514_c.func_75873_e() + 1);
            }
        }
        DebugPacketSender.func_218803_a((World)this.field_75513_b, (MobEntity)this.field_75515_a, (Path)this.field_75514_c, (float)this.field_188561_o);
        if (this.func_75500_f()) return;
        Vec3d vec3d2 = this.field_75514_c.func_75878_a((Entity)this.field_75515_a);
        BlockPos blockpos = new BlockPos(vec3d2);
        this.field_75515_a.func_70605_aq().func_75642_a(vec3d2.field_72450_a, this.field_75513_b.func_180495_p(blockpos.func_177977_b()).func_196958_f() ? vec3d2.field_72448_b : WalkNodeProcessor.func_197682_a((IBlockReader)this.field_75513_b, (BlockPos)blockpos), vec3d2.field_72449_c, this.field_75511_d);
    }
}

