/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.navigate;

import com.google.common.collect.Sets;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.navigate.ICreatureNodeProcessor;
import java.util.EnumSet;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RailBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.fluid.IFluidState;
import net.minecraft.pathfinding.FlaggedPathPoint;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.Region;

public class CreatureNodeProcessor
extends NodeProcessor
implements ICreatureNodeProcessor {
    public BaseCreatureEntity entityCreature;
    protected float avoidsWater;

    public static double getGroundY(IBlockReader blockReader, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        VoxelShape voxelshape = blockReader.func_180495_p(blockpos).func_196952_d(blockReader, blockpos);
        return (double)blockpos.func_177956_o() + (voxelshape.func_197766_b() ? 0.0 : voxelshape.func_197758_c(Direction.Axis.Y));
    }

    public void func_225578_a_(Region region, MobEntity mob) {
        super.func_225578_a_(region, mob);
        this.avoidsWater = mob.func_184643_a(PathNodeType.WATER);
        if (mob instanceof BaseCreatureEntity) {
            this.entityCreature = (BaseCreatureEntity)mob;
        }
        this.updateEntitySize((Entity)mob);
    }

    @Override
    public void updateEntitySize(Entity updateEntity) {
        this.field_176168_c = MathHelper.func_76128_c((double)(this.getWidth(true, updateEntity) + 1.0));
        this.field_176165_d = MathHelper.func_76141_d((float)(updateEntity.func_213305_a((Pose)Pose.STANDING).field_220316_b + 1.0f));
        this.field_176166_e = MathHelper.func_76128_c((double)(this.getWidth(true, updateEntity) + 1.0));
    }

    public void func_176163_a() {
        if (this.entityCreature != null) {
            this.field_186326_b.func_184644_a(PathNodeType.WATER, this.avoidsWater);
        }
        super.func_176163_a();
    }

    public boolean func_186322_e() {
        if (this.entityCreature != null) {
            return this.entityCreature.canWade() || this.entityCreature.isStrongSwimmer();
        }
        return super.func_186322_e();
    }

    public boolean swimming() {
        if (this.entityCreature == null) {
            return false;
        }
        if (this.entityCreature.func_70090_H()) {
            return this.entityCreature.isStrongSwimmer() || this.entityCreature.canWade() && this.entityCreature.shouldDive();
        }
        return false;
    }

    public boolean flying() {
        return this.entityCreature != null && this.entityCreature.isFlying() && !this.entityCreature.func_204231_K();
    }

    public double getWidth(boolean blockChecks) {
        return this.getWidth(blockChecks, (Entity)this.field_186326_b);
    }

    public double getWidth(boolean blockChecks, Entity entity) {
        return Math.min(3.0, (double)entity.func_213305_a((Pose)Pose.STANDING).field_220315_a);
    }

    public FlaggedPathPoint func_224768_a(double x, double y, double z) {
        if (this.flying() || this.swimming()) {
            return new FlaggedPathPoint(this.func_176159_a(MathHelper.func_76128_c((double)(x - this.getWidth(false))), MathHelper.func_76128_c((double)(y + 0.5)), MathHelper.func_76128_c((double)(z - this.getWidth(false)))));
        }
        return new FlaggedPathPoint(this.func_176159_a(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z)));
    }

    public PathPoint func_186318_b() {
        int posY;
        if (this.flying() || this.entityCreature.isStrongSwimmer() && this.entityCreature.func_204231_K()) {
            return this.func_176159_a(MathHelper.func_76128_c((double)this.field_186326_b.func_174813_aQ().field_72340_a), MathHelper.func_76128_c((double)(this.field_186326_b.func_174813_aQ().field_72338_b + 0.5)), MathHelper.func_76128_c((double)this.field_186326_b.func_174813_aQ().field_72339_c));
        }
        if (this.func_186322_e() && this.field_186326_b.func_204231_K()) {
            posY = (int)this.field_186326_b.func_174813_aQ().field_72338_b;
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(MathHelper.func_76128_c((double)this.field_186326_b.func_213303_ch().func_82615_a()), posY, MathHelper.func_76128_c((double)this.field_186326_b.func_213303_ch().func_82616_c()));
            IFluidState fluidState = this.field_176169_a.func_204610_c((BlockPos)blockpos$mutable);
            while (fluidState.func_206884_a(FluidTags.field_206959_a)) {
                blockpos$mutable.func_181079_c(MathHelper.func_76128_c((double)this.field_186326_b.func_213303_ch().func_82615_a()), ++posY, MathHelper.func_76128_c((double)this.field_186326_b.func_213303_ch().func_82616_c()));
                fluidState = this.field_176169_a.func_204610_c((BlockPos)blockpos$mutable);
            }
        } else if (this.field_186326_b.field_70122_E) {
            posY = MathHelper.func_76128_c((double)(this.field_186326_b.func_174813_aQ().field_72338_b + 0.5));
        } else {
            BlockPos blockpos = new BlockPos((Entity)this.field_186326_b);
            while (!(this.field_176169_a.func_180495_p(blockpos).func_185904_a() != Material.field_151579_a && this.field_176169_a.func_180495_p(blockpos).func_200132_m() || blockpos.func_177956_o() <= 0)) {
                blockpos = blockpos.func_177977_b();
            }
            posY = blockpos.func_177984_a().func_177956_o();
        }
        BlockPos offsetXZ = new BlockPos((Entity)this.field_186326_b);
        PathNodeType targetNodeType = this.func_186330_a((IBlockReader)this.field_176169_a, offsetXZ.func_177958_n(), posY, offsetXZ.func_177952_p());
        if (this.field_186326_b.func_184643_a(targetNodeType) < 0.0f) {
            HashSet set = Sets.newHashSet();
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72340_a, (double)posY, this.field_186326_b.func_174813_aQ().field_72339_c));
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72340_a, (double)posY, this.field_186326_b.func_174813_aQ().field_72334_f));
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72336_d, (double)posY, this.field_186326_b.func_174813_aQ().field_72339_c));
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72336_d, (double)posY, this.field_186326_b.func_174813_aQ().field_72334_f));
            for (BlockPos betterPos : set) {
                PathNodeType pathnodetype = this.getPathNodeType(this.field_186326_b, betterPos);
                if (!(this.field_186326_b.func_184643_a(pathnodetype) >= 0.0f)) continue;
                return this.func_176159_a(betterPos.func_177958_n(), betterPos.func_177956_o(), betterPos.func_177952_p());
            }
        }
        return this.func_176159_a(offsetXZ.func_177958_n(), posY, offsetXZ.func_177952_p());
    }

    public int func_222859_a(PathPoint[] pathOptions, PathPoint fromPoint) {
        PathPoint southEastPoint;
        PathPoint southWestPoint;
        PathPoint northEastPoint;
        PathPoint northWestPoint;
        PathPoint northPoint;
        PathPoint eastPoint;
        PathPoint westPoint;
        double groundY;
        PathPoint southPoint;
        if (this.flying() || this.swimming()) {
            int i = 0;
            for (Direction direction : Direction.values()) {
                PathPoint pathPoint = null;
                if (this.swimming()) {
                    pathPoint = this.getWaterNode(fromPoint.field_75839_a + direction.func_82601_c(), fromPoint.field_75837_b + direction.func_96559_d(), fromPoint.field_75838_c + direction.func_82599_e());
                }
                if (pathPoint == null) {
                    pathPoint = this.getFlightNode(fromPoint.field_75839_a + direction.func_82601_c(), fromPoint.field_75837_b + direction.func_96559_d(), fromPoint.field_75838_c + direction.func_82599_e());
                }
                if (pathPoint == null || pathPoint.field_75842_i) continue;
                pathOptions[i++] = pathPoint;
            }
            return i;
        }
        int i = 0;
        int pathPriority = 0;
        PathNodeType pathnodetype = this.getPathNodeType(this.field_186326_b, fromPoint.field_75839_a, fromPoint.field_75837_b + 1, fromPoint.field_75838_c);
        if (this.field_186326_b.func_184643_a(pathnodetype) >= 0.0f) {
            pathPriority = MathHelper.func_76141_d((float)Math.max(1.0f, this.field_186326_b.field_70138_W));
        }
        if ((southPoint = this.getSafePoint(fromPoint.field_75839_a, fromPoint.field_75837_b, fromPoint.field_75838_c + 1, pathPriority, groundY = CreatureNodeProcessor.getGroundY((IBlockReader)this.field_176169_a, new BlockPos(fromPoint.field_75839_a, fromPoint.field_75837_b, fromPoint.field_75838_c)), Direction.SOUTH)) != null && !southPoint.field_75842_i && southPoint.field_186286_l >= 0.0f) {
            pathOptions[i++] = southPoint;
        }
        if ((westPoint = this.getSafePoint(fromPoint.field_75839_a - 1, fromPoint.field_75837_b, fromPoint.field_75838_c, pathPriority, groundY, Direction.WEST)) != null && !westPoint.field_75842_i && westPoint.field_186286_l >= 0.0f) {
            pathOptions[i++] = westPoint;
        }
        if ((eastPoint = this.getSafePoint(fromPoint.field_75839_a + 1, fromPoint.field_75837_b, fromPoint.field_75838_c, pathPriority, groundY, Direction.EAST)) != null && !eastPoint.field_75842_i && eastPoint.field_186286_l >= 0.0f) {
            pathOptions[i++] = eastPoint;
        }
        if ((northPoint = this.getSafePoint(fromPoint.field_75839_a, fromPoint.field_75837_b, fromPoint.field_75838_c - 1, pathPriority, groundY, Direction.NORTH)) != null && !northPoint.field_75842_i && northPoint.field_186286_l >= 0.0f) {
            pathOptions[i++] = northPoint;
        }
        if (this.testDiagonalPoint(fromPoint, westPoint, northPoint, northWestPoint = this.getSafePoint(fromPoint.field_75839_a - 1, fromPoint.field_75837_b, fromPoint.field_75838_c - 1, pathPriority, groundY, Direction.NORTH))) {
            pathOptions[i++] = northWestPoint;
        }
        if (this.testDiagonalPoint(fromPoint, eastPoint, northPoint, northEastPoint = this.getSafePoint(fromPoint.field_75839_a + 1, fromPoint.field_75837_b, fromPoint.field_75838_c - 1, pathPriority, groundY, Direction.NORTH))) {
            pathOptions[i++] = northEastPoint;
        }
        if (this.testDiagonalPoint(fromPoint, westPoint, southPoint, southWestPoint = this.getSafePoint(fromPoint.field_75839_a - 1, fromPoint.field_75837_b, fromPoint.field_75838_c + 1, pathPriority, groundY, Direction.SOUTH))) {
            pathOptions[i++] = southWestPoint;
        }
        if (this.testDiagonalPoint(fromPoint, eastPoint, southPoint, southEastPoint = this.getSafePoint(fromPoint.field_75839_a + 1, fromPoint.field_75837_b, fromPoint.field_75838_c + 1, pathPriority, groundY, Direction.SOUTH))) {
            pathOptions[i++] = southEastPoint;
        }
        return i;
    }

    private boolean testDiagonalPoint(PathPoint targetPoint, @Nullable PathPoint lateralPoint, @Nullable PathPoint longitudinalPoint, @Nullable PathPoint diagonalPoint) {
        return diagonalPoint != null && !diagonalPoint.field_75842_i && longitudinalPoint != null && longitudinalPoint.field_186286_l >= 0.0f && longitudinalPoint.field_75837_b <= targetPoint.field_75837_b && lateralPoint != null && lateralPoint.field_186286_l >= 0.0f && lateralPoint.field_75837_b <= targetPoint.field_75837_b;
    }

    @Nullable
    private PathPoint getSafePoint(int x, int y, int z, int stepHeight, double fromGroundY, Direction direction) {
        double offsetZ;
        double offsetX;
        AxisAlignedBB axisalignedbb;
        PathPoint safePoint = null;
        BlockPos blockPos = new BlockPos(x, y, z);
        double groundY = CreatureNodeProcessor.getGroundY((IBlockReader)this.field_176169_a, blockPos);
        if (groundY - fromGroundY > 1.125) {
            return null;
        }
        PathNodeType pathnodetype = this.getPathNodeType(this.field_186326_b, x, y, z);
        float pathPriority = this.field_186326_b.func_184643_a(pathnodetype);
        double entityRadius = this.getWidth(true) / 2.0;
        if (pathPriority >= 0.0f) {
            safePoint = this.func_176159_a(x, y, z);
            safePoint.field_186287_m = pathnodetype;
            safePoint.field_186286_l = Math.max(safePoint.field_186286_l, pathPriority);
        }
        if (pathnodetype == PathNodeType.WALKABLE) {
            return safePoint;
        }
        if (!(safePoint != null && !(safePoint.field_186286_l < 0.0f) || stepHeight <= 0 || pathnodetype == PathNodeType.FENCE || pathnodetype == PathNodeType.TRAPDOOR || (safePoint = this.getSafePoint(x, y + 1, z, stepHeight - 1, fromGroundY, direction)) == null || safePoint.field_186287_m != PathNodeType.OPEN && safePoint.field_186287_m != PathNodeType.WALKABLE || !(this.getWidth(false) < 1.0) || this.field_176169_a.func_226665_a__((Entity)this.field_186326_b, axisalignedbb = new AxisAlignedBB((offsetX = (double)(x - direction.func_82601_c()) + 0.5) - entityRadius, CreatureNodeProcessor.getGroundY((IBlockReader)this.field_176169_a, new BlockPos(offsetX, (double)(y + 1), offsetZ = (double)(z - direction.func_82599_e()) + 0.5)) + 0.001, offsetZ - entityRadius, offsetX + entityRadius, (double)this.field_186326_b.func_213302_cg() + CreatureNodeProcessor.getGroundY((IBlockReader)this.field_176169_a, new BlockPos(safePoint.field_75839_a, safePoint.field_75837_b, safePoint.field_75838_c)) - 0.002, offsetZ + entityRadius)))) {
            safePoint = null;
        }
        if (pathnodetype == PathNodeType.WATER && !this.func_186322_e()) {
            if (this.getPathNodeType(this.field_186326_b, x, y - 1, z) != PathNodeType.WATER) {
                return safePoint;
            }
            while (y > 0) {
                if ((pathnodetype = this.getPathNodeType(this.field_186326_b, x, --y, z)) != PathNodeType.WATER) {
                    return safePoint;
                }
                safePoint = this.func_176159_a(x, y, z);
                safePoint.field_186287_m = pathnodetype;
                safePoint.field_186286_l = Math.max(safePoint.field_186286_l, this.field_186326_b.func_184643_a(pathnodetype));
            }
        }
        if (pathnodetype == PathNodeType.OPEN) {
            PathNodeType pathnodetype1;
            AxisAlignedBB pathingCollision = new AxisAlignedBB((double)x - entityRadius + 0.5, (double)y + 0.001, (double)z - entityRadius + 0.5, (double)x + entityRadius + 0.5, (double)((float)y + this.field_186326_b.func_213305_a((Pose)Pose.STANDING).field_220316_b), (double)z + entityRadius + 0.5);
            if (!this.field_176169_a.func_226665_a__((Entity)this.field_186326_b, pathingCollision)) {
                return null;
            }
            if (this.getWidth(false) >= 1.0 && (pathnodetype1 = this.getPathNodeType(this.field_186326_b, x, y - 1, z)) == PathNodeType.BLOCKED) {
                safePoint = this.func_176159_a(x, y, z);
                safePoint.field_186287_m = PathNodeType.WALKABLE;
                safePoint.field_186286_l = Math.max(safePoint.field_186286_l, pathPriority);
                return safePoint;
            }
            int i = 0;
            int initialY = y;
            while (pathnodetype == PathNodeType.OPEN) {
                if (--y < 0) {
                    PathPoint voidDropPoint = this.func_176159_a(x, initialY, z);
                    voidDropPoint.field_186287_m = PathNodeType.BLOCKED;
                    voidDropPoint.field_186286_l = -1.0f;
                    return voidDropPoint;
                }
                PathPoint dropPoint = this.func_176159_a(x, y, z);
                if (i++ >= this.field_186326_b.func_82143_as()) {
                    dropPoint.field_186287_m = PathNodeType.BLOCKED;
                    dropPoint.field_186286_l = -1.0f;
                    return dropPoint;
                }
                pathnodetype = this.getPathNodeType(this.field_186326_b, x, y, z);
                pathPriority = this.field_186326_b.func_184643_a(pathnodetype);
                if (pathnodetype != PathNodeType.OPEN && pathPriority >= 0.0f) {
                    safePoint = dropPoint;
                    dropPoint.field_186287_m = pathnodetype;
                    dropPoint.field_186286_l = Math.max(dropPoint.field_186286_l, pathPriority);
                    break;
                }
                if (!(pathPriority < 0.0f)) continue;
                dropPoint.field_186287_m = PathNodeType.BLOCKED;
                dropPoint.field_186286_l = -1.0f;
                return dropPoint;
            }
        }
        return safePoint;
    }

    public PathNodeType func_186319_a(IBlockReader world, int x, int y, int z, MobEntity mobEntity, int xSize, int ySize, int zSize, boolean canBreakDoorsIn, boolean canEnterDoorsIn) {
        if (this.swimming()) {
            return PathNodeType.WATER;
        }
        EnumSet<PathNodeType> enumset = EnumSet.noneOf(PathNodeType.class);
        PathNodeType pathnodetype = PathNodeType.BLOCKED;
        BlockPos blockpos = new BlockPos((Entity)mobEntity);
        for (int i = -xSize; i < xSize; ++i) {
            for (int j = 0; j < ySize; ++j) {
                for (int k = -zSize; k < zSize; ++k) {
                    int l = i + x;
                    int i1 = j + y;
                    int j1 = k + z;
                    PathNodeType pathnodetype1 = this.func_186330_a(world, l, i1, j1);
                    if (pathnodetype1 == PathNodeType.DOOR_WOOD_CLOSED && canBreakDoorsIn && canEnterDoorsIn) {
                        pathnodetype1 = PathNodeType.WALKABLE;
                    }
                    if (pathnodetype1 == PathNodeType.DOOR_OPEN && !canEnterDoorsIn) {
                        pathnodetype1 = PathNodeType.BLOCKED;
                    }
                    if (pathnodetype1 == PathNodeType.RAIL && !(world.func_180495_p(blockpos).func_177230_c() instanceof RailBlock) && !(world.func_180495_p(blockpos.func_177977_b()).func_177230_c() instanceof RailBlock)) {
                        pathnodetype1 = PathNodeType.FENCE;
                    }
                    if (i == 0 && j == 0 && k == 0) {
                        pathnodetype = pathnodetype1;
                    }
                    enumset.add(pathnodetype1);
                }
            }
        }
        if (enumset.contains(PathNodeType.FENCE)) {
            return PathNodeType.FENCE;
        }
        PathNodeType pathnodetype2 = PathNodeType.BLOCKED;
        for (PathNodeType pathnodetype3 : enumset) {
            if (mobEntity.func_184643_a(pathnodetype3) < 0.0f) {
                return pathnodetype3;
            }
            if (!(mobEntity.func_184643_a(pathnodetype3) >= mobEntity.func_184643_a(pathnodetype2))) continue;
            pathnodetype2 = pathnodetype3;
        }
        if (pathnodetype == PathNodeType.OPEN && mobEntity.func_184643_a(pathnodetype2) == 0.0f) {
            return PathNodeType.OPEN;
        }
        return pathnodetype2;
    }

    public PathNodeType getPathNodeType(MobEntity mobEntity, BlockPos pos) {
        if (this.swimming()) {
            return PathNodeType.WATER;
        }
        return this.getPathNodeType(mobEntity, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public PathNodeType getPathNodeType(MobEntity mobEntity, int x, int y, int z) {
        return this.func_186319_a((IBlockReader)this.field_176169_a, x, y, z, mobEntity, this.field_176168_c, this.field_176165_d, this.field_176166_e, this.func_186324_d(), this.func_186323_c());
    }

    public PathNodeType func_186330_a(IBlockReader blockaccessIn, int x, int y, int z) {
        PathNodeType pathnodetype = this.getPathNodeTypeRaw(blockaccessIn, x, y, z);
        if (pathnodetype == PathNodeType.WATER) {
            for (Direction direction : Direction.values()) {
                PathNodeType pathnodetype2 = this.getPathNodeTypeRaw(blockaccessIn, x + direction.func_82601_c(), y + direction.func_96559_d(), z + direction.func_82599_e());
                if (pathnodetype2 != PathNodeType.BLOCKED) continue;
                return PathNodeType.WATER_BORDER;
            }
            return PathNodeType.WATER;
        }
        if (pathnodetype == PathNodeType.OPEN && y >= 1) {
            Block block = blockaccessIn.func_180495_p(new BlockPos(x, y - 1, z)).func_177230_c();
            PathNodeType pathnodetype1 = this.getPathNodeTypeRaw(blockaccessIn, x, y - 1, z);
            PathNodeType pathNodeType = pathnodetype = pathnodetype1 != PathNodeType.WALKABLE && pathnodetype1 != PathNodeType.OPEN && pathnodetype1 != PathNodeType.WATER && pathnodetype1 != PathNodeType.LAVA ? PathNodeType.WALKABLE : PathNodeType.OPEN;
            if (pathnodetype1 == PathNodeType.DAMAGE_FIRE || block == Blocks.field_196814_hQ || block == Blocks.field_222433_lV) {
                pathnodetype = PathNodeType.DAMAGE_FIRE;
            }
            if (pathnodetype1 == PathNodeType.DAMAGE_CACTUS) {
                pathnodetype = PathNodeType.DAMAGE_CACTUS;
            }
            if (pathnodetype1 == PathNodeType.DAMAGE_OTHER) {
                pathnodetype = PathNodeType.DAMAGE_OTHER;
            }
            if (pathnodetype1 == PathNodeType.DAMAGE_OTHER) {
                pathnodetype = PathNodeType.DAMAGE_OTHER;
            }
        }
        pathnodetype = this.checkNeighborBlocks(blockaccessIn, x, y, z, pathnodetype);
        return pathnodetype;
    }

    public PathNodeType checkNeighborBlocks(IBlockReader blockaccessIn, int x, int y, int z, PathNodeType nodeType) {
        if (nodeType == PathNodeType.WALKABLE) {
            try (BlockPos.PooledMutable blockpos$pooledmutable = BlockPos.PooledMutable.func_185346_s();){
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        if (i == 0 && j == 0) continue;
                        BlockState state = blockaccessIn.func_180495_p((BlockPos)blockpos$pooledmutable.func_181079_c(i + x, y, j + z));
                        Block block = state.func_177230_c();
                        PathNodeType type = block.getAiPathNodeType(state, blockaccessIn, (BlockPos)blockpos$pooledmutable, this.field_186326_b);
                        if (block == Blocks.field_150434_aF || type == PathNodeType.DAMAGE_CACTUS) {
                            nodeType = PathNodeType.DANGER_CACTUS;
                            continue;
                        }
                        if (block == Blocks.field_150480_ab || type == PathNodeType.DAMAGE_FIRE) {
                            nodeType = PathNodeType.DANGER_FIRE;
                            continue;
                        }
                        if (block != Blocks.field_222434_lW && type != PathNodeType.DAMAGE_OTHER) continue;
                        nodeType = PathNodeType.DANGER_OTHER;
                    }
                }
            }
        }
        return nodeType;
    }

    protected PathNodeType getPathNodeTypeRaw(IBlockReader blockaccessIn, int x, int y, int z) {
        BlockPos blockpos = new BlockPos(x, y, z);
        BlockState blockstate = blockaccessIn.func_180495_p(blockpos);
        PathNodeType type = blockstate.getAiPathNodeType(blockaccessIn, blockpos, this.field_186326_b);
        if (type != null) {
            return type;
        }
        Block block = blockstate.func_177230_c();
        Material material = blockstate.func_185904_a();
        if (blockstate.isAir(blockaccessIn, blockpos)) {
            return PathNodeType.OPEN;
        }
        if (!block.func_203417_a(BlockTags.field_212185_E) && block != Blocks.field_196651_dG) {
            if (block == Blocks.field_150480_ab) {
                return PathNodeType.DAMAGE_FIRE;
            }
            if (block == Blocks.field_150434_aF) {
                return PathNodeType.DAMAGE_CACTUS;
            }
            if (block == Blocks.field_222434_lW) {
                return PathNodeType.DAMAGE_OTHER;
            }
            if (block instanceof DoorBlock && material == Material.field_151575_d && !((Boolean)blockstate.func_177229_b((IProperty)DoorBlock.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_WOOD_CLOSED;
            }
            if (block instanceof DoorBlock && material == Material.field_151573_f && !((Boolean)blockstate.func_177229_b((IProperty)DoorBlock.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_IRON_CLOSED;
            }
            if (block instanceof DoorBlock && ((Boolean)blockstate.func_177229_b((IProperty)DoorBlock.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_OPEN;
            }
            if (block instanceof AbstractRailBlock) {
                return PathNodeType.RAIL;
            }
            if (block instanceof LeavesBlock) {
                return PathNodeType.LEAVES;
            }
            if (!(block.func_203417_a(BlockTags.field_219748_G) || block.func_203417_a(BlockTags.field_219757_z) || block instanceof FenceGateBlock && !((Boolean)blockstate.func_177229_b((IProperty)FenceGateBlock.field_176466_a)).booleanValue())) {
                IFluidState ifluidstate = blockaccessIn.func_204610_c(blockpos);
                if (ifluidstate.func_206884_a(FluidTags.field_206959_a)) {
                    return PathNodeType.WATER;
                }
                if (ifluidstate.func_206884_a(FluidTags.field_206960_b)) {
                    return PathNodeType.LAVA;
                }
                return blockstate.func_196957_g(blockaccessIn, blockpos, PathType.LAND) ? PathNodeType.OPEN : PathNodeType.BLOCKED;
            }
            return PathNodeType.FENCE;
        }
        return PathNodeType.TRAPDOOR;
    }

    protected PathPoint getFlightNode(int x, int y, int z) {
        PathNodeType pathnodetype = this.isFlyablePathNode(x, y, z);
        if (this.entityCreature != null && this.entityCreature.isStrongSwimmer() && pathnodetype == PathNodeType.WATER) {
            return this.func_176159_a(x, y, z);
        }
        return pathnodetype == PathNodeType.OPEN ? this.func_176159_a(x, y, z) : null;
    }

    protected PathNodeType isFlyablePathNode(int x, int y, int z) {
        BlockPos centerPos = new BlockPos(x, y, z);
        for (int i = 0; i <= this.field_176168_c; ++i) {
            for (int j = 0; j <= Math.min(this.field_176165_d, 2); ++j) {
                for (int k = 0; k <= this.field_176166_e; ++k) {
                    BlockState iblockstate = this.field_176169_a.func_180495_p(centerPos.func_177982_a(i, k, j));
                    if (!iblockstate.func_185904_a().func_76220_a() && !iblockstate.func_185904_a().func_76224_d()) {
                        return PathNodeType.OPEN;
                    }
                    if (iblockstate.func_185904_a() == Material.field_151579_a) continue;
                    if (this.entityCreature != null && this.entityCreature.isStrongSwimmer()) {
                        return this.isSwimmablePathNode(x, y, z);
                    }
                    return PathNodeType.BLOCKED;
                }
            }
        }
        return PathNodeType.OPEN;
    }

    @Nullable
    private PathPoint getWaterNode(int x, int y, int z) {
        PathNodeType pathnodetype;
        if (this.entityCreature != null && this.entityCreature.isFlying()) {
            pathnodetype = this.isFlyablePathNode(x, y, z);
            if (pathnodetype == PathNodeType.OPEN) {
                return this.func_176159_a(x, y, z);
            }
        } else {
            pathnodetype = this.isSwimmablePathNode(x, y, z);
        }
        return pathnodetype == PathNodeType.WATER ? this.func_176159_a(x, y, z) : null;
    }

    private PathNodeType isSwimmablePathNode(int x, int y, int z) {
        BlockPos centerPos = new BlockPos(x, y, z);
        for (int i = 0; i <= this.field_176168_c; ++i) {
            for (int j = 0; j <= Math.min(this.field_176165_d, 2); ++j) {
                for (int k = 0; k <= this.field_176166_e; ++k) {
                    BlockPos blockPos = centerPos.func_177982_a(i, k, j);
                    BlockState blockState = this.field_176169_a.func_180495_p(blockPos);
                    IFluidState fluidState = this.field_176169_a.func_204610_c(blockPos);
                    if (this.entityCreature == null || !blockState.func_196957_g((IBlockReader)this.field_176169_a, blockPos, PathType.WATER)) {
                        if (j == y) {
                            return PathNodeType.BLOCKED;
                        }
                        if (!blockState.func_196957_g((IBlockReader)this.field_176169_a, blockPos, PathType.AIR) && !blockState.func_196957_g((IBlockReader)this.field_176169_a, blockPos, PathType.WATER)) {
                            return PathNodeType.BLOCKED;
                        }
                    }
                    if (this.entityCreature.waterDamage() && fluidState.func_206884_a(FluidTags.field_206959_a)) {
                        return PathNodeType.BLOCKED;
                    }
                    if (this.entityCreature.canBurn() && fluidState.func_206884_a(FluidTags.field_206960_b)) {
                        return PathNodeType.BLOCKED;
                    }
                    if (!this.entityCreature.canFreeze() || ObjectManager.getBlock("ooze") == null || blockState.func_177230_c() != ObjectManager.getBlock("ooze")) continue;
                    return PathNodeType.BLOCKED;
                }
            }
        }
        return PathNodeType.WATER;
    }
}

