/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.navigate;

import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;

public class CreatureMoveController
extends MovementController {
    protected BaseCreatureEntity entityCreature;
    protected int courseChangeCooldown;

    public CreatureMoveController(BaseCreatureEntity baseCreatureEntity) {
        super((MobEntity)baseCreatureEntity);
        this.entityCreature = baseCreatureEntity;
    }

    public void func_75641_c() {
        if (this.isControlledByRider()) {
            return;
        }
        if (this.entityCreature.isStrongSwimmer() && this.entityCreature.func_204231_K()) {
            this.tickSwimming();
            return;
        }
        if (this.entityCreature.isFlying() && !this.entityCreature.func_204231_K()) {
            this.tickFlying();
            return;
        }
        this.tickWalking();
    }

    public boolean isControlledByRider() {
        return this.entityCreature != null && this.entityCreature.func_184179_bs() instanceof PlayerEntity && this.entityCreature.func_82171_bF();
    }

    public void tickWalking() {
        if (this.field_188491_h == MovementController.Action.STRAFE) {
            float moveSpeed = (float)this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
            float scaledSpeed = (float)this.field_75645_e * moveSpeed;
            float moveForward = this.field_188489_f;
            float moveStrafe = this.field_188490_g;
            float velocity = MathHelper.func_76129_c((float)(moveForward * moveForward + moveStrafe * moveStrafe));
            if (velocity < 1.0f) {
                velocity = 1.0f;
            }
            velocity = scaledSpeed / velocity;
            float yawSin = MathHelper.func_76126_a((float)(this.field_75648_a.field_70177_z * ((float)Math.PI / 180)));
            float yawCos = MathHelper.func_76134_b((float)(this.field_75648_a.field_70177_z * ((float)Math.PI / 180)));
            float moveX = (moveForward *= velocity) * yawCos - (moveStrafe *= velocity) * yawSin;
            float moveZ = moveStrafe * yawCos + moveForward * yawSin;
            PathNavigator pathNavigator = this.field_75648_a.func_70661_as();
            NodeProcessor nodeProcessor = pathNavigator.func_189566_q();
            if (nodeProcessor.func_186330_a((IBlockReader)this.field_75648_a.field_70170_p, MathHelper.func_76128_c((double)(this.field_75648_a.func_213303_ch().func_82615_a() + (double)moveX)), MathHelper.func_76128_c((double)this.field_75648_a.func_213303_ch().func_82617_b()), MathHelper.func_76128_c((double)(this.field_75648_a.func_213303_ch().func_82616_c() + (double)moveZ))) != PathNodeType.WALKABLE) {
                this.field_188489_f = 1.0f;
                this.field_188490_g = 0.0f;
                scaledSpeed = moveSpeed;
            }
            this.field_75648_a.func_70659_e(scaledSpeed);
            this.field_75648_a.func_191989_p(this.field_188489_f);
            this.field_75648_a.func_184646_p(this.field_188490_g);
            this.field_188491_h = MovementController.Action.WAIT;
        } else if (this.field_188491_h == MovementController.Action.MOVE_TO) {
            this.field_188491_h = MovementController.Action.WAIT;
            double distanceX = this.field_75646_b - this.field_75648_a.func_213303_ch().func_82615_a();
            double distanceZ = this.field_75644_d - this.field_75648_a.func_213303_ch().func_82616_c();
            double distanceY = this.field_75647_c - this.field_75648_a.func_213303_ch().func_82617_b();
            double distanceXZ = distanceX * distanceX + distanceZ * distanceZ;
            double distance = distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ;
            if (distance < 2.500000277905201E-7) {
                this.field_75648_a.func_191989_p(0.0f);
                return;
            }
            float moveZ = (float)(MathHelper.func_181159_b((double)distanceZ, (double)distanceX) * 57.2957763671875) - 90.0f;
            this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, moveZ, 90.0f);
            this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
            BlockPos entityPos = new BlockPos((Entity)this.field_75648_a);
            BlockState blockState = this.field_75648_a.field_70170_p.func_180495_p(entityPos);
            VoxelShape collisionShape = blockState.func_196952_d((IBlockReader)this.field_75648_a.field_70170_p, entityPos);
            double jumpRange = Math.max(1.0f, this.field_75648_a.func_213305_a((Pose)Pose.STANDING).field_220315_a + 0.25f);
            if (distanceY > (double)this.field_75648_a.field_70138_W && distanceXZ < jumpRange || !collisionShape.func_197766_b() && this.field_75648_a.func_213303_ch().func_82617_b() < collisionShape.func_197758_c(Direction.Axis.Y) + (double)entityPos.func_177956_o()) {
                this.field_75648_a.func_70683_ar().func_75660_a();
                this.field_188491_h = MovementController.Action.JUMPING;
            }
        } else if (this.field_188491_h == MovementController.Action.JUMPING) {
            this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
            if (this.field_75648_a.field_70122_E) {
                this.field_188491_h = MovementController.Action.WAIT;
            }
        } else {
            this.field_75648_a.func_191989_p(0.0f);
        }
    }

    public void tickSwimming() {
        if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.entityCreature.func_70661_as().func_75500_f()) {
            double x = this.field_75646_b - this.entityCreature.func_213303_ch().func_82615_a();
            double y = this.field_75647_c - this.entityCreature.func_213303_ch().func_82617_b();
            double z = this.field_75644_d - this.entityCreature.func_213303_ch().func_82616_c();
            double distance = x * x + y * y + z * z;
            distance = MathHelper.func_76133_a((double)distance);
            y /= distance;
            float f = (float)(MathHelper.func_181159_b((double)z, (double)x) * 57.29577951308232) - 90.0f;
            this.entityCreature.field_70761_aq = this.entityCreature.field_70177_z = this.func_75639_a(this.entityCreature.field_70177_z, f, 90.0f);
            float f1 = (float)(this.field_75645_e * this.entityCreature.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
            this.entityCreature.func_70659_e(this.entityCreature.func_70689_ay() + (f1 - this.entityCreature.func_70689_ay()) * 0.125f);
            double d4 = Math.sin((double)(this.entityCreature.field_70173_aa + this.entityCreature.func_145782_y()) * 0.5) * 0.05;
            double d5 = Math.cos(this.entityCreature.field_70177_z * ((float)Math.PI / 180));
            double d6 = Math.sin(this.entityCreature.field_70177_z * ((float)Math.PI / 180));
            double motionX = d4 * d5;
            double motionZ = d4 * d6;
            d4 = Math.sin((double)(this.entityCreature.field_70173_aa + this.entityCreature.func_145782_y()) * 0.75) * 0.05;
            double motionY = d4 * (d6 + d5) * 0.25;
            this.entityCreature.func_213317_d(this.entityCreature.func_213322_ci().func_72441_c(motionX, motionY += (double)this.entityCreature.func_70689_ay() * y * 0.125, motionZ));
            LookController lookController = this.entityCreature.func_70671_ap();
            double d7 = this.entityCreature.func_213303_ch().func_82615_a() + x / distance * 2.0;
            double d8 = (double)this.entityCreature.func_70047_e() + this.entityCreature.func_213303_ch().func_82617_b() + y / distance;
            double d9 = this.entityCreature.func_213303_ch().func_82616_c() + z / distance * 2.0;
            double d10 = lookController.func_180423_e();
            double d11 = lookController.func_180422_f();
            double d12 = lookController.func_180421_g();
            if (!lookController.func_180424_b()) {
                d10 = d7;
                d11 = d8;
                d12 = d9;
            }
            this.entityCreature.func_70671_ap().func_75650_a(d10 + (d7 - d10) * 0.125, d11 + (d8 - d11) * 0.125, d12 + (d9 - d12) * 0.125, 10.0f, 40.0f);
        } else {
            this.entityCreature.func_70659_e(0.0f);
        }
    }

    public void tickFlying() {
        if (this.field_188491_h == MovementController.Action.MOVE_TO) {
            double xDistance = this.field_75646_b - this.entityCreature.func_213303_ch().func_82615_a();
            double yDistance = this.field_75647_c - this.entityCreature.func_213303_ch().func_82617_b();
            double zDistance = this.field_75644_d - this.entityCreature.func_213303_ch().func_82616_c();
            double distance = xDistance * xDistance + yDistance * yDistance + zDistance * zDistance;
            if (this.courseChangeCooldown-- <= 0) {
                this.courseChangeCooldown += this.entityCreature.func_70681_au().nextInt(5) + 2;
                if ((distance = (double)MathHelper.func_76133_a((double)distance)) >= 1.0) {
                    this.entityCreature.func_70659_e((float)this.entityCreature.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                    double speed = (double)this.entityCreature.func_70689_ay() / 2.4 * this.func_75638_b();
                    double motionX = xDistance / distance * speed;
                    double motionY = yDistance / distance * speed;
                    double motionZ = zDistance / distance * speed;
                    this.entityCreature.func_213317_d(this.entityCreature.func_213322_ci().func_72441_c(motionX, motionY, motionZ));
                } else {
                    this.field_188491_h = MovementController.Action.WAIT;
                }
            }
        }
        if (this.entityCreature.func_70638_az() != null) {
            LivingEntity entitylivingbase = this.entityCreature.func_70638_az();
            double distanceX = entitylivingbase.func_213303_ch().func_82615_a() - this.entityCreature.func_213303_ch().func_82615_a();
            double distanceZ = entitylivingbase.func_213303_ch().func_82616_c() - this.entityCreature.func_213303_ch().func_82616_c();
            this.entityCreature.field_70761_aq = this.entityCreature.field_70177_z = -((float)MathHelper.func_181159_b((double)distanceX, (double)distanceZ)) * 57.295776f;
        } else if (this.field_188491_h == MovementController.Action.MOVE_TO) {
            this.entityCreature.field_70761_aq = this.entityCreature.field_70177_z = -((float)MathHelper.func_181159_b((double)this.entityCreature.func_213322_ci().func_82615_a(), (double)this.entityCreature.func_213322_ci().func_82616_c())) * 57.295776f;
        }
    }
}

