/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.goals.targeting;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.ExtendedEntity;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.targeting.FindAttackTargetGoal;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;

public class RevengeRiderGoal
extends FindAttackTargetGoal {
    private TameableCreatureEntity host;
    private int revengeTime;

    public RevengeRiderGoal(TameableCreatureEntity setHost) {
        super(setHost);
        this.host = setHost;
        this.tameTargeting = true;
    }

    @Override
    public RevengeRiderGoal setHelpCall(boolean setHelp) {
        this.callForHelp = setHelp;
        return this;
    }

    public RevengeRiderGoal setSightCheck(boolean setSightCheck) {
        this.checkSight = setSightCheck;
        return this;
    }

    @Override
    public RevengeRiderGoal setOnlyNearby(boolean setNearby) {
        this.nearbyOnly = setNearby;
        return this;
    }

    @Override
    public RevengeRiderGoal setCantSeeTimeMax(int setCantSeeTimeMax) {
        this.cantSeeTimeMax = setCantSeeTimeMax;
        return this;
    }

    @Override
    public boolean func_75250_a() {
        if (!this.host.hasRiderTarget()) {
            return false;
        }
        if (this.host.getRider() == null) {
            return false;
        }
        int i = this.getRiderRevengeTime();
        if (i == this.revengeTime) {
            return false;
        }
        return this.isEntityTargetable(this.getRiderRevengeTarget(), false);
    }

    @Override
    public void func_75249_e() {
        this.target = this.getRiderRevengeTarget();
        this.revengeTime = this.getRiderRevengeTime();
        try {
            if (this.callForHelp) {
                double d0 = this.getTargetDistance();
                List allies = this.host.func_130014_f_().func_175647_a(((Object)((Object)this.host)).getClass(), this.host.func_174813_aQ().func_72314_b(d0, 4.0, d0), (Predicate)((com.google.common.base.Predicate)input -> input instanceof LivingEntity));
                for (BaseCreatureEntity possibleAlly : allies) {
                    if (possibleAlly == this.host || possibleAlly.func_70638_az() != null || possibleAlly.func_184191_r((Entity)this.target)) continue;
                    possibleAlly.func_70624_b(this.target);
                }
            }
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "An exception occurred when selecting help targets in rider revenge, this has been skipped to prevent a crash.");
            e.printStackTrace();
        }
        super.func_75249_e();
    }

    @Override
    public boolean shouldStopTargeting(LivingEntity target) {
        return target != this.getRiderRevengeTarget();
    }

    public LivingEntity getRiderRevengeTarget() {
        ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(this.host.getRider());
        if (extendedEntity != null) {
            return extendedEntity.lastAttackedEntity;
        }
        return null;
    }

    public int getRiderRevengeTime() {
        ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(this.host.getRider());
        if (extendedEntity != null) {
            return extendedEntity.lastAttackedTime;
        }
        return 0;
    }
}

