/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.goals.targeting;

import com.lycanitesmobs.api.Targeting;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.targeting.TargetingGoal;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.TameableEntity;

public class DefendOwnerGoal
extends TargetingGoal {
    private TameableCreatureEntity tamedHost;

    public DefendOwnerGoal(TameableCreatureEntity setHost) {
        super(setHost);
        this.tamedHost = setHost;
        this.func_220684_a(EnumSet.of(Goal.Flag.TARGET));
    }

    public DefendOwnerGoal setSightCheck(boolean setSightCheck) {
        this.checkSight = setSightCheck;
        return this;
    }

    public DefendOwnerGoal setOnlyNearby(boolean setNearby) {
        this.nearbyOnly = setNearby;
        return this;
    }

    public DefendOwnerGoal setCantSeeTimeMax(int setCantSeeTimeMax) {
        this.cantSeeTimeMax = setCantSeeTimeMax;
        return this;
    }

    @Override
    protected LivingEntity getTarget() {
        return this.host.func_70638_az();
    }

    @Override
    protected void setTarget(LivingEntity newTarget) {
        this.host.func_70624_b(newTarget);
    }

    protected Entity getOwner() {
        return this.tamedHost.getPlayerOwner();
    }

    @Override
    protected boolean isValidTarget(LivingEntity target) {
        MobEntity mobEntity;
        if (target == null) {
            return false;
        }
        if (!this.tamedHost.isTamed() || this.getOwner() == null) {
            return false;
        }
        if (this.tamedHost.isPassive()) {
            return false;
        }
        if (!this.host.func_213398_dR()) {
            return false;
        }
        if (this.host.func_184191_r((Entity)target)) {
            return false;
        }
        if (target instanceof MobEntity && !(mobEntity = (MobEntity)target).func_213358_a(EntityType.field_200729_aH)) {
            return false;
        }
        if (!Targeting.isValidTarget((Entity)this.host, (Entity)target)) {
            return false;
        }
        if (target instanceof IMob && !(target instanceof TameableEntity) && !(target instanceof BaseCreatureEntity)) {
            return true;
        }
        if (target instanceof BaseCreatureEntity && ((BaseCreatureEntity)target).isHostileTo(this.getOwner())) {
            return true;
        }
        if (target instanceof MobEntity && ((MobEntity)target).func_70638_az() == this.getOwner()) {
            return true;
        }
        return target.func_70643_av() == this.getOwner();
    }

    public boolean func_75250_a() {
        this.target = null;
        if (!this.tamedHost.isTamed()) {
            return false;
        }
        if (this.tamedHost.isPassive()) {
            return false;
        }
        if (!this.host.func_213398_dR()) {
            return false;
        }
        double distance = this.getTargetDistance() - (double)this.host.func_213305_a((Pose)Pose.STANDING).field_220315_a;
        double heightDistance = 4.0 - (double)this.host.func_213305_a((Pose)Pose.STANDING).field_220316_b;
        if (this.host.useDirectNavigator()) {
            heightDistance = distance;
        }
        this.target = this.getNewTarget(distance, heightDistance, distance);
        if (this.callForHelp) {
            this.callNearbyForHelp();
        }
        return this.target != null;
    }

    @Override
    public boolean func_75253_b() {
        if (!this.isValidTarget(this.getTarget())) {
            return false;
        }
        return super.func_75253_b();
    }
}

