/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.goals.actions.abilities;

import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import java.util.EnumSet;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;

public class SummonMinionsGoal
extends Goal {
    BaseCreatureEntity host;
    protected int summonTime = 0;
    protected int summonRate = 60;
    protected int summonCap = 5;
    protected CreatureInfo minionInfo;
    protected boolean perPlayer = false;
    protected boolean antiFlight = false;
    protected int phase = -1;

    public SummonMinionsGoal(BaseCreatureEntity setHost) {
        this.host = setHost;
        this.func_220684_a(EnumSet.noneOf(Goal.Flag.class));
    }

    public SummonMinionsGoal setSummonRate(int summonRate) {
        this.summonRate = summonRate;
        return this;
    }

    public SummonMinionsGoal setSummonCap(int summonCap) {
        this.summonCap = summonCap;
        return this;
    }

    public SummonMinionsGoal setPerPlayer(boolean perPlayer) {
        this.perPlayer = perPlayer;
        return this;
    }

    public SummonMinionsGoal setAntiFlight(boolean antiFlight) {
        this.antiFlight = antiFlight;
        return this;
    }

    public SummonMinionsGoal setMinionInfo(String creatureName) {
        this.minionInfo = CreatureManager.getInstance().getCreature(creatureName);
        return this;
    }

    public SummonMinionsGoal setPhase(int phase) {
        this.phase = phase;
        return this;
    }

    public boolean func_75250_a() {
        if (!this.host.func_70089_S() || this.minionInfo == null) {
            return false;
        }
        return this.phase < 0 || this.phase == this.host.getBattlePhase();
    }

    public void func_75249_e() {
        this.summonTime = 1;
    }

    public void func_75246_d() {
        if (this.summonTime++ % this.summonRate != 0) {
            return;
        }
        if (this.host.getMinions(this.minionInfo.getEntityType()).size() >= this.summonCap) {
            return;
        }
        if (this.antiFlight) {
            for (PlayerEntity target : this.host.playerTargets) {
                if (target.field_71075_bZ.field_75102_a || target.func_175149_v() || !(CreatureManager.getInstance().config.bossAntiFlight > 0.0) || !(target.func_213303_ch().func_82617_b() > this.host.func_213303_ch().func_82617_b() + CreatureManager.getInstance().config.bossAntiFlight + 1.0)) continue;
                this.summonMinion((LivingEntity)target);
            }
            return;
        }
        this.summonMinion(this.host.func_70638_az());
    }

    protected void summonMinion(LivingEntity target) {
        LivingEntity minion = this.minionInfo.createEntity(this.host.func_130014_f_());
        this.host.summonMinion(minion, this.host.func_70681_au().nextDouble() * 360.0, this.host.func_213305_a((Pose)this.host.func_213283_Z()).field_220315_a + 1.0f);
        if (minion instanceof BaseCreatureEntity) {
            ((BaseCreatureEntity)minion).func_70624_b(target);
        }
    }
}

