/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.goals.actions.abilities;

import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.util.math.MathHelper;

public class ForceGoal
extends Goal {
    BaseCreatureEntity host;
    protected int duration = 200;
    protected int cooldownDuration = 300;
    protected int windUp = 60;
    protected float range = 300.0f;
    protected float force = 1.0f;
    protected int phase = -1;
    public int abilityTime = 0;
    public int cooldownTime = this.cooldownDuration;

    public ForceGoal(BaseCreatureEntity setHost) {
        this.host = setHost;
    }

    public ForceGoal setPhase(int phase) {
        this.phase = phase;
        return this;
    }

    public ForceGoal setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    public ForceGoal setCooldown(int cooldown) {
        this.cooldownDuration = cooldown;
        this.cooldownTime = cooldown;
        return this;
    }

    public ForceGoal setWindUp(int windUp) {
        this.windUp = windUp;
        return this;
    }

    public ForceGoal setRange(float range) {
        this.range = range;
        return this;
    }

    public ForceGoal setForce(float force) {
        this.force = force;
        return this;
    }

    public boolean func_75250_a() {
        if (!this.host.func_70089_S()) {
            return false;
        }
        return this.phase < 0 || this.phase == this.host.getBattlePhase();
    }

    public void func_75249_e() {
        this.cooldownTime = this.cooldownDuration;
    }

    public void func_75246_d() {
        if (this.cooldownTime-- > 0) {
            this.abilityTime = 0;
            return;
        }
        if (this.abilityTime == this.windUp) {
            this.host.playAttackSound();
        }
        if (this.abilityTime++ >= this.duration && this.cooldownDuration > 0) {
            this.cooldownTime = this.cooldownDuration;
            return;
        }
        double motionCap = -this.force;
        double factor = (double)(-this.force) * 0.1;
        if (this.abilityTime < this.windUp) {
            factor *= (double)(this.abilityTime / this.windUp);
        }
        for (Entity entity : this.host.getNearbyEntities(Entity.class, null, this.range)) {
            if (!(entity instanceof LivingEntity)) continue;
            double xDist = this.host.func_213303_ch().func_82615_a() - entity.func_213303_ch().func_82615_a();
            double zDist = this.host.func_213303_ch().func_82616_c() - entity.func_213303_ch().func_82616_c();
            double xzDist = MathHelper.func_76133_a((double)(xDist * xDist + zDist * zDist));
            ServerPlayerEntity player = null;
            if (entity instanceof ServerPlayerEntity) {
                player = (ServerPlayerEntity)entity;
                if (player.field_71075_bZ.field_75098_d) continue;
            }
            if (entity.func_213322_ci().func_82615_a() < motionCap && entity.func_213322_ci().func_82615_a() > -motionCap && entity.func_213322_ci().func_82616_c() < motionCap && entity.func_213322_ci().func_82616_c() > -motionCap) {
                entity.func_70024_g(xDist / xzDist * factor + entity.func_213322_ci().func_82615_a() * factor, 0.0, zDist / xzDist * factor + entity.func_213322_ci().func_82616_c() * factor);
            }
            if (player == null) continue;
            player.field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(entity));
        }
    }
}

