/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.goals.actions.abilities;

import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.Vec3d;

public class FireProjectilesGoal
extends Goal {
    BaseCreatureEntity host;
    protected String projectileName;
    protected Class<? extends BaseProjectileEntity> projectileClass;
    protected float velocity = 0.6f;
    protected float inaccuracy = 0.0f;
    protected float scale = 1.0f;
    protected float angle = 0.0f;
    protected Vec3d offset = Vec3d.field_186680_a;
    protected int fireRate = 60;
    protected boolean allPlayers = false;
    protected int randomCount = 0;
    protected int phase = -1;
    private int abilityTime = 60;
    private Entity attackTarget;

    public FireProjectilesGoal(BaseCreatureEntity setHost) {
        this.host = setHost;
        this.func_220684_a(EnumSet.noneOf(Goal.Flag.class));
    }

    public FireProjectilesGoal setPhase(int phase) {
        this.phase = phase;
        return this;
    }

    public FireProjectilesGoal setProjectile(String projectileName) {
        this.projectileName = projectileName;
        return this;
    }

    public FireProjectilesGoal setProjectile(Class<? extends BaseProjectileEntity> projectileClass) {
        this.projectileClass = projectileClass;
        return this;
    }

    public FireProjectilesGoal setFireRate(int fireRate) {
        this.fireRate = fireRate;
        return this;
    }

    public FireProjectilesGoal setVelocity(float velocity) {
        this.velocity = velocity;
        return this;
    }

    public FireProjectilesGoal setScale(float scale) {
        this.scale = scale;
        return this;
    }

    public FireProjectilesGoal setInaccuracy(int inaccuracy) {
        this.inaccuracy = inaccuracy;
        return this;
    }

    public FireProjectilesGoal setAngle(int angle) {
        this.angle = angle;
        return this;
    }

    public FireProjectilesGoal setOffset(Vec3d offset) {
        this.offset = offset;
        return this;
    }

    public FireProjectilesGoal setAllPlayers(boolean allPlayers) {
        this.allPlayers = allPlayers;
        return this;
    }

    public FireProjectilesGoal setRandomCount(int randomCount) {
        this.randomCount = randomCount;
        return this;
    }

    public boolean func_75250_a() {
        if (!this.host.func_70089_S() || this.projectileName == null && this.projectileClass == null) {
            return false;
        }
        this.attackTarget = this.host.func_70638_az();
        if (!this.allPlayers && this.randomCount <= 0 && this.attackTarget == null) {
            return false;
        }
        return this.phase < 0 || this.phase == this.host.getBattlePhase();
    }

    public void func_75249_e() {
        this.abilityTime = 1;
    }

    public void func_75251_c() {
        this.attackTarget = null;
    }

    public void func_75246_d() {
        if (this.abilityTime++ % this.fireRate != 0) {
            return;
        }
        if (this.allPlayers) {
            for (PlayerEntity target : this.host.playerTargets) {
                if (target.field_71075_bZ.field_75102_a || target.func_175149_v()) continue;
                this.fireProjectile((Entity)target);
            }
            return;
        }
        if (this.randomCount > 0) {
            for (int i = 0; i < this.randomCount; ++i) {
                this.host.fireProjectile(this.projectileName, null, this.host.func_70681_au().nextFloat() * 20.0f, this.host.func_70681_au().nextFloat() * this.angle, this.offset, this.velocity, this.scale, this.inaccuracy);
            }
            return;
        }
        this.fireProjectile(this.attackTarget);
    }

    public void fireProjectile(Entity target) {
        if (this.projectileName != null) {
            this.host.fireProjectile(this.projectileName, target, this.host.func_70032_d(target), this.angle, this.offset, this.velocity, this.scale, this.inaccuracy);
        }
        if (this.projectileClass != null) {
            this.host.fireProjectile(this.projectileClass, target, this.host.func_70032_d(target), this.angle, this.offset, this.velocity, this.scale, this.inaccuracy);
        }
    }
}

