/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.goals.actions.abilities;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;

public class EffectAuraGoal
extends Goal {
    BaseCreatureEntity host;
    protected Effect effect;
    protected float auraRange = 10.0f;
    protected int effectSeconds = 5;
    protected int effectAmplifier = 0;
    protected boolean checkSight = true;
    protected int phase = -1;
    protected float damageAmount = 0.0f;
    protected int duration = 200;
    protected int cooldownDuration = 0;
    protected int tickRate = 40;
    protected boolean targetAll = false;
    public int abilityTime = 0;
    public int cooldownTime = this.cooldownDuration;

    public EffectAuraGoal(BaseCreatureEntity setHost) {
        this.host = setHost;
    }

    public EffectAuraGoal setPhase(int phase) {
        this.phase = phase;
        return this;
    }

    public EffectAuraGoal setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    public EffectAuraGoal setCooldown(int cooldown) {
        this.cooldownDuration = cooldown;
        this.cooldownTime = cooldown;
        return this;
    }

    public EffectAuraGoal setTickRate(int tickRate) {
        this.tickRate = tickRate;
        return this;
    }

    public EffectAuraGoal setEffect(Effect effect) {
        this.effect = effect;
        return this;
    }

    public EffectAuraGoal setEffect(String effectName) {
        this.effect = ObjectManager.getEffect(effectName);
        return this;
    }

    public EffectAuraGoal setRange(float auraRange) {
        this.auraRange = auraRange;
        return this;
    }

    public EffectAuraGoal setEffectSeconds(int baseEffectSeconds) {
        this.effectSeconds = baseEffectSeconds;
        return this;
    }

    public EffectAuraGoal setAmplifier(int effectAmplifier) {
        this.effectAmplifier = effectAmplifier;
        return this;
    }

    public EffectAuraGoal setCheckSight(boolean checkSight) {
        this.checkSight = checkSight;
        return this;
    }

    public EffectAuraGoal setDamageAmount(float damageAmount) {
        this.damageAmount = damageAmount;
        return this;
    }

    public EffectAuraGoal setTargetAll(boolean targetAll) {
        this.targetAll = targetAll;
        return this;
    }

    public boolean func_75250_a() {
        if (!this.host.func_70089_S()) {
            return false;
        }
        return this.phase < 0 || this.phase == this.host.getBattlePhase();
    }

    public void func_75249_e() {
        this.cooldownTime = this.cooldownDuration;
        this.abilityTime = 0;
    }

    public void func_75246_d() {
        if (this.cooldownTime-- > 0) {
            this.abilityTime = 0;
            return;
        }
        if (this.abilityTime++ >= this.duration && this.cooldownDuration > 0) {
            this.cooldownTime = this.cooldownDuration;
            return;
        }
        if (this.abilityTime % this.tickRate != 0) {
            return;
        }
        EffectInstance effectInstance = null;
        if (this.effect != null) {
            effectInstance = new EffectInstance(this.effect, this.host.getEffectDuration(this.effectSeconds), this.effectAmplifier);
        }
        List<LivingEntity> aoeTargets = this.host.getNearbyEntities(LivingEntity.class, null, this.auraRange);
        for (LivingEntity entityObj : aoeTargets) {
            LivingEntity target = entityObj;
            if (target == this.host || !this.targetAll && (!this.host.func_213358_a(target.func_200600_R()) || !this.host.func_213336_c(target)) || this.checkSight && !this.host.func_70635_at().func_75522_a((Entity)target)) continue;
            if (effectInstance != null) {
                if (!target.func_70687_e(effectInstance)) continue;
                target.func_195064_c(effectInstance);
            }
            if (this.damageAmount == 0.0f) continue;
            EntityDamageSource damageSource = new EntityDamageSource("mob", (Entity)this.host);
            damageSource.func_151518_m();
            damageSource.func_76348_h();
            target.func_70097_a((DamageSource)damageSource, this.damageAmount);
            if (!this.host.minions.contains(target)) continue;
            this.host.onTryToDamageMinion(target, this.damageAmount);
        }
    }
}

