/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.google.common.collect.Maps;
import com.lycanitesmobs.core.entity.AgeableCreatureEntity;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.EatBlockGoal;
import com.lycanitesmobs.core.entity.goals.actions.TemptGoal;
import com.lycanitesmobs.core.info.ItemDrop;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class EntityYale
extends AgeableCreatureEntity
implements IShearable {
    protected static final DataParameter<Byte> FUR = EntityDataManager.func_187226_a(EntityYale.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final Map<DyeColor, IItemProvider> WOOL_BY_COLOR = (Map)Util.func_200696_a((Object)Maps.newEnumMap(DyeColor.class), itemProviderMap -> {
        itemProviderMap.put(DyeColor.WHITE, Blocks.field_196556_aL);
        itemProviderMap.put(DyeColor.ORANGE, Blocks.field_196557_aM);
        itemProviderMap.put(DyeColor.MAGENTA, Blocks.field_196558_aN);
        itemProviderMap.put(DyeColor.LIGHT_BLUE, Blocks.field_196559_aO);
        itemProviderMap.put(DyeColor.YELLOW, Blocks.field_196560_aP);
        itemProviderMap.put(DyeColor.LIME, Blocks.field_196561_aQ);
        itemProviderMap.put(DyeColor.PINK, Blocks.field_196562_aR);
        itemProviderMap.put(DyeColor.GRAY, Blocks.field_196563_aS);
        itemProviderMap.put(DyeColor.LIGHT_GRAY, Blocks.field_196564_aT);
        itemProviderMap.put(DyeColor.CYAN, Blocks.field_196565_aU);
        itemProviderMap.put(DyeColor.PURPLE, Blocks.field_196566_aV);
        itemProviderMap.put(DyeColor.BLUE, Blocks.field_196567_aW);
        itemProviderMap.put(DyeColor.BROWN, Blocks.field_196568_aX);
        itemProviderMap.put(DyeColor.GREEN, Blocks.field_196569_aY);
        itemProviderMap.put(DyeColor.RED, Blocks.field_196570_aZ);
        itemProviderMap.put(DyeColor.BLACK, Blocks.field_196602_ba);
    });
    private static final Map<DyeColor, float[]> DYE_TO_RGB = Maps.newEnumMap(Arrays.stream(DyeColor.values()).collect(Collectors.toMap(p_200204_0_ -> p_200204_0_, EntityYale::createSheepColor)));
    protected ItemDrop woolDrop;

    public EntityYale(EntityType<? extends EntityYale> entityType, World world) {
        super((EntityType<? extends AgeableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223222_a_;
        this.hasAttackSound = false;
        this.canGrow = true;
        this.babySpawnChance = 0.1;
        this.fleeHealthPercent = 1.0f;
        this.isAggressiveByDefault = false;
        this.setupMob();
        this.woolDrop = new ItemDrop(Blocks.field_196556_aL.getRegistryName().toString(), 1.0f).setMinAmount(1).setMaxAmount(3);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex++, (Goal)new EatBlockGoal(this).setBlocks(Blocks.field_150349_c).setReplaceBlock(Blocks.field_150346_d));
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextDistractionGoalIndex++, (Goal)new TemptGoal(this).setIncludeDiet(true));
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)new AttackMeleeGoal(this).setLongMemory(false));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FUR, (Object)1);
    }

    @Override
    public void onFirstSpawn() {
        if (!this.func_70631_g_()) {
            this.setColor(this.getRandomFurColor(this.func_70681_au()));
        }
        super.onFirstSpawn();
    }

    public boolean isShearable(@Nonnull ItemStack item, IWorldReader world, BlockPos pos) {
        return this.hasFur() && !this.func_70631_g_();
    }

    public ArrayList<ItemStack> onSheared(@Nonnull ItemStack item, IWorld world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> dropStacks = new ArrayList<ItemStack>();
        if (this.woolDrop == null) {
            return dropStacks;
        }
        this.setFur(false);
        this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
        int quantity = this.woolDrop.getQuantity(this.func_70681_au(), fortune, 1);
        ItemStack dropStack = this.woolDrop.getEntityDropItemStack((LivingEntity)this, quantity);
        this.dropItem(dropStack);
        dropStacks.add(dropStack);
        return dropStacks;
    }

    public boolean hasFur() {
        if (this.field_70180_af == null) {
            return true;
        }
        return (Byte)this.field_70180_af.func_187225_a(FUR) > 0;
    }

    public void setFur(boolean fur) {
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(FUR, (Object)((byte)(fur ? 1 : 0)));
        }
    }

    @Override
    public void onEat() {
        if (!this.func_130014_f_().field_72995_K) {
            this.setFur(true);
        }
    }

    @Override
    public boolean canBeColored(PlayerEntity player) {
        return true;
    }

    @Override
    public void setColor(DyeColor color) {
        Item woolItem = WOOL_BY_COLOR.get(this.getColor()).func_199767_j();
        if (this.woolDrop == null) {
            this.woolDrop = new ItemDrop(woolItem.getRegistryName().toString(), 1.0f).setMinAmount(1).setMaxAmount(3);
        } else if (this.woolDrop.getItemStack().func_77973_b() != woolItem) {
            this.woolDrop.setDrop(new ItemStack((IItemProvider)woolItem, 1));
        }
        super.setColor(color);
    }

    public DyeColor getRandomFurColor(Random random) {
        int i = random.nextInt(100);
        if (i < 5) {
            return DyeColor.BLACK;
        }
        if (i < 10) {
            return DyeColor.GREEN;
        }
        if (i < 15) {
            return DyeColor.RED;
        }
        if (i < 18) {
            return DyeColor.BROWN;
        }
        return random.nextInt(500) == 0 ? DyeColor.PINK : DyeColor.WHITE;
    }

    private DyeColor getMixedFurColor(BaseCreatureEntity father, BaseCreatureEntity mother) {
        DyeColor dyeA = father.getColor();
        DyeColor dyeB = mother.getColor();
        CraftingInventory craftinginventory = EntityYale.mixColors(dyeA, dyeB);
        return this.field_70170_p.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)craftinginventory, this.field_70170_p).map(craftingRecipe -> craftingRecipe.func_77572_b((IInventory)craftinginventory)).map(ItemStack::func_77973_b).filter(DyeItem.class::isInstance).map(DyeItem.class::cast).map(DyeItem::func_195962_g).orElseGet(() -> this.field_70170_p.field_73012_v.nextBoolean() ? dyeA : dyeB);
    }

    private static CraftingInventory mixColors(DyeColor dyeA, DyeColor dyeB) {
        CraftingInventory craftinginventory = new CraftingInventory(new Container(null, -1){

            public boolean func_75145_c(PlayerEntity playerIn) {
                return false;
            }
        }, 2, 1);
        craftinginventory.func_70299_a(0, new ItemStack((IItemProvider)DyeItem.func_195961_a((DyeColor)dyeA)));
        craftinginventory.func_70299_a(1, new ItemStack((IItemProvider)DyeItem.func_195961_a((DyeColor)dyeB)));
        return craftinginventory;
    }

    private static float[] createSheepColor(DyeColor p_192020_0_) {
        if (p_192020_0_ == DyeColor.WHITE) {
            return new float[]{0.9019608f, 0.9019608f, 0.9019608f};
        }
        float[] afloat = p_192020_0_.func_193349_f();
        float f = 0.75f;
        return new float[]{afloat[0] * 0.75f, afloat[1] * 0.75f, afloat[2] * 0.75f};
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        BlockState blockState = this.func_130014_f_().func_180495_p(new BlockPos(x, y - 1, z));
        Block block = blockState.func_177230_c();
        if (block != Blocks.field_150350_a) {
            if (blockState.func_185904_a() == Material.field_151577_b) {
                return 10.0f;
            }
            if (blockState.func_185904_a() == Material.field_151578_c) {
                return 7.0f;
            }
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean func_184652_a(PlayerEntity player) {
        return true;
    }

    @Override
    public float getFallResistance() {
        return 50.0f;
    }

    @Override
    protected void func_213345_d(DamageSource damageSource) {
        if (!this.hasFur()) {
            this.woolDrop.setMinAmount(0).setMaxAmount(0);
        }
        super.func_213345_d(damageSource);
    }

    @Override
    public AgeableCreatureEntity createChild(AgeableCreatureEntity partner) {
        AgeableCreatureEntity baby = super.createChild(partner);
        DyeColor color = this.getMixedFurColor(this, partner);
        baby.setColor(color);
        return baby;
    }

    @Override
    public void func_70037_a(CompoundNBT nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("HasFur")) {
            this.setFur(nbtTagCompound.func_74767_n("HasFur"));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT nbtTagCompound) {
        super.func_213281_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("HasFur", this.hasFur());
    }
}

