/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.SilverfishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;

public class EntityVolcan
extends TameableCreatureEntity
implements IMob {
    public int blockMeltingRadius = 2;

    public EntityVolcan(EntityType<? extends EntityVolcan> entityType, World world) {
        super((EntityType<? extends TameableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223222_a_;
        this.hasAttackSound = true;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(2, (Goal)new AttackMeleeGoal(this).setLongMemory(true));
    }

    @Override
    public void loadCreatureFlags() {
        this.blockMeltingRadius = this.creatureInfo.getFlag("blockMeltingRadius", this.blockMeltingRadius);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K && this.updateTick % 40L == 0L) {
            List<LivingEntity> aoeTargets = this.getNearbyEntities(LivingEntity.class, null, 4.0);
            for (LivingEntity entityObj : aoeTargets) {
                LivingEntity target = entityObj;
                if (target == this || !this.func_213358_a(target.func_200600_R()) || !this.func_213336_c(target) || !this.func_70635_at().func_75522_a((Entity)target)) continue;
                target.func_70015_d(2);
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.updateTick % 40L == 0L && this.blockMeltingRadius > 0 && !this.isTamed() && this.func_130014_f_().func_82736_K().func_223586_b(GameRules.field_223599_b)) {
            int range = this.blockMeltingRadius;
            int w = -((int)Math.ceil(this.func_213305_a((Pose)Pose.STANDING).field_220315_a) + range);
            while ((double)w <= Math.ceil(this.func_213305_a((Pose)Pose.STANDING).field_220315_a) + (double)range) {
                int d = -((int)Math.ceil(this.func_213305_a((Pose)Pose.STANDING).field_220315_a) + range);
                while ((double)d <= Math.ceil(this.func_213305_a((Pose)Pose.STANDING).field_220315_a) + (double)range) {
                    int h = -((int)Math.ceil(this.func_213305_a((Pose)Pose.STANDING).field_220316_b) + range);
                    while ((double)h <= Math.ceil(this.func_213305_a((Pose)Pose.STANDING).field_220316_b)) {
                        Block block = this.func_130014_f_().func_180495_p(this.func_180425_c().func_177982_a(w, h, d)).func_177230_c();
                        if (block == Blocks.field_150347_e || block == Blocks.field_150351_n) {
                            BlockState blockState = (BlockState)Blocks.field_150353_l.func_176223_P().func_206870_a((IProperty)FlowingFluidBlock.field_176367_b, (Comparable)Integer.valueOf(5));
                            this.func_130014_f_().func_175656_a(this.func_180425_c().func_177982_a(w, h, d), blockState);
                        }
                        ++h;
                    }
                    ++d;
                }
                ++w;
            }
        }
        if (this.func_130014_f_().field_72995_K) {
            int i;
            for (i = 0; i < 2; ++i) {
                this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_213303_ch().func_82615_a() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, this.func_213303_ch().func_82617_b() + this.field_70146_Z.nextDouble() * (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b, this.func_213303_ch().func_82616_c() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, 0.0, 0.0, 0.0);
                this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197617_j, this.func_213303_ch().func_82615_a() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, this.func_213303_ch().func_82617_b() + this.field_70146_Z.nextDouble() * (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b, this.func_213303_ch().func_82616_c() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, 0.0, 0.0, 0.0);
            }
            if (this.field_70173_aa % 10 == 0) {
                for (i = 0; i < 2; ++i) {
                    this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_213303_ch().func_82615_a() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, this.func_213303_ch().func_82617_b() + this.field_70146_Z.nextDouble() * (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b, this.func_213303_ch().func_82616_c() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        if (target instanceof SilverfishEntity) {
            target.func_70106_y();
        }
        return true;
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean performCommand(String command, PlayerEntity player, ItemStack itemStack) {
        if (command.equals("Water")) {
            this.replacePlayersItem(player, itemStack, new ItemStack((IItemProvider)Items.field_151129_at));
            return true;
        }
        return super.performCommand(command, player, itemStack);
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76347_k()) {
            return 0.0f;
        }
        return super.getDamageModifier(damageSrc);
    }

    @Override
    public boolean isInvulnerableTo(String type, DamageSource source, float damage) {
        if (type.equals("cactus") || type.equals("inWall")) {
            return false;
        }
        return super.isInvulnerableTo(type, source, damage);
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public boolean waterDamage() {
        return true;
    }
}

