/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.AgeableCreatureEntity;
import com.lycanitesmobs.core.entity.creature.EntityConba;
import com.lycanitesmobs.core.entity.creature.EntityVespidQueen;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.PlaceBlockGoal;
import com.lycanitesmobs.core.entity.goals.targeting.FindMasterGoal;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;

public class EntityVespid
extends AgeableCreatureEntity
implements IMob {
    public PlaceBlockGoal aiPlaceBlock;
    private boolean hiveBuilding = true;

    public EntityVespid(EntityType<? extends EntityVespid> entityType, World world) {
        super((EntityType<? extends AgeableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223224_c_;
        this.hasAttackSound = true;
        this.setupMob();
        this.canGrow = true;
        this.babySpawnChance = 0.1;
        this.field_70138_W = 1.0f;
        this.setAttackCooldownMax(10);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)new AttackMeleeGoal(this).setLongMemory(true));
        this.aiPlaceBlock = new PlaceBlockGoal(this).setMaxDistance(128.0).setSpeed(3.0);
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex++, (Goal)this.aiPlaceBlock);
        this.field_70715_bh.func_75776_a(this.nextFindTargetIndex++, (Goal)new FindMasterGoal(this).setTargetClass(EntityVespidQueen.class).setRange(64.0));
    }

    @Override
    public void loadCreatureFlags() {
        this.hiveBuilding = this.creatureInfo.getFlag("hiveBuilding", this.hiveBuilding);
    }

    @Override
    public boolean isPersistant() {
        if (this.hasMaster() && this.func_130014_f_().func_175659_aa() != Difficulty.PEACEFUL) {
            return true;
        }
        return super.isPersistant();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K) {
            if (!this.field_70145_X) {
                if (this.isHiveBlock(this.func_180425_c())) {
                    this.field_70145_X = true;
                }
            } else if (!this.isHiveBlock(this.func_180425_c())) {
                this.field_70145_X = false;
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.hiveBuilding && this.hasMaster() && this.getMasterTarget() instanceof EntityVespidQueen && this.aiPlaceBlock.blockState == null) {
            EntityVespidQueen queen = (EntityVespidQueen)this.getMasterTarget();
            if (!queen.hiveFoundationsSet()) {
                int z;
                int endZ;
                int y;
                int endY;
                int x;
                int endX;
                ArrayList<Byte> directions = new ArrayList<Byte>();
                if (!queen.doesHiveHaveXPositive()) {
                    directions.add((byte)0);
                }
                if (!queen.doesHiveHaveXNegative()) {
                    directions.add((byte)1);
                }
                if (!queen.doesHiveHaveYPositive()) {
                    directions.add((byte)2);
                }
                if (!queen.doesHiveHaveYNegative()) {
                    directions.add((byte)3);
                }
                if (!queen.doesHiveHaveZPositive()) {
                    directions.add((byte)4);
                }
                if (!queen.doesHiveHaveZNegative()) {
                    directions.add((byte)5);
                }
                BlockPos hivePos = queen.getHivePosition();
                int hiveMin = 5;
                int hiveMinFloor = 3;
                int hiveMax = 16;
                int direction = 6;
                if (directions.size() == 1) {
                    direction = ((Byte)directions.get(0)).byteValue();
                } else if (directions.size() > 1) {
                    direction = ((Byte)directions.get(this.func_70681_au().nextInt(directions.size()))).byteValue();
                }
                if (direction == 0) {
                    x = endX = hivePos.func_177958_n();
                    while (x <= hivePos.func_177958_n() + hiveMax && this.aiPlaceBlock.canPlaceBlock(new BlockPos(x, hivePos.func_177956_o(), hivePos.func_177952_p()))) {
                        endX = x++;
                    }
                    if (endX >= hivePos.func_177958_n() + hiveMin) {
                        this.aiPlaceBlock.setMetadata(5);
                        this.aiPlaceBlock.setBlockPlacement(ObjectManager.getBlock("veswax").func_176223_P(), new BlockPos(endX, hivePos.func_177956_o(), hivePos.func_177952_p()));
                    }
                } else if (direction == 1) {
                    x = endX = hivePos.func_177958_n() - hiveMin;
                    while (x >= hivePos.func_177958_n() - hiveMax && this.aiPlaceBlock.canPlaceBlock(new BlockPos(x, hivePos.func_177956_o(), hivePos.func_177952_p()))) {
                        endX = x--;
                    }
                    if (endX <= hivePos.func_177958_n() - hiveMin) {
                        this.aiPlaceBlock.setMetadata(4);
                        this.aiPlaceBlock.setBlockPlacement(ObjectManager.getBlock("veswax").func_176223_P(), new BlockPos(endX, hivePos.func_177956_o(), hivePos.func_177952_p()));
                    }
                }
                if (direction == 2) {
                    y = endY = hivePos.func_177956_o() + hiveMin;
                    while (y <= hivePos.func_177956_o() + hiveMax && this.aiPlaceBlock.canPlaceBlock(new BlockPos(hivePos.func_177958_n(), y, hivePos.func_177952_p()))) {
                        endY = y++;
                    }
                    if (endY >= hivePos.func_177956_o() + hiveMin) {
                        this.aiPlaceBlock.setMetadata(0);
                        this.aiPlaceBlock.setBlockPlacement(ObjectManager.getBlock("propolis").func_176223_P(), new BlockPos(hivePos.func_177958_n(), endY, hivePos.func_177952_p()));
                    }
                } else if (direction == 3) {
                    y = endY = hivePos.func_177956_o() - hiveMinFloor;
                    while (y >= hivePos.func_177956_o() - hiveMax && this.aiPlaceBlock.canPlaceBlock(new BlockPos(hivePos.func_177958_n(), y, hivePos.func_177952_p()))) {
                        endY = y--;
                    }
                    if (endY <= hivePos.func_177956_o() - hiveMin) {
                        this.aiPlaceBlock.setMetadata(1);
                        this.aiPlaceBlock.setBlockPlacement(ObjectManager.getBlock("propolis").func_176223_P(), new BlockPos(hivePos.func_177958_n(), endY, hivePos.func_177952_p()));
                    }
                }
                if (direction == 4) {
                    z = endZ = hivePos.func_177952_p() + hiveMin;
                    while (z <= hivePos.func_177952_p() + hiveMax && this.aiPlaceBlock.canPlaceBlock(new BlockPos(hivePos.func_177958_n(), hivePos.func_177956_o(), z))) {
                        endZ = z++;
                    }
                    if (endZ >= hivePos.func_177952_p() + hiveMin) {
                        this.aiPlaceBlock.setMetadata(2);
                        this.aiPlaceBlock.setBlockPlacement(ObjectManager.getBlock("veswax").func_176223_P(), new BlockPos(hivePos.func_177958_n(), hivePos.func_177956_o(), endZ));
                    }
                } else if (direction == 5) {
                    z = endZ = hivePos.func_177952_p() - hiveMin;
                    while (z >= hivePos.func_177952_p() - hiveMax && this.aiPlaceBlock.canPlaceBlock(new BlockPos(hivePos.func_177958_n(), hivePos.func_177956_o(), z))) {
                        endZ = z--;
                    }
                    if (endZ <= hivePos.func_177952_p() - hiveMin) {
                        this.aiPlaceBlock.setMetadata(3);
                        this.aiPlaceBlock.setBlockPlacement(ObjectManager.getBlock("veswax").func_176223_P(), new BlockPos(hivePos.func_177958_n(), hivePos.func_177956_o(), endZ));
                    }
                }
            } else {
                List<EntityVespidQueen.HiveExposedCoordinates> hiveExposedCoordsList = queen.getHiveExposureBlocks();
                if (hiveExposedCoordsList.size() > 0) {
                    EntityVespidQueen.HiveExposedCoordinates hiveExposedCoords = hiveExposedCoordsList.size() > 1 ? hiveExposedCoordsList.get(this.func_70681_au().nextInt(hiveExposedCoordsList.size())) : hiveExposedCoordsList.get(0);
                    this.aiPlaceBlock.setMetadata(hiveExposedCoords.orientationMeta);
                    this.aiPlaceBlock.setBlockPlacement(hiveExposedCoords.block.func_176223_P(), hiveExposedCoords.pos);
                }
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.func_70638_az() instanceof EntityConba && ((EntityConba)this.func_70638_az()).vespidInfection) {
            this.func_70624_b(null);
        }
    }

    public boolean isHiveBlock(BlockPos searchPos) {
        return this.isHiveWall(searchPos) || this.isHiveFloor(searchPos);
    }

    public boolean isHiveWall(BlockPos searchPos) {
        BlockState searchState = this.func_130014_f_().func_180495_p(searchPos);
        Block searchBlock = searchState.func_177230_c();
        return searchBlock == ObjectManager.getBlock("veswax");
    }

    public boolean isHiveFloor(BlockPos searchPos) {
        BlockState searchState = this.func_130014_f_().func_180495_p(searchPos);
        Block searchBlock = searchState.func_177230_c();
        return searchBlock == ObjectManager.getBlock("veswax");
    }

    @Override
    public boolean func_213336_c(LivingEntity targetEntity) {
        if (targetEntity == this.getMasterTarget()) {
            return false;
        }
        if (targetEntity instanceof EntityConba) {
            return false;
        }
        if (targetEntity instanceof EntityVespid && (!((EntityVespid)targetEntity).hasMaster() || ((EntityVespid)targetEntity).getMasterTarget() == this.getMasterTarget())) {
            return false;
        }
        if (targetEntity instanceof EntityVespidQueen && (!this.hasMaster() || this.getMasterTarget() == targetEntity)) {
            return false;
        }
        return super.func_213336_c(targetEntity);
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76347_k()) {
            return 4.0f;
        }
        return 1.0f;
    }

    @Override
    public boolean isInvulnerableTo(String type, DamageSource source, float damage) {
        if (type.equals("inWall")) {
            return false;
        }
        return super.isInvulnerableTo(type, source, damage);
    }
}

