/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.entity.goals.actions.BreakDoorGoal;
import com.lycanitesmobs.core.entity.projectile.EntityBoulderBlast;
import com.lycanitesmobs.core.info.ObjectLists;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;

public class EntityTroll
extends TameableCreatureEntity
implements IMob {
    public boolean griefing = true;
    public boolean stoneForm = false;

    public EntityTroll(EntityType<? extends EntityTroll> entityType, World world) {
        super((EntityType<? extends TameableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223222_a_;
        this.hasAttackSound = false;
        this.solidCollision = true;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextDistractionGoalIndex++, (Goal)new BreakDoorGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)new AttackRangedGoal(this).setSpeed(0.75).setRange(40.0f).setMinChaseDistance(10.0f).setLongMemory(false));
        if (this.func_70661_as() instanceof GroundPathNavigator) {
            GroundPathNavigator pathNavigateGround = (GroundPathNavigator)this.func_70661_as();
            pathNavigateGround.func_179688_b(true);
        }
    }

    @Override
    public void loadCreatureFlags() {
        this.griefing = this.creatureInfo.getFlag("griefing", this.griefing);
    }

    @Override
    public String getTextureName() {
        if (this.stoneForm) {
            return super.getTextureName() + "_stone";
        }
        return super.getTextureName();
    }

    @Override
    public void func_70636_d() {
        float distance;
        super.func_70636_d();
        if (!this.stoneForm) {
            if (this.isDaytime() && this.func_130014_f_().func_175710_j(this.func_180425_c())) {
                this.stoneForm = true;
            }
        } else if (!this.isDaytime() || !this.func_130014_f_().func_175710_j(this.func_180425_c())) {
            this.stoneForm = false;
        }
        if (!this.func_130014_f_().field_72995_K && this.func_70638_az() != null && this.func_130014_f_().func_82736_K().func_223586_b(GameRules.field_223599_b) && this.griefing && (distance = this.func_70638_az().func_70032_d((Entity)this)) <= this.func_213305_a((Pose)Pose.STANDING).field_220315_a + 4.0f) {
            this.destroyArea((int)this.func_213303_ch().func_82615_a(), (int)this.func_213303_ch().func_82617_b(), (int)this.func_213303_ch().func_82616_c(), 0.5f, true);
        }
    }

    @Override
    public float getAISpeedModifier() {
        if (this.stoneForm) {
            return 0.125f;
        }
        return 1.0f;
    }

    @Override
    public void attackRanged(Entity target, float range) {
        this.fireProjectile(EntityBoulderBlast.class, target, range, 0.0f, new Vec3d(0.0, 0.0, 0.0), 1.2f, 2.0f, 1.0f);
        super.attackRanged(target, range);
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76346_g() != null) {
            LivingEntity entityLiving;
            ItemStack heldItem = ItemStack.field_190927_a;
            if (damageSrc.func_76346_g() instanceof LivingEntity && !(entityLiving = (LivingEntity)damageSrc.func_76346_g()).func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
                heldItem = entityLiving.func_184586_b(Hand.MAIN_HAND);
            }
            if (ObjectLists.isPickaxe(heldItem)) {
                return 3.0f;
            }
        }
        return super.getDamageModifier(damageSrc);
    }

    @Override
    public float getFallResistance() {
        return 50.0f;
    }

    @Override
    public boolean canBurn() {
        return !this.stoneForm;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }
}

