/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.entity.projectile.EntityLifeDrain;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;

public class EntitySpriggan
extends TameableCreatureEntity
implements IMob {
    public int farmingRate = 20;
    private int farmingTick = 0;
    EntityLifeDrain projectile = null;

    public EntitySpriggan(EntityType<? extends EntitySpriggan> entityType, World world) {
        super((EntityType<? extends TameableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223222_a_;
        this.hasAttackSound = false;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)new AttackRangedGoal(this).setSpeed(0.75).setStaminaTime(100).setRange(8.0f).setMinChaseDistance(4.0f));
    }

    @Override
    public void loadCreatureFlags() {
        this.farmingRate = this.creatureInfo.getFlag("farmingRate", this.farmingRate);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70086_ai() >= 0) {
            if (this.func_70090_H()) {
                this.func_195064_c(new EffectInstance(Effects.field_76428_l, 60, 2));
            } else if (this.func_203008_ap()) {
                this.func_195064_c(new EffectInstance(Effects.field_76428_l, 60, 1));
            }
        }
        int currentFarmingRate = this.farmingRate;
        if (this.isTamed() && currentFarmingRate > 0) {
            if (this.isPetType("familiar")) {
                currentFarmingRate = this.farmingRate * 10;
            }
            if (this.subspecies != null) {
                currentFarmingRate = Math.max(1, Math.round((float)this.farmingRate / 3.0f));
            }
            ++this.farmingTick;
            int farmingRange = 16;
            int farmingHeight = 4;
            for (int x = (int)this.func_213303_ch().func_82615_a() - farmingRange; x <= (int)this.func_213303_ch().func_82615_a() + farmingRange; ++x) {
                for (int y = (int)this.func_213303_ch().func_82617_b() - farmingHeight; y <= (int)this.func_213303_ch().func_82617_b() + farmingHeight; ++y) {
                    for (int z = (int)this.func_213303_ch().func_82616_c() - farmingRange; z <= (int)this.func_213303_ch().func_82616_c() + farmingRange; ++z) {
                        IGrowable growableBlock;
                        BlockPos pos = new BlockPos(x, y, z);
                        Block farmingBlock = this.func_130014_f_().func_180495_p(pos).func_177230_c();
                        if (!(farmingBlock instanceof IPlantable) || !(farmingBlock instanceof IGrowable) || farmingBlock == Blocks.field_196804_gh) continue;
                        if (!this.func_130014_f_().field_72995_K && this.func_130014_f_() instanceof ServerWorld && this.farmingTick % currentFarmingRate == 0 && (growableBlock = (IGrowable)farmingBlock).func_176473_a((IBlockReader)this.func_130014_f_(), pos, this.func_130014_f_().func_180495_p(pos), this.func_130014_f_().func_201670_d()) && growableBlock.func_180670_a(this.func_130014_f_(), this.func_70681_au(), pos, this.func_130014_f_().func_180495_p(pos))) {
                            growableBlock.func_225535_a_((ServerWorld)this.func_130014_f_(), this.func_70681_au(), pos, this.func_130014_f_().func_180495_p(pos));
                        }
                        if (!this.func_130014_f_().field_72995_K || this.farmingTick % 40 != 0) continue;
                        double d0 = this.func_70681_au().nextGaussian() * 0.02;
                        double d1 = this.func_70681_au().nextGaussian() * 0.02;
                        double d2 = this.func_70681_au().nextGaussian() * 0.02;
                        this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197632_y, (double)((float)x + this.func_70681_au().nextFloat()), (double)y + (double)this.func_70681_au().nextFloat(), (double)((float)z + this.func_70681_au().nextFloat()), d0, d1, d2);
                    }
                }
            }
        }
        if (this.func_130014_f_().field_72995_K && !CreatureManager.getInstance().config.disableBlockParticles) {
            for (int i = 0; i < 2; ++i) {
                this.func_130014_f_().func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_196804_gh.func_176223_P()), this.func_213303_ch().func_82615_a() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, this.func_213303_ch().func_82617_b() + this.field_70146_Z.nextDouble() * (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b, this.func_213303_ch().func_82616_c() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void attackRanged(Entity target, float range) {
        if (this.projectile != null && this.projectile.func_70089_S()) {
            this.projectile.setTime(20);
        } else {
            this.projectile = null;
        }
        if (this.projectile == null) {
            this.projectile = new EntityLifeDrain(ProjectileManager.getInstance().oldProjectileTypes.get(EntityLifeDrain.class), this.func_130014_f_(), (LivingEntity)this, 25, 20);
            this.func_184185_a(this.projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.func_130014_f_().func_217376_c((Entity)this.projectile);
        }
        super.attackRanged(target, range);
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76347_k()) {
            return 2.0f;
        }
        if (damageSrc.func_76346_g() != null) {
            LivingEntity entityLiving;
            ItemStack heldItem = ItemStack.field_190927_a;
            if (damageSrc.func_76346_g() instanceof LivingEntity && !(entityLiving = (LivingEntity)damageSrc.func_76346_g()).func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
                heldItem = entityLiving.func_184586_b(Hand.MAIN_HAND);
            }
            if (ObjectLists.isAxe(heldItem)) {
                return 2.0f;
            }
        }
        return super.getDamageModifier(damageSrc);
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 5;
    }
}

