/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupBoss;
import com.lycanitesmobs.api.IGroupHeavy;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.StealthGoal;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntitySpectre
extends TameableCreatureEntity
implements IMob,
IGroupHeavy {
    protected int pullRange = 6;
    protected int pullEnergy = 0;
    protected int pullEnergyMax = 40;
    protected int pullEnergyRecharge = 0;
    protected int pullEnergyRechargeMax = 80;
    protected boolean pullRecharging = true;

    public EntitySpectre(EntityType<? extends EntitySpectre> entityType, World world) {
        super((EntityType<? extends TameableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223222_a_;
        this.hasAttackSound = true;
        this.spawnsInWater = true;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextPriorityGoalIndex++, (Goal)new StealthGoal(this).setStealthTime(20).setStealthAttack(true).setStealthMove(true));
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)new AttackMeleeGoal(this).setLongMemory(true));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.pullRecharging && ++this.pullEnergyRecharge >= this.pullEnergyRechargeMax) {
                this.pullRecharging = false;
                this.pullEnergy = this.pullEnergyMax;
                this.pullEnergyRecharge = 0;
            }
            this.pullEnergy = Math.min(this.pullEnergy, this.pullEnergyMax);
            if (this.canPull()) {
                for (LivingEntity entity : this.getNearbyEntities(LivingEntity.class, null, this.pullRange)) {
                    if (entity == this || entity == this.func_184179_bs() || entity instanceof IGroupBoss || entity instanceof IGroupHeavy || entity.func_70644_a((Effect)ObjectManager.getEffect("weight")) || !this.func_213336_c(entity)) continue;
                    ServerPlayerEntity player = null;
                    if (entity instanceof ServerPlayerEntity) {
                        player = (ServerPlayerEntity)entity;
                        if (player.field_71075_bZ.field_75098_d) continue;
                    }
                    double xDist = this.func_213303_ch().func_82615_a() - entity.func_213303_ch().func_82615_a();
                    double zDist = this.func_213303_ch().func_82616_c() - entity.func_213303_ch().func_82616_c();
                    double xzDist = MathHelper.func_76133_a((double)(xDist * xDist + zDist * zDist));
                    double factor = 0.1;
                    double motionCap = 10.0;
                    if (entity.func_213322_ci().func_82615_a() < motionCap && entity.func_213322_ci().func_82615_a() > -motionCap && entity.func_213322_ci().func_82616_c() < motionCap && entity.func_213322_ci().func_82616_c() > -motionCap) {
                        entity.func_70024_g(xDist / xzDist * factor + entity.func_213322_ci().func_82615_a() * factor, 0.0, zDist / xzDist * factor + entity.func_213322_ci().func_82616_c() * factor);
                    }
                    if (player == null) continue;
                    player.field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)entity));
                }
                if (--this.pullEnergy <= 0) {
                    this.pullRecharging = true;
                    this.pullEnergyRecharge = 0;
                }
            }
        }
        if (this.func_130014_f_().field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.func_213303_ch().func_82615_a() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, this.func_213303_ch().func_82617_b() + this.field_70146_Z.nextDouble() * (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b, this.func_213303_ch().func_82616_c() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public boolean extraAnimation01() {
        if (this.func_130014_f_().field_72995_K) {
            return super.extraAnimation01();
        }
        return this.canPull();
    }

    public boolean canPull() {
        if (this.func_130014_f_().field_72995_K) {
            return this.extraAnimation01();
        }
        return !this.pullRecharging && this.hasAttackTarget() && this.func_70032_d((Entity)this.func_70638_az()) <= (float)(this.pullRange * 3);
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean isStrongSwimmer() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public boolean isInvulnerableTo(String type, DamageSource source, float damage) {
        if (type.equals("inWall")) {
            return false;
        }
        return super.isInvulnerableTo(type, source, damage);
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }
}

