/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.RideableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import java.util.List;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.Event;

public class EntityShade
extends RideableCreatureEntity {
    public EntityShade(EntityType<? extends EntityShade> entityType, World world) {
        super((EntityType<? extends RideableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223222_a_;
        this.hasAttackSound = true;
        this.hasJumpSound = true;
        this.canGrow = false;
        this.setupMob();
        this.field_70138_W = 1.0f;
        this.attackCooldownMax = 40;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)new AttackMeleeGoal(this).setSpeed(1.5));
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.abilityToggled) {
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        this.specialAttack();
        this.applyStaminaCost();
    }

    @Override
    public float getStaminaCost() {
        return 100.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 100;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 1.0f;
    }

    @Override
    public double func_70042_X() {
        return (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b * 0.85;
    }

    @Override
    public double getMountedZOffset() {
        return (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a * 0.25;
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        float leeching = this.getEffectStrength(this.getAttackDamage(damageScale) / 4.0f);
        this.func_70691_i(leeching);
        if (this.func_70681_au().nextFloat() <= 0.1f) {
            this.specialAttack();
        }
        return true;
    }

    public void specialAttack() {
        double distance = 5.0;
        List possibleTargets = this.func_130014_f_().func_175647_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(distance, distance, distance), possibleTarget -> possibleTarget.func_70089_S() && possibleTarget != this && !this.func_184215_y((Entity)possibleTarget) && !this.func_184191_r((Entity)possibleTarget) && this.func_213358_a(possibleTarget.func_200600_R()) && this.func_213336_c((LivingEntity)possibleTarget));
        if (!possibleTargets.isEmpty()) {
            for (LivingEntity possibleTarget2 : possibleTargets) {
                boolean doDamage = true;
                if (this.getRider() instanceof PlayerEntity && MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent((PlayerEntity)this.getRider(), (Entity)possibleTarget2))) {
                    doDamage = false;
                }
                if (!doDamage) continue;
                if (ObjectManager.getEffect("fear") != null) {
                    possibleTarget2.func_195064_c(new EffectInstance((Effect)ObjectManager.getEffect("fear"), this.getEffectDuration(5), 1));
                    continue;
                }
                possibleTarget2.func_195064_c(new EffectInstance(Effects.field_76437_t, 200, 0));
            }
        }
        this.playAttackSound();
        this.triggerAttackCooldown();
    }

    @Override
    public boolean canBeTempted() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 10;
    }

    @Override
    public boolean isInvulnerableTo(String type, DamageSource source, float damage) {
        if (type.equals("inWall")) {
            return false;
        }
        return super.isInvulnerableTo(type, source, damage);
    }

    @Override
    public float getFallResistance() {
        return 10.0f;
    }
}

