/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.api.IGroupHeavy;
import com.lycanitesmobs.core.entity.RapidFireProjectileEntity;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.StealthGoal;
import com.lycanitesmobs.core.entity.projectile.EntityBlizzard;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntitySerpix
extends TameableCreatureEntity
implements IGroupHeavy {
    public EntitySerpix(EntityType<? extends EntitySerpix> entityType, World world) {
        super((EntityType<? extends TameableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223224_c_;
        this.spawnsOnLand = true;
        this.spawnsInWater = true;
        this.hasAttackSound = false;
        this.babySpawnChance = 0.25;
        this.growthTime = -120000;
        this.setupMob();
        this.hitAreaWidthScale = 1.5f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextPriorityGoalIndex++, (Goal)new StealthGoal(this).setStealthTime(60));
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)new AttackRangedGoal(this).setSpeed(0.5).setStaminaTime(100).setRange(12.0f).setMinChaseDistance(8.0f));
    }

    @Override
    public float getAISpeedModifier() {
        if (this.func_70090_H()) {
            return 2.0f;
        }
        return 1.0f;
    }

    @Override
    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public void attackRanged(Entity target, float range) {
        ArrayList<RapidFireProjectileEntity> projectiles = new ArrayList<RapidFireProjectileEntity>();
        RapidFireProjectileEntity projectileEntry = new RapidFireProjectileEntity(ProjectileManager.getInstance().oldProjectileTypes.get(RapidFireProjectileEntity.class), EntityBlizzard.class, this.func_130014_f_(), (LivingEntity)this, 15, 3);
        projectiles.add(projectileEntry);
        RapidFireProjectileEntity projectileEntry2 = new RapidFireProjectileEntity(ProjectileManager.getInstance().oldProjectileTypes.get(RapidFireProjectileEntity.class), EntityBlizzard.class, this.func_130014_f_(), (LivingEntity)this, 15, 3);
        projectileEntry2.offsetX += 1.0;
        projectiles.add(projectileEntry2);
        RapidFireProjectileEntity projectileEntry3 = new RapidFireProjectileEntity(ProjectileManager.getInstance().oldProjectileTypes.get(RapidFireProjectileEntity.class), EntityBlizzard.class, this.func_130014_f_(), (LivingEntity)this, 15, 3);
        projectileEntry3.offsetX -= 1.0;
        projectiles.add(projectileEntry3);
        RapidFireProjectileEntity projectileEntry4 = new RapidFireProjectileEntity(ProjectileManager.getInstance().oldProjectileTypes.get(RapidFireProjectileEntity.class), EntityBlizzard.class, this.func_130014_f_(), (LivingEntity)this, 15, 3);
        projectileEntry4.offsetZ += 1.0;
        projectiles.add(projectileEntry4);
        RapidFireProjectileEntity projectileEntry5 = new RapidFireProjectileEntity(ProjectileManager.getInstance().oldProjectileTypes.get(RapidFireProjectileEntity.class), EntityBlizzard.class, this.func_130014_f_(), (LivingEntity)this, 15, 3);
        projectileEntry5.offsetZ -= 1.0;
        projectiles.add(projectileEntry5);
        RapidFireProjectileEntity projectileEntry6 = new RapidFireProjectileEntity(ProjectileManager.getInstance().oldProjectileTypes.get(RapidFireProjectileEntity.class), EntityBlizzard.class, this.func_130014_f_(), (LivingEntity)this, 15, 3);
        projectileEntry6.offsetY += 1.0;
        projectiles.add(projectileEntry6);
        RapidFireProjectileEntity projectileEntry7 = new RapidFireProjectileEntity(ProjectileManager.getInstance().oldProjectileTypes.get(RapidFireProjectileEntity.class), EntityBlizzard.class, this.func_130014_f_(), (LivingEntity)this, 15, 3);
        projectileEntry7.offsetY -= 10.0;
        projectiles.add(projectileEntry7);
        BlockPos launchPos = this.getFacingPosition(4.0);
        for (RapidFireProjectileEntity projectile : projectiles) {
            projectile.setProjectileScale(1.0f);
            projectile.func_70107_b(projectile.func_213303_ch().func_82615_a(), projectile.func_213303_ch().func_82617_b() - (double)(this.func_213305_a((Pose)Pose.STANDING).field_220316_b / 4.0f), projectile.func_213303_ch().func_82616_c());
            float accuracy = 1.0f * (this.func_70681_au().nextFloat() - 0.5f);
            double d0 = target.func_213303_ch().func_82615_a() - (double)launchPos.func_177958_n() + (double)accuracy;
            double d1 = target.func_213303_ch().func_82617_b() + (double)target.func_70047_e() - (double)1.1f - projectile.func_213303_ch().func_82617_b() + (double)accuracy;
            double d2 = target.func_213303_ch().func_82616_c() - (double)launchPos.func_177952_p() + (double)accuracy;
            float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
            float velocity = 1.2f;
            projectile.func_70186_c(d0, d1 + (double)f1, d2, velocity, 6.0f);
            this.func_184185_a(projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            projectile.func_70107_b(launchPos.func_177958_n(), launchPos.func_177956_o(), launchPos.func_177952_p());
            this.func_130014_f_().func_217376_c((Entity)projectile);
        }
        super.attackRanged(target, range);
    }

    @Override
    public boolean canStealth() {
        if (this.isTamed() && this.isSitting()) {
            return false;
        }
        BlockState blockState = this.func_130014_f_().func_180495_p(this.func_180425_c().func_177982_a(0, -1, 0));
        if (blockState.func_177230_c() != Blocks.field_150350_a) {
            if (blockState.func_185904_a() == Material.field_151578_c) {
                return true;
            }
            if (blockState.func_185904_a() == Material.field_151577_b) {
                return true;
            }
            if (blockState.func_185904_a() == Material.field_151584_j) {
                return true;
            }
            if (blockState.func_185904_a() == Material.field_151595_p) {
                return true;
            }
            if (blockState.func_185904_a() == Material.field_151571_B) {
                return true;
            }
            if (blockState.func_185904_a() == Material.field_151597_y) {
                return true;
            }
            if (blockState.func_185904_a() == Material.field_151596_z) {
                return true;
            }
        }
        return blockState.func_177230_c() == Blocks.field_150424_aL;
    }

    @Override
    public boolean canBeTempted() {
        return this.func_70631_g_();
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 5;
    }

    @Override
    public boolean isInvulnerableTo(String type, DamageSource source, float damage) {
        if (type.equals("ooze")) {
            return false;
        }
        if (type.equals("cactus")) {
            return false;
        }
        if (type.equals("inWall")) {
            return false;
        }
        return super.isInvulnerableTo(type, source, damage);
    }
}

