/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupBoss;
import com.lycanitesmobs.api.IGroupHeavy;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.creature.EntityBehemoth;
import com.lycanitesmobs.core.entity.creature.EntityBelph;
import com.lycanitesmobs.core.entity.creature.EntityWraith;
import com.lycanitesmobs.core.entity.projectile.EntityHellfireBarrier;
import com.lycanitesmobs.core.entity.projectile.EntityHellfireOrb;
import com.lycanitesmobs.core.entity.projectile.EntityHellfireWave;
import com.lycanitesmobs.core.entity.projectile.EntityHellfireball;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.ZombiePigmanEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityRahovart
extends BaseCreatureEntity
implements IMob,
IGroupHeavy,
IGroupBoss {
    public List<PlayerEntity> playerTargets = new ArrayList<PlayerEntity>();
    public int hellfireEnergy = 0;
    public List<EntityHellfireOrb> hellfireOrbs = new ArrayList<EntityHellfireOrb>();
    protected static final DataParameter<Integer> HELLFIRE_ENERGY = EntityDataManager.func_187226_a(EntityRahovart.class, (IDataSerializer)DataSerializers.field_187192_b);
    public List<EntityBelph> hellfireBelphMinions = new ArrayList<EntityBelph>();
    public List<EntityBehemoth> hellfireBehemothMinions = new ArrayList<EntityBehemoth>();
    public int hellfireWallTime = 0;
    public int hellfireWallTimeMax = 400;
    public boolean hellfireWallClockwise = false;
    public EntityHellfireBarrier hellfireWallLeft;
    public EntityHellfireBarrier hellfireWallRight;
    public List<EntityHellfireBarrier> hellfireBarriers = new ArrayList<EntityHellfireBarrier>();
    public int hellfireBarrierHealth = 100;

    public EntityRahovart(EntityType<? extends EntityRahovart> entityType, World world) {
        super(entityType, world);
        this.attribute = CreatureAttribute.field_223223_b_;
        this.hasAttackSound = false;
        this.setAttackCooldownMax(40);
        this.solidCollision = true;
        this.field_70144_Y = 1.0f;
        this.setupMob();
        this.hitAreaWidthScale = 2.0f;
        this.damageMax = BaseCreatureEntity.BOSS_DAMAGE_LIMIT;
        this.damageLimit = BaseCreatureEntity.BOSS_DAMAGE_LIMIT;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HELLFIRE_ENERGY, (Object)this.hellfireEnergy);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_72314_b(200.0, 50.0, 200.0).func_72317_d(0.0, -25.0, 0.0);
    }

    @Override
    public void onFirstSpawn() {
        super.onFirstSpawn();
        if (this.getArenaCenter() == null) {
            this.setArenaCenter(this.func_180425_c());
        }
    }

    @Override
    public void setArenaCenter(BlockPos pos) {
        super.setArenaCenter(pos);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.hasAttackTarget() && !this.func_130014_f_().field_72995_K) {
            this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
        }
        if (this.hasArenaCenter()) {
            BlockPos arenaPos = this.getArenaCenter();
            double arenaY = this.func_213303_ch().func_82617_b();
            if (this.func_130014_f_().func_175623_d(arenaPos)) {
                arenaY = arenaPos.func_177956_o();
            } else if (this.func_130014_f_().func_175623_d(arenaPos.func_177982_a(0, 1, 0))) {
                arenaY = arenaPos.func_177982_a(0, 1, 0).func_177956_o();
            }
            if (this.func_213303_ch().func_82615_a() != (double)arenaPos.func_177958_n() || this.func_213303_ch().func_82617_b() != arenaY || this.func_213303_ch().func_82616_c() != (double)arenaPos.func_177952_p()) {
                this.func_70107_b(arenaPos.func_177958_n(), arenaY, arenaPos.func_177952_p());
            }
        }
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(HELLFIRE_ENERGY, (Object)this.hellfireEnergy);
        } else {
            this.hellfireEnergy = (Integer)this.field_70180_af.func_187225_a(HELLFIRE_ENERGY);
        }
        EntityRahovart.updateHellfireOrbs((LivingEntity)this, this.updateTick, 5, this.hellfireEnergy, 10.0f, this.hellfireOrbs);
        if (!this.func_130014_f_().field_72995_K) {
            this.updatePhases();
        }
        if (!this.func_130014_f_().field_72995_K && this.updateTick % 200L == 0L) {
            this.playerTargets = this.getNearbyEntities(PlayerEntity.class, null, 64.0);
        }
        if (!this.func_130014_f_().field_72995_K && this.updateTick % 20L == 0L && this.playerTargets.size() == 0) {
            this.func_70691_i(50.0f);
        }
        if (!this.func_130014_f_().field_72995_K && this.updateTick % 20L == 0L) {
            for (int i = 0; i < 3; ++i) {
                EntityHellfireball projectile = new EntityHellfireball(ProjectileManager.getInstance().oldProjectileTypes.get(EntityHellfireball.class), this.func_130014_f_(), (LivingEntity)this);
                projectile.setProjectileScale(8.0f);
                projectile.func_70186_c(this.func_70681_au().nextFloat() - 0.5f, this.func_70681_au().nextFloat(), this.func_70681_au().nextFloat() - 0.5f, 1.2f, 3.0f);
                this.func_184185_a(((BaseProjectileEntity)projectile).getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                this.func_130014_f_().func_217376_c((Entity)projectile);
            }
            for (PlayerEntity target : this.playerTargets) {
                if (target.field_71075_bZ.field_75102_a || target.func_175149_v()) continue;
                this.attackRanged((Entity)target, 1.0f);
                if (!(CreatureManager.getInstance().config.bossAntiFlight > 0.0) || !(target.func_213303_ch().func_82617_b() > this.func_213303_ch().func_82617_b() + CreatureManager.getInstance().config.bossAntiFlight + 1.0)) continue;
                for (int i = 0; i < 3; ++i) {
                    EntityWraith minion = (EntityWraith)CreatureManager.getInstance().getCreature("wraith").createEntity(this.func_130014_f_());
                    this.summonMinion((LivingEntity)minion, this.func_70681_au().nextDouble() * 360.0, 5.0);
                    minion.func_70624_b((LivingEntity)target);
                    minion.setMasterTarget(null);
                }
            }
            if (this.hasAttackTarget()) {
                this.attackRanged((Entity)this.func_70638_az(), 1.0f);
            }
        }
    }

    @Override
    public boolean rollWanderChance() {
        return false;
    }

    public void updatePhases() {
        int summonCount;
        if (this.getBattlePhase() == 0) {
            if (!this.hellfireBehemothMinions.isEmpty()) {
                for (EntityBehemoth entityBehemoth : this.hellfireBehemothMinions.toArray(new EntityBehemoth[this.hellfireBehemothMinions.size()])) {
                    entityBehemoth.hellfireEnergy = 0;
                }
                this.hellfireBehemothMinions = new ArrayList<EntityBehemoth>();
            }
            this.hellfireWallTime = 0;
            this.hellfireBarrierCleanup();
            if (this.updateTick % 20L == 0L) {
                for (TameableCreatureEntity tameableCreatureEntity : this.hellfireBelphMinions.toArray(new EntityBelph[this.hellfireBelphMinions.size()])) {
                    if (!tameableCreatureEntity.func_70089_S()) {
                        this.onMinionDeath((LivingEntity)tameableCreatureEntity, null);
                        continue;
                    }
                    ((EntityBelph)tameableCreatureEntity).hellfireEnergy += 5;
                    if (((EntityBelph)tameableCreatureEntity).hellfireEnergy < 100) continue;
                    this.hellfireEnergy += 20;
                    this.onMinionDeath((LivingEntity)tameableCreatureEntity, null);
                    this.func_130014_f_().func_217385_a((Entity)tameableCreatureEntity, tameableCreatureEntity.func_213303_ch().func_82615_a(), tameableCreatureEntity.func_213303_ch().func_82617_b(), tameableCreatureEntity.func_213303_ch().func_82616_c(), 1.0f, Explosion.Mode.NONE);
                    ((EntityBelph)tameableCreatureEntity).hellfireEnergy = 0;
                    tameableCreatureEntity.func_70106_y();
                }
            }
            if (this.hellfireEnergy >= 100) {
                this.hellfireEnergy = 0;
                double angle = this.func_70681_au().nextFloat() * 360.0f;
                if (this.hasAttackTarget()) {
                    double deltaX = this.func_70638_az().func_213303_ch().func_82615_a() - this.func_213303_ch().func_82615_a();
                    double deltaZ = this.func_70638_az().func_213303_ch().func_82616_c() - this.func_213303_ch().func_82616_c();
                    angle = Math.atan2(deltaZ, deltaX) * 180.0 / Math.PI;
                }
                this.hellfireWaveAttack(angle);
            }
            if (this.updateTick % 100L == 0L) {
                int summonAmount = this.func_70681_au().nextInt(4);
                if ((summonAmount *= this.playerTargets.size()) > 0) {
                    for (summonCount = 0; summonCount <= summonAmount; ++summonCount) {
                        EntityBelph minion3 = (EntityBelph)CreatureManager.getInstance().getCreature("belph").createEntity(this.func_130014_f_());
                        this.summonMinion((LivingEntity)minion3, this.func_70681_au().nextDouble() * 360.0, 5.0);
                        this.hellfireBelphMinions.add(minion3);
                    }
                }
            }
        }
        if (this.getBattlePhase() == 1) {
            if (!this.hellfireBelphMinions.isEmpty()) {
                EntityBelph[] summonAmount = this.hellfireBelphMinions.toArray(new EntityBelph[this.hellfireBelphMinions.size()]);
                summonCount = summonAmount.length;
                for (int minion3 = 0; minion3 < summonCount; ++minion3) {
                    EntityBelph entityBelph = summonAmount[minion3];
                    entityBelph.hellfireEnergy = 0;
                }
                this.hellfireBelphMinions = new ArrayList<EntityBelph>();
            }
            this.hellfireBarrierCleanup();
            if (this.hellfireWallTime <= 0 && this.updateTick % 20L == 0L) {
                EntityBehemoth[] summonAmount = this.hellfireBehemothMinions.toArray(new EntityBehemoth[this.hellfireBehemothMinions.size()]);
                summonCount = summonAmount.length;
                for (int minion3 = 0; minion3 < summonCount; ++minion3) {
                    EntityBehemoth entityBehemoth = summonAmount[minion3];
                    if (!entityBehemoth.func_70089_S()) {
                        this.onMinionDeath((LivingEntity)entityBehemoth, null);
                        continue;
                    }
                    entityBehemoth.hellfireEnergy += 5;
                    if (entityBehemoth.hellfireEnergy < 100) continue;
                    this.hellfireEnergy += 20;
                    this.onMinionDeath((LivingEntity)entityBehemoth, null);
                    this.func_130014_f_().func_217385_a((Entity)entityBehemoth, entityBehemoth.func_213303_ch().func_82615_a(), entityBehemoth.func_213303_ch().func_82617_b(), entityBehemoth.func_213303_ch().func_82616_c(), 1.0f, Explosion.Mode.NONE);
                    entityBehemoth.hellfireEnergy = 0;
                    entityBehemoth.func_70106_y();
                }
            }
            if (this.hellfireEnergy >= 100) {
                this.hellfireEnergy = 0;
                this.hellfireWallAttack(this.field_70177_z);
            }
            if (this.hellfireWallTime > 0) {
                this.hellfireWallUpdate();
                --this.hellfireWallTime;
            }
            if (this.updateTick % 400L == 0L) {
                int summonAmount = 2;
                if ((summonAmount *= this.playerTargets.size()) > 0) {
                    for (summonCount = 0; summonCount <= summonAmount; ++summonCount) {
                        EntityBehemoth minion4 = (EntityBehemoth)CreatureManager.getInstance().getCreature("behemoth").createEntity(this.func_130014_f_());
                        this.summonMinion((LivingEntity)minion4, this.func_70681_au().nextDouble() * 360.0, 5.0);
                        this.hellfireBehemothMinions.add(minion4);
                    }
                }
            }
            if (this.updateTick % 200L == 0L) {
                int summonAmount = this.func_70681_au().nextInt(4) - 1;
                for (summonCount = 0; summonCount <= summonAmount; ++summonCount) {
                    EntityBelph minion5 = (EntityBelph)CreatureManager.getInstance().getCreature("belph").createEntity(this.func_130014_f_());
                    this.summonMinion((LivingEntity)minion5, this.func_70681_au().nextDouble() * 360.0, 5.0);
                }
            }
        }
        if (this.getBattlePhase() >= 2) {
            if (!this.hellfireBelphMinions.isEmpty()) {
                EntityBelph[] summonAmount = this.hellfireBelphMinions.toArray(new EntityBelph[this.hellfireBelphMinions.size()]);
                summonCount = summonAmount.length;
                for (int minion5 = 0; minion5 < summonCount; ++minion5) {
                    EntityBelph entityBelph = summonAmount[minion5];
                    entityBelph.hellfireEnergy = 0;
                }
                this.hellfireBelphMinions = new ArrayList<EntityBelph>();
            }
            if (!this.hellfireBehemothMinions.isEmpty()) {
                EntityBehemoth[] summonAmount = this.hellfireBehemothMinions.toArray(new EntityBehemoth[this.hellfireBehemothMinions.size()]);
                summonCount = summonAmount.length;
                for (int minion5 = 0; minion5 < summonCount; ++minion5) {
                    EntityBehemoth entityBehemoth = summonAmount[minion5];
                    entityBehemoth.hellfireEnergy = 0;
                }
                this.hellfireBehemothMinions = new ArrayList<EntityBehemoth>();
            }
            this.hellfireWallTime = 0;
            if (this.updateTick % 20L == 0L && this.hellfireEnergy < 100) {
                this.hellfireEnergy += 5;
            }
            if (this.hellfireEnergy >= 100 && this.hellfireBarriers.size() < 20) {
                this.hellfireEnergy = 0;
                this.hellfireBarrierAttack(360.0f * this.func_70681_au().nextFloat());
            }
            if (this.hellfireBarriers.size() > 0) {
                this.hellfireBarrierUpdate();
            }
            if (this.updateTick % 200L == 0L) {
                int summonAmount = this.func_70681_au().nextInt(2);
                if ((summonAmount *= this.playerTargets.size()) > 0) {
                    for (summonCount = 0; summonCount <= summonAmount; ++summonCount) {
                        EntityBehemoth minion6 = (EntityBehemoth)CreatureManager.getInstance().getCreature("behemoth").createEntity(this.func_130014_f_());
                        this.summonMinion((LivingEntity)minion6, this.func_70681_au().nextDouble() * 360.0, 5.0);
                        this.hellfireBehemothMinions.add(minion6);
                    }
                }
            }
            if (this.updateTick % 400L == 0L) {
                int summonAmount = this.func_70681_au().nextInt(4);
                if ((summonAmount *= this.playerTargets.size()) > 0) {
                    for (summonCount = 0; summonCount <= summonAmount; ++summonCount) {
                        EntityBelph minion7 = (EntityBelph)CreatureManager.getInstance().getCreature("belph").createEntity(this.func_130014_f_());
                        this.summonMinion((LivingEntity)minion7, this.func_70681_au().nextDouble() * 360.0, 5.0);
                    }
                }
                summonAmount = this.func_70681_au().nextInt(3);
                if ((summonAmount *= this.playerTargets.size()) > 0) {
                    for (summonCount = 0; summonCount <= summonAmount; ++summonCount) {
                        EntityWraith minion8 = (EntityWraith)CreatureManager.getInstance().getCreature("wraith").createEntity(this.func_130014_f_());
                        this.summonMinion((LivingEntity)minion8, this.func_70681_au().nextDouble() * 360.0, 5.0);
                    }
                }
            }
        }
        if (this.hellfireWallTime <= 0) {
            this.hellfireWallCleanup();
        }
    }

    @Override
    public void onMinionDeath(LivingEntity minion, DamageSource damageSource) {
        if (minion instanceof EntityBelph && this.hellfireBelphMinions.contains(minion)) {
            this.hellfireBelphMinions.remove(minion);
            return;
        }
        if (minion instanceof EntityBehemoth && this.hellfireBehemothMinions.contains(minion)) {
            this.hellfireBehemothMinions.remove(minion);
            return;
        }
        if (this.hellfireBarriers.size() > 0) {
            this.hellfireBarrierHealth = minion instanceof EntityBehemoth ? (this.hellfireBarrierHealth -= 100) : (this.hellfireBarrierHealth -= 50);
        }
        super.onMinionDeath(minion, damageSource);
    }

    @Override
    public void updateBattlePhase() {
        double healthNormal = this.func_110143_aJ() / this.func_110138_aP();
        if (healthNormal <= 0.2) {
            this.setBattlePhase(2);
            return;
        }
        if (healthNormal <= 0.6) {
            this.setBattlePhase(1);
            return;
        }
        this.setBattlePhase(0);
    }

    public static void updateHellfireOrbs(LivingEntity entity, long orbTick, int hellfireOrbMax, int hellfireOrbEnergy, float orbSize, List<EntityHellfireOrb> hellfireOrbs) {
        if (!entity.func_130014_f_().field_72995_K) {
            return;
        }
        int hellfireChargeCount = Math.round((float)Math.min(hellfireOrbEnergy, 100) / (100.0f / (float)hellfireOrbMax));
        int hellfireOrbRotationTime = 100;
        double hellfireOrbAngle = 360.0f * ((float)(orbTick % (long)hellfireOrbRotationTime) / (float)hellfireOrbRotationTime);
        double hellfireOrbAngleOffset = 360.0 / (double)hellfireOrbMax;
        while (hellfireOrbs.size() < hellfireChargeCount) {
            EntityHellfireOrb hellfireOrb = new EntityHellfireOrb(ProjectileManager.getInstance().oldProjectileTypes.get(EntityHellfireOrb.class), entity.func_130014_f_(), entity);
            hellfireOrb.clientOnly = true;
            hellfireOrbs.add(hellfireOrb);
            entity.func_130014_f_().func_217376_c((Entity)hellfireOrb);
            hellfireOrb.setProjectileScale(orbSize);
        }
        while (hellfireOrbs.size() > hellfireChargeCount) {
            hellfireOrbs.get(hellfireOrbs.size() - 1).func_70106_y();
            hellfireOrbs.remove(hellfireOrbs.size() - 1);
        }
        for (int i = 0; i < hellfireOrbs.size(); ++i) {
            EntityHellfireOrb hellfireOrb = hellfireOrbs.get(i);
            double rotationRadians = Math.toRadians((hellfireOrbAngle + hellfireOrbAngleOffset * (double)i) % 360.0);
            double x = (double)entity.func_213305_a((Pose)Pose.STANDING).field_220315_a * 1.25 * Math.cos(rotationRadians) + Math.sin(rotationRadians);
            double z = (double)entity.func_213305_a((Pose)Pose.STANDING).field_220315_a * 1.25 * Math.sin(rotationRadians) - Math.cos(rotationRadians);
            hellfireOrb.func_70107_b(entity.func_213303_ch().func_82615_a() - x, entity.func_213303_ch().func_82617_b() + (double)(entity.func_213305_a((Pose)Pose.STANDING).field_220316_b * 0.75f), entity.func_213303_ch().func_82616_c() - z);
            hellfireOrb.func_70107_b(entity.func_213303_ch().func_82615_a() - x, entity.func_213303_ch().func_82617_b() + (double)(entity.func_213305_a((Pose)Pose.STANDING).field_220316_b * 0.75f), entity.func_213303_ch().func_82616_c() - z);
            hellfireOrb.projectileLife = 5;
        }
    }

    @Override
    public boolean func_213336_c(LivingEntity targetEntity) {
        if (targetEntity instanceof EntityBelph || targetEntity instanceof EntityBehemoth || targetEntity instanceof EntityWraith) {
            if (targetEntity instanceof TameableCreatureEntity) {
                return ((TameableCreatureEntity)targetEntity).getOwner() instanceof PlayerEntity;
            }
            return false;
        }
        return super.func_213336_c(targetEntity);
    }

    @Override
    public void attackRanged(Entity target, float range) {
        this.fireProjectile(EntityHellfireball.class, target, range, 0.0f, new Vec3d(0.0, 0.0, 0.0), 1.2f, 8.0f, 1.0f);
        super.attackRanged(target, range);
    }

    public void hellfireWaveAttack(double angle) {
        this.triggerAttackCooldown();
        this.playAttackSound();
        EntityHellfireWave hellfireWave = new EntityHellfireWave(ProjectileManager.getInstance().oldProjectileTypes.get(EntityHellfireWave.class), this.func_130014_f_(), (LivingEntity)this);
        hellfireWave.func_70107_b(hellfireWave.func_213303_ch().func_82615_a(), this.func_213303_ch().func_82617_b(), hellfireWave.func_213303_ch().func_82616_c());
        hellfireWave.rotation = angle;
        this.func_130014_f_().func_217376_c((Entity)hellfireWave);
    }

    public void hellfireWallAttack(double angle) {
        this.playAttackSound();
        this.triggerAttackCooldown();
        this.hellfireWallTime = this.hellfireWallTimeMax;
        this.hellfireWallClockwise = this.func_70681_au().nextBoolean();
    }

    public void hellfireWallUpdate() {
        this.triggerAttackCooldown();
        double hellfireWallNormal = (double)this.hellfireWallTime / (double)this.hellfireWallTimeMax;
        double hellfireWallAngle = 360.0;
        if (this.hellfireWallClockwise) {
            hellfireWallAngle = -360.0;
        }
        if (this.hellfireWallLeft == null) {
            this.hellfireWallLeft = new EntityHellfireBarrier(ProjectileManager.getInstance().oldProjectileTypes.get(EntityHellfireBarrier.class), this.func_130014_f_(), (LivingEntity)this);
            this.hellfireWallLeft.wall = true;
            this.func_130014_f_().func_217376_c((Entity)this.hellfireWallLeft);
        }
        this.hellfireWallLeft.time = 0;
        this.hellfireWallLeft.func_70107_b(this.func_213303_ch().func_82615_a(), this.func_213303_ch().func_82617_b(), this.func_213303_ch().func_82616_c());
        this.hellfireWallLeft.rotation = hellfireWallNormal * hellfireWallAngle;
        if (this.hellfireWallRight == null) {
            this.hellfireWallRight = new EntityHellfireBarrier(ProjectileManager.getInstance().oldProjectileTypes.get(EntityHellfireBarrier.class), this.func_130014_f_(), (LivingEntity)this);
            this.hellfireWallRight.wall = true;
            this.func_130014_f_().func_217376_c((Entity)this.hellfireWallRight);
        }
        this.hellfireWallRight.time = 0;
        this.hellfireWallRight.func_70107_b(this.func_213303_ch().func_82615_a(), this.func_213303_ch().func_82617_b(), this.func_213303_ch().func_82616_c());
        this.hellfireWallRight.rotation = 180.0 + hellfireWallNormal * hellfireWallAngle;
    }

    public void hellfireWallCleanup() {
        if (this.hellfireWallLeft != null) {
            this.hellfireWallLeft.func_70106_y();
            this.hellfireWallLeft = null;
        }
        if (this.hellfireWallRight != null) {
            this.hellfireWallRight.func_70106_y();
            this.hellfireWallRight = null;
        }
    }

    public void hellfireBarrierAttack(double angle) {
        if (this.hellfireBarriers.size() >= 10) {
            return;
        }
        this.triggerAttackCooldown();
        this.playAttackSound();
        EntityHellfireBarrier hellfireBarrier = new EntityHellfireBarrier(ProjectileManager.getInstance().oldProjectileTypes.get(EntityHellfireBarrier.class), this.func_130014_f_(), (LivingEntity)this);
        this.func_130014_f_().func_217376_c((Entity)hellfireBarrier);
        hellfireBarrier.time = 0;
        hellfireBarrier.func_70107_b(this.func_213303_ch().func_82615_a(), this.func_213303_ch().func_82617_b(), this.func_213303_ch().func_82616_c());
        hellfireBarrier.rotation = angle;
        this.hellfireBarriers.add(hellfireBarrier);
    }

    public void hellfireBarrierUpdate() {
        if (this.hellfireBarrierHealth <= 0) {
            this.hellfireBarrierHealth = 100;
            if (this.hellfireBarriers.size() > 0) {
                EntityHellfireBarrier hellfireBarrier = this.hellfireBarriers.get(this.hellfireBarriers.size() - 1);
                hellfireBarrier.func_70106_y();
                this.hellfireBarriers.remove(this.hellfireBarriers.size() - 1);
            }
        }
        for (EntityHellfireBarrier hellfireBarrier : this.hellfireBarriers) {
            hellfireBarrier.time = 0;
            hellfireBarrier.func_70107_b(this.func_213303_ch().func_82615_a(), this.func_213303_ch().func_82617_b(), this.func_213303_ch().func_82616_c());
        }
    }

    public void hellfireBarrierCleanup() {
        if (this.func_130014_f_().field_72995_K || this.hellfireBarriers.size() < 1) {
            return;
        }
        for (EntityHellfireBarrier hellfireBarrier : this.hellfireBarriers) {
            hellfireBarrier.func_70106_y();
        }
        this.hellfireBarriers = new ArrayList<EntityHellfireBarrier>();
        this.hellfireBarrierHealth = 100;
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    @Override
    public boolean func_70687_e(EffectInstance potionEffect) {
        if (potionEffect.func_188419_a() == Effects.field_82731_v) {
            return false;
        }
        if (ObjectManager.getEffect("decay") != null && potionEffect.func_188419_a() == ObjectManager.getEffect("decay")) {
            return false;
        }
        super.func_70687_e(potionEffect);
        return true;
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public boolean isInvulnerableTo(Entity entity) {
        if (entity instanceof ZombiePigmanEntity) {
            entity.func_70106_y();
            return false;
        }
        if (entity instanceof IronGolemEntity) {
            entity.func_70106_y();
            return false;
        }
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            if (!player.field_71075_bZ.field_75102_a && player.func_213303_ch().func_82617_b() > this.func_213303_ch().func_82617_b() + CreatureManager.getInstance().config.bossAntiFlight) {
                return false;
            }
        }
        return super.isInvulnerableTo(entity);
    }

    @Override
    public boolean func_70097_a(DamageSource damageSrc, float damageAmount) {
        if (this.playerTargets != null && damageSrc.func_76346_g() != null && damageSrc.func_76346_g() instanceof PlayerEntity && !this.playerTargets.contains(damageSrc.func_76346_g())) {
            this.playerTargets.add((PlayerEntity)damageSrc.func_76346_g());
        }
        return super.func_70097_a(damageSrc, damageAmount);
    }

    @Override
    public void func_70037_a(CompoundNBT nbtTagCompound) {
        Entity entity;
        int i;
        super.func_70037_a(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("HellfireEnergy")) {
            this.hellfireEnergy = nbtTagCompound.func_74762_e("HellfireEnergy");
        }
        if (nbtTagCompound.func_74764_b("HellfireWallTime")) {
            this.hellfireWallTime = nbtTagCompound.func_74762_e("HellfireWallTime");
        }
        if (nbtTagCompound.func_74764_b("BelphIDs")) {
            ListNBT belphIDs = nbtTagCompound.func_150295_c("BelphIDs", 10);
            for (i = 0; i < belphIDs.size(); ++i) {
                CompoundNBT belphID = belphIDs.func_150305_b(i);
                if (!belphID.func_74764_b("ID") || (entity = this.func_130014_f_().func_73045_a(belphID.func_74762_e("ID"))) == null || !(entity instanceof EntityBelph)) continue;
                this.hellfireBelphMinions.add((EntityBelph)entity);
            }
        }
        if (nbtTagCompound.func_74764_b("BehemothIDs")) {
            ListNBT behemothIDs = nbtTagCompound.func_150295_c("BehemothIDs", 10);
            for (i = 0; i < behemothIDs.size(); ++i) {
                CompoundNBT behemothID = behemothIDs.func_150305_b(i);
                if (!behemothID.func_74764_b("ID") || (entity = this.func_130014_f_().func_73045_a(behemothID.func_74762_e("ID"))) == null || !(entity instanceof EntityBehemoth)) continue;
                this.hellfireBehemothMinions.add((EntityBehemoth)entity);
            }
        }
    }

    @Override
    public void func_213281_b(CompoundNBT nbtTagCompound) {
        super.func_213281_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("HellfireEnergy", this.hellfireEnergy);
        nbtTagCompound.func_74768_a("HellfireWallTime", this.hellfireWallTime);
        if (this.getBattlePhase() == 0) {
            ListNBT belphIDs = new ListNBT();
            for (EntityBelph entityBelph : this.hellfireBelphMinions) {
                CompoundNBT belphID = new CompoundNBT();
                belphID.func_74768_a("ID", entityBelph.func_145782_y());
                belphIDs.add((Object)belphID);
            }
            nbtTagCompound.func_218657_a("BelphIDs", (INBT)belphIDs);
        }
        if (this.getBattlePhase() == 1) {
            ListNBT behemothIDs = new ListNBT();
            for (EntityBehemoth entityBehemoth : this.hellfireBehemothMinions) {
                CompoundNBT behemothID = new CompoundNBT();
                behemothID.func_74768_a("ID", entityBehemoth.func_145782_y());
                behemothIDs.add((Object)behemothID);
            }
            nbtTagCompound.func_218657_a("BehemothIDs", (INBT)behemothIDs);
        }
    }

    @Override
    protected void func_180429_a(BlockPos pos, BlockState block) {
        if (this.hasArenaCenter()) {
            return;
        }
        super.func_180429_a(pos, block);
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBrightnessForRender() {
        return 0xF000F0;
    }
}

