/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.RideableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.Event;

public class EntityMaug
extends RideableCreatureEntity {
    protected boolean leapedAbilityQueued = false;
    protected boolean leapedAbilityReady = false;

    public EntityMaug(EntityType<? extends EntityMaug> entityType, World world) {
        super((EntityType<? extends RideableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223222_a_;
        this.hasAttackSound = true;
        this.spreadFire = false;
        this.canGrow = true;
        this.babySpawnChance = 0.1;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)new AttackMeleeGoal(this).setTargetClass(PlayerEntity.class).setLongMemory(false));
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)new AttackMeleeGoal(this));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.isTamed() && this.field_70122_E && !this.func_130014_f_().field_72995_K && this.hasAttackTarget() && this.field_70146_Z.nextInt(10) == 0) {
            this.leap(4.0f, 0.5, (Entity)this.func_70638_az());
        }
        if (this.leapedAbilityQueued && !this.field_70122_E && !this.func_130014_f_().field_72995_K) {
            this.leapedAbilityQueued = false;
            this.leapedAbilityReady = true;
        }
        if (this.leapedAbilityReady && this.field_70122_E && !this.func_130014_f_().field_72995_K) {
            this.leapedAbilityReady = false;
            double distance = 4.0;
            List possibleTargets = this.func_130014_f_().func_175647_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(distance, distance, distance), (Predicate)new com.google.common.base.Predicate<LivingEntity>(){

                public boolean apply(LivingEntity possibleTarget) {
                    return possibleTarget.func_70089_S() && possibleTarget != EntityMaug.this && !EntityMaug.this.func_184215_y((Entity)possibleTarget) && !EntityMaug.this.func_184191_r((Entity)possibleTarget) && EntityMaug.this.func_213358_a(possibleTarget.func_200600_R()) && EntityMaug.this.func_213336_c(possibleTarget);
                }
            });
            if (!possibleTargets.isEmpty()) {
                for (LivingEntity possibleTarget : possibleTargets) {
                    boolean doDamage = true;
                    if (this.getRider() instanceof PlayerEntity && MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent((PlayerEntity)this.getRider(), (Entity)possibleTarget))) {
                        doDamage = false;
                    }
                    if (!doDamage) continue;
                    possibleTarget.func_195064_c(new EffectInstance(Effects.field_76421_d, 200, 0));
                }
            }
            this.playAttackSound();
        }
    }

    @Override
    public void riderEffects(LivingEntity rider) {
        if (rider.func_70644_a(Effects.field_76421_d)) {
            rider.func_195063_d(Effects.field_76421_d);
        }
        if (rider.func_70644_a(Effects.field_76438_s)) {
            rider.func_195063_d(Effects.field_76438_s);
        }
    }

    @Override
    public float getAISpeedModifier() {
        if (!this.field_70122_E) {
            return 2.0f;
        }
        return 1.0f;
    }

    @Override
    public double func_70042_X() {
        return (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b * 0.95;
    }

    @Override
    public void leap(double distance, double leapHeight) {
        super.leap(distance, leapHeight);
        if (!this.func_130014_f_().field_72995_K) {
            this.leapedAbilityQueued = true;
        }
    }

    @Override
    public void leap(float range, double leapHeight, Entity target) {
        super.leap(range, leapHeight, target);
        if (!this.func_130014_f_().field_72995_K) {
            this.leapedAbilityQueued = true;
        }
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (!this.field_70122_E) {
            return;
        }
        if (this.abilityToggled) {
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        this.playJumpSound();
        this.leap(2.0, 1.5);
        this.applyStaminaCost();
    }

    @Override
    public float getStaminaCost() {
        return 15.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 100;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 1.0f;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 10;
    }

    @Override
    public boolean canClimb() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public boolean isInvulnerableTo(String type, DamageSource source, float damage) {
        if (type.equals("ooze")) {
            return false;
        }
        return super.isInvulnerableTo(type, source, damage);
    }

    @Override
    public float getFallResistance() {
        return 20.0f;
    }
}

