/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.GetBlockGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.GetItemGoal;
import com.lycanitesmobs.core.info.ObjectLists;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;

public class EntityKobold
extends TameableCreatureEntity
implements IMob {
    public boolean griefing = true;
    public boolean theivery = true;
    private int torchLootingTime = 20;

    public EntityKobold(EntityType<? extends EntityKobold> entityType, World world) {
        super((EntityType<? extends TameableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223222_a_;
        this.hasAttackSound = true;
        this.spreadFire = false;
        this.canGrow = false;
        this.babySpawnChance = 0.1;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex++, (Goal)new GetItemGoal(this).setDistanceMax(8.0).setSpeed(1.2));
        if (this.griefing) {
            this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex++, (Goal)new GetBlockGoal(this).setDistanceMax(8).setSpeed(1.2).setBlockName("torch").setTamedLooting(false));
        }
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)new AttackMeleeGoal(this).setTargetClass(PlayerEntity.class).setLongMemory(false));
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)new AttackMeleeGoal(this));
    }

    @Override
    public void loadCreatureFlags() {
        this.griefing = this.creatureInfo.getFlag("griefing", this.griefing);
        this.theivery = this.creatureInfo.getFlag("theivery", this.theivery);
    }

    @Override
    protected boolean canDespawnNaturally() {
        return super.canDespawnNaturally();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.isTamed() && this.func_130014_f_().func_82736_K().func_223586_b(GameRules.field_223599_b) && this.griefing && this.torchLootingTime-- <= 0) {
            this.torchLootingTime = 60;
            int distance = 2;
            String targetName = "torch";
            ArrayList possibleTargets = new ArrayList();
            for (int x = (int)this.func_213303_ch().func_82615_a() - distance; x < (int)this.func_213303_ch().func_82615_a() + distance; ++x) {
                block1: for (int y = (int)this.func_213303_ch().func_82617_b() - distance; y < (int)this.func_213303_ch().func_82617_b() + distance; ++y) {
                    for (int z = (int)this.func_213303_ch().func_82616_c() - distance; z < (int)this.func_213303_ch().func_82616_c() + distance; ++z) {
                        BlockPos pos = new BlockPos(x, y, z);
                        Block searchBlock = this.func_130014_f_().func_180495_p(pos).func_177230_c();
                        if (searchBlock == null || searchBlock == Blocks.field_150350_a) continue;
                        Object possibleTarget = null;
                        if (!ObjectLists.isName(searchBlock, targetName)) continue;
                        this.func_130014_f_().func_175655_b(pos, true);
                        continue block1;
                    }
                }
            }
        }
    }

    @Override
    public boolean shouldCreatureGroupRevenge(LivingEntity target) {
        if (target instanceof PlayerEntity && target.func_110143_aJ() / target.func_110138_aP() <= 0.5f) {
            return true;
        }
        return super.shouldCreatureGroupRevenge(target);
    }

    @Override
    public boolean shouldCreatureGroupHunt(LivingEntity target) {
        if (target instanceof PlayerEntity && target.func_110143_aJ() / target.func_110138_aP() <= 0.5f) {
            return true;
        }
        return super.shouldCreatureGroupHunt(target);
    }

    @Override
    public boolean shouldCreatureGroupFlee(LivingEntity target) {
        if (target instanceof PlayerEntity && target.func_110143_aJ() / target.func_110138_aP() <= 0.5f) {
            return false;
        }
        return super.shouldCreatureGroupFlee(target);
    }

    @Override
    public boolean func_213336_c(LivingEntity targetEntity) {
        if (targetEntity.func_110143_aJ() / targetEntity.func_110138_aP() > 0.5f) {
            return false;
        }
        return super.func_213336_c(targetEntity);
    }

    @Override
    public int getNoBagSize() {
        return 10;
    }

    @Override
    public int getBagSize() {
        return 10;
    }

    @Override
    public boolean canPickupItems() {
        return this.theivery;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }
}

