/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.api.IGroupHeavy;
import com.lycanitesmobs.core.entity.CustomItemEntity;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.IProperty;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityKhalk
extends TameableCreatureEntity
implements IMob,
IGroupHeavy {
    public boolean lavaDeath = true;

    public EntityKhalk(EntityType<? extends EntityKhalk> entityType, World world) {
        super((EntityType<? extends TameableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223222_a_;
        this.spawnsOnLand = true;
        this.spawnsInWater = true;
        this.isLavaCreature = true;
        this.hasAttackSound = true;
        this.canGrow = true;
        this.babySpawnChance = 0.01;
        this.solidCollision = true;
        this.setupMob();
        this.func_184644_a(PathNodeType.LAVA, 0.0f);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)new AttackMeleeGoal(this));
    }

    @Override
    public void loadCreatureFlags() {
        this.lavaDeath = this.creatureInfo.getFlag("lavaDeath", this.lavaDeath);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70122_E && !this.func_130014_f_().field_72995_K && this.hasAttackTarget() && this.field_70146_Z.nextInt(10) == 0) {
            this.leap(6.0f, 0.1, (Entity)this.func_70638_az());
        }
    }

    @Override
    public float getAISpeedModifier() {
        if (this.lavaContact()) {
            return 2.0f;
        }
        return 1.0f;
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        int waterWeight = 10;
        BlockPos pos = new BlockPos(x, y, z);
        if (this.func_130014_f_().func_180495_p(pos).func_177230_c() == Blocks.field_150353_l) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.func_70638_az() != null) {
            return super.getBlockPathWeight(x, y, z);
        }
        if (this.lavaContact()) {
            return -999999.0f;
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        if (!this.func_130014_f_().field_72995_K && this.func_130014_f_().func_82736_K().func_223586_b(GameRules.field_223599_b) && this.lavaDeath && !this.isTamed()) {
            int lavaWidth = (int)Math.floor(this.func_213305_a((Pose)Pose.STANDING).field_220315_a) - 1;
            int lavaHeight = (int)Math.floor(this.func_213305_a((Pose)Pose.STANDING).field_220316_b) - 1;
            for (int x = (int)this.func_213303_ch().func_82615_a() - lavaWidth; x <= (int)this.func_213303_ch().func_82615_a() + lavaWidth; ++x) {
                for (int y = (int)this.func_213303_ch().func_82617_b(); y <= (int)this.func_213303_ch().func_82617_b() + lavaHeight; ++y) {
                    for (int z = (int)this.func_213303_ch().func_82616_c() - lavaWidth; z <= (int)this.func_213303_ch().func_82616_c() + lavaWidth; ++z) {
                        Block block = this.func_130014_f_().func_180495_p(new BlockPos(x, y, z)).func_177230_c();
                        if (block != Blocks.field_150350_a) continue;
                        BlockState blockState = (BlockState)Blocks.field_150353_l.func_176223_P().func_206870_a((IProperty)FlowingFluidBlock.field_176367_b, (Comparable)Integer.valueOf(4));
                        if (x == (int)this.func_213303_ch().func_82615_a() && y == (int)this.func_213303_ch().func_82617_b() && z == (int)this.func_213303_ch().func_82616_c()) {
                            blockState = (BlockState)Blocks.field_150353_l.func_176223_P().func_206870_a((IProperty)FlowingFluidBlock.field_176367_b, (Comparable)Integer.valueOf(5));
                        }
                        this.func_130014_f_().func_180501_a(new BlockPos(x, y, z), blockState, 3);
                    }
                }
            }
        }
        super.func_70645_a(damageSource);
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public boolean waterDamage() {
        return true;
    }

    @Override
    public boolean canBreatheUnderlava() {
        return true;
    }

    @Override
    public boolean canBreatheAir() {
        return true;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76347_k()) {
            return 0.0f;
        }
        return super.getDamageModifier(damageSrc);
    }

    @Override
    public void applyDropEffects(CustomItemEntity entityitem) {
        entityitem.setCanBurn(false);
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBrightnessForRender() {
        return 0xF000F0;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }
}

