/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.AgeableCreatureEntity;
import com.lycanitesmobs.core.entity.creature.EntityJoustAlpha;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.TemptGoal;
import com.lycanitesmobs.core.entity.goals.targeting.CopyMasterAttackTargetGoal;
import com.lycanitesmobs.core.entity.goals.targeting.FindMasterGoal;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityJoust
extends AgeableCreatureEntity {
    public EntityJoust(EntityType<? extends EntityJoust> entityType, World world) {
        super((EntityType<? extends AgeableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223222_a_;
        this.hasAttackSound = true;
        this.babySpawnChance = 0.1;
        this.canGrow = true;
        this.attackCooldownMax = 10;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextDistractionGoalIndex++, (Goal)new TemptGoal(this).setIncludeDiet(true));
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)new AttackMeleeGoal(this).setLongMemory(false));
        this.field_70715_bh.func_75776_a(this.nextFindTargetIndex++, (Goal)new FindMasterGoal(this).setTargetClass(EntityJoustAlpha.class).setSightCheck(false));
        this.field_70715_bh.func_75776_a(this.nextFindTargetIndex++, (Goal)new CopyMasterAttackTargetGoal(this));
    }

    @Override
    public void onFirstSpawn() {
        CreatureInfo alphaInfo = CreatureManager.getInstance().getCreature("joustalpha");
        if (alphaInfo != null) {
            float alphaChance = (float)alphaInfo.creatureSpawn.spawnWeight / (float)Math.max(this.creatureInfo.creatureSpawn.spawnWeight, 1);
            if (this.func_70681_au().nextFloat() <= alphaChance) {
                EntityJoustAlpha alpha = (EntityJoustAlpha)CreatureManager.getInstance().getCreature("joustalpha").createEntity(this.func_130014_f_());
                alpha.func_82149_j((Entity)this);
                this.func_130014_f_().func_217376_c((Entity)alpha);
                this.func_70106_y();
            }
        }
        super.onFirstSpawn();
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        BlockState blockState = this.func_130014_f_().func_180495_p(new BlockPos(x, y - 1, z));
        if (blockState.func_177230_c() != Blocks.field_150350_a) {
            if (blockState.func_185904_a() == Material.field_151595_p) {
                return 10.0f;
            }
            if (blockState.func_185904_a() == Material.field_151571_B) {
                return 7.0f;
            }
            if (blockState.func_185904_a() == Material.field_151576_e) {
                return 5.0f;
            }
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean func_184652_a(PlayerEntity player) {
        if (!this.hasAttackTarget() && !this.hasMaster()) {
            return true;
        }
        return super.func_184652_a(player);
    }

    @Override
    public boolean func_213336_c(LivingEntity target) {
        if (target instanceof EntityJoustAlpha) {
            return false;
        }
        return super.func_213336_c(target);
    }

    @Override
    public boolean isProtective(Entity entity) {
        if (entity instanceof EntityJoust) {
            return true;
        }
        return super.isProtective(entity);
    }

    @Override
    public boolean isInvulnerableTo(String type, DamageSource source, float damage) {
        if (type.equals("cactus")) {
            return false;
        }
        return super.isInvulnerableTo(type, source, damage);
    }

    @Override
    public void setGrowingAge(int age) {
        if (age == 0 && this.getAge() < 0 && this.func_70681_au().nextFloat() >= 0.9f) {
            EntityJoustAlpha alpha = (EntityJoustAlpha)CreatureManager.getInstance().getCreature("joustalpha").createEntity(this.func_130014_f_());
            alpha.func_82149_j((Entity)this);
            this.func_130014_f_().func_217376_c((Entity)alpha);
            this.func_70106_y();
        }
        super.setGrowingAge(age);
    }
}

