/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.api.IGroupHeavy;
import com.lycanitesmobs.core.entity.RapidFireProjectileEntity;
import com.lycanitesmobs.core.entity.RideableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.entity.projectile.EntityScorchfireball;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import java.util.ArrayList;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityIgnibus
extends RideableCreatureEntity
implements IGroupHeavy {
    protected boolean wantsToLand;
    protected boolean isLanded;

    public EntityIgnibus(EntityType<? extends EntityIgnibus> entityType, World world) {
        super((EntityType<? extends RideableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223222_a_;
        this.spawnsOnLand = true;
        this.spawnsInWater = true;
        this.isLavaCreature = true;
        this.flySoundSpeed = 20;
        this.hasAttackSound = false;
        this.setAttackCooldownMax(20);
        this.setupMob();
        this.field_70138_W = 1.0f;
        this.hitAreaWidthScale = 1.5f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)new AttackRangedGoal(this).setSpeed(0.75).setStaminaTime(100).setRange(20.0f).setMinChaseDistance(10.0f));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.isLanded) {
                this.wantsToLand = false;
                if (this.hasPickupEntity() || this.func_184179_bs() != null || this.func_110167_bD() || this.func_70090_H() || !this.isTamed() && this.updateTick % 100L == 0L && this.func_70681_au().nextBoolean()) {
                    this.leap(1.0, 1.0);
                    this.isLanded = false;
                }
            } else if (this.wantsToLand) {
                if (!this.isLanded && this.isSafeToLand()) {
                    this.isLanded = true;
                }
            } else if (!this.hasPickupEntity() && !this.hasAttackTarget() && this.updateTick % 100L == 0L && this.func_70681_au().nextBoolean()) {
                this.wantsToLand = true;
            }
            if (this.hasPickupEntity() || this.func_184179_bs() != null || this.hasAttackTarget() || this.func_70090_H()) {
                this.wantsToLand = false;
            } else if (this.isTamed() && !this.func_110167_bD()) {
                this.wantsToLand = true;
            }
        }
        if (this.func_130014_f_().field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_213303_ch().func_82615_a() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, this.func_213303_ch().func_82617_b() + this.field_70146_Z.nextDouble() * (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b, this.func_213303_ch().func_82616_c() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, 0.0, 0.0, 0.0);
                this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_213303_ch().func_82615_a() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, this.func_213303_ch().func_82617_b() + this.field_70146_Z.nextDouble() * (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b, this.func_213303_ch().func_82616_c() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void riderEffects(LivingEntity rider) {
        rider.func_195064_c(new EffectInstance(Effects.field_76426_n, 105, 1));
        super.riderEffects(rider);
    }

    @Override
    public BlockPos getWanderPosition(BlockPos wanderPosition) {
        if (this.wantsToLand || !this.isLanded) {
            BlockPos groundPos = wanderPosition.func_177977_b();
            while (groundPos.func_177956_o() > 0 && this.func_130014_f_().func_180495_p(groundPos).func_177230_c() == Blocks.field_150350_a) {
                groundPos = groundPos.func_177977_b();
            }
            if (this.func_130014_f_().func_180495_p(groundPos).func_185904_a().func_76220_a()) {
                return groundPos.func_177984_a();
            }
        }
        return super.getWanderPosition(wanderPosition);
    }

    @Override
    public double getFlightOffset() {
        if (!this.wantsToLand) {
            super.getFlightOffset();
        }
        return 0.0;
    }

    @Override
    public boolean isFlying() {
        return !this.isLanded;
    }

    @Override
    public boolean isStrongSwimmer() {
        return false;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 5;
    }

    @Override
    public void attackRanged(Entity target, float range) {
        ArrayList<RapidFireProjectileEntity> projectiles = new ArrayList<RapidFireProjectileEntity>();
        RapidFireProjectileEntity projectileEntry = new RapidFireProjectileEntity(ProjectileManager.getInstance().oldProjectileTypes.get(RapidFireProjectileEntity.class), EntityScorchfireball.class, this.func_130014_f_(), (LivingEntity)this, 15, 3);
        projectiles.add(projectileEntry);
        RapidFireProjectileEntity projectileEntry2 = new RapidFireProjectileEntity(ProjectileManager.getInstance().oldProjectileTypes.get(RapidFireProjectileEntity.class), EntityScorchfireball.class, this.func_130014_f_(), (LivingEntity)this, 15, 3);
        projectileEntry2.offsetX += 1.0;
        projectileEntry2.setProjectileScale(0.25f);
        projectiles.add(projectileEntry2);
        RapidFireProjectileEntity projectileEntry3 = new RapidFireProjectileEntity(ProjectileManager.getInstance().oldProjectileTypes.get(RapidFireProjectileEntity.class), EntityScorchfireball.class, this.func_130014_f_(), (LivingEntity)this, 15, 3);
        projectileEntry3.offsetX -= 1.0;
        projectileEntry3.setProjectileScale(0.25f);
        projectiles.add(projectileEntry3);
        RapidFireProjectileEntity projectileEntry4 = new RapidFireProjectileEntity(ProjectileManager.getInstance().oldProjectileTypes.get(RapidFireProjectileEntity.class), EntityScorchfireball.class, this.func_130014_f_(), (LivingEntity)this, 15, 3);
        projectileEntry4.offsetZ += 1.0;
        projectileEntry4.setProjectileScale(0.25f);
        projectiles.add(projectileEntry4);
        RapidFireProjectileEntity projectileEntry5 = new RapidFireProjectileEntity(ProjectileManager.getInstance().oldProjectileTypes.get(RapidFireProjectileEntity.class), EntityScorchfireball.class, this.func_130014_f_(), (LivingEntity)this, 15, 3);
        projectileEntry5.offsetZ -= 1.0;
        projectileEntry5.setProjectileScale(0.25f);
        projectiles.add(projectileEntry5);
        RapidFireProjectileEntity projectileEntry6 = new RapidFireProjectileEntity(ProjectileManager.getInstance().oldProjectileTypes.get(RapidFireProjectileEntity.class), EntityScorchfireball.class, this.func_130014_f_(), (LivingEntity)this, 15, 3);
        projectileEntry6.offsetY += 1.0;
        projectileEntry6.setProjectileScale(0.25f);
        projectiles.add(projectileEntry6);
        RapidFireProjectileEntity projectileEntry7 = new RapidFireProjectileEntity(ProjectileManager.getInstance().oldProjectileTypes.get(RapidFireProjectileEntity.class), EntityScorchfireball.class, this.func_130014_f_(), (LivingEntity)this, 15, 3);
        projectileEntry7.offsetY -= 1.0;
        projectileEntry7.setProjectileScale(0.25f);
        projectiles.add(projectileEntry7);
        for (RapidFireProjectileEntity projectile : projectiles) {
            projectile.setProjectileScale(1.0f);
            projectile.func_70107_b(projectile.func_213303_ch().func_82615_a(), projectile.func_213303_ch().func_82617_b() - (double)(this.func_213305_a((Pose)Pose.STANDING).field_220316_b / 4.0f), projectile.func_213303_ch().func_82616_c());
            float accuracy = 4.0f * (this.func_70681_au().nextFloat() - 0.5f);
            double d0 = target.func_213303_ch().func_82615_a() - this.func_213303_ch().func_82615_a() + (double)accuracy;
            double d1 = target.func_213303_ch().func_82617_b() + (double)target.func_70047_e() - (double)1.1f - projectile.func_213303_ch().func_82617_b() + (double)accuracy;
            double d2 = target.func_213303_ch().func_82616_c() - this.func_213303_ch().func_82616_c() + (double)accuracy;
            float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
            float velocity = 1.2f;
            projectile.func_70186_c(d0, d1 + (double)f1, d2, velocity, 6.0f);
            projectile.setProjectileScale(4.0f);
            this.func_184185_a(projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.func_130014_f_().func_217376_c((Entity)projectile);
        }
        super.attackRanged(target, range);
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public boolean canBreatheUnderlava() {
        return true;
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76347_k()) {
            return 0.0f;
        }
        return super.getDamageModifier(damageSrc);
    }

    @Override
    public double func_70042_X() {
        if (this.field_70122_E) {
            return (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b * 0.52;
        }
        return (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b * 0.54;
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.abilityToggled) {
            return;
        }
        if (this.hasPickupEntity()) {
            this.dropPickupEntity();
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        if (rider instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)rider;
            ArrayList<RapidFireProjectileEntity> projectiles = new ArrayList<RapidFireProjectileEntity>();
            RapidFireProjectileEntity projectileEntry = new RapidFireProjectileEntity(ProjectileManager.getInstance().oldProjectileTypes.get(RapidFireProjectileEntity.class), EntityScorchfireball.class, this.func_130014_f_(), (LivingEntity)player, 15, 3);
            projectiles.add(projectileEntry);
            RapidFireProjectileEntity projectileEntry2 = new RapidFireProjectileEntity(ProjectileManager.getInstance().oldProjectileTypes.get(RapidFireProjectileEntity.class), EntityScorchfireball.class, this.func_130014_f_(), (LivingEntity)this, 15, 3);
            projectileEntry2.offsetX += 1.0;
            projectileEntry2.setProjectileScale(0.25f);
            projectiles.add(projectileEntry2);
            RapidFireProjectileEntity projectileEntry3 = new RapidFireProjectileEntity(ProjectileManager.getInstance().oldProjectileTypes.get(RapidFireProjectileEntity.class), EntityScorchfireball.class, this.func_130014_f_(), (LivingEntity)this, 15, 3);
            projectileEntry3.offsetX -= 1.0;
            projectileEntry3.setProjectileScale(0.25f);
            projectiles.add(projectileEntry3);
            RapidFireProjectileEntity projectileEntry4 = new RapidFireProjectileEntity(ProjectileManager.getInstance().oldProjectileTypes.get(RapidFireProjectileEntity.class), EntityScorchfireball.class, this.func_130014_f_(), (LivingEntity)this, 15, 3);
            projectileEntry4.offsetZ += 1.0;
            projectileEntry4.setProjectileScale(0.25f);
            projectiles.add(projectileEntry4);
            RapidFireProjectileEntity projectileEntry5 = new RapidFireProjectileEntity(ProjectileManager.getInstance().oldProjectileTypes.get(RapidFireProjectileEntity.class), EntityScorchfireball.class, this.func_130014_f_(), (LivingEntity)this, 15, 3);
            projectileEntry5.offsetZ -= 1.0;
            projectileEntry5.setProjectileScale(0.25f);
            projectiles.add(projectileEntry5);
            RapidFireProjectileEntity projectileEntry6 = new RapidFireProjectileEntity(ProjectileManager.getInstance().oldProjectileTypes.get(RapidFireProjectileEntity.class), EntityScorchfireball.class, this.func_130014_f_(), (LivingEntity)this, 15, 3);
            projectileEntry6.offsetY += 1.0;
            projectileEntry6.setProjectileScale(0.25f);
            projectiles.add(projectileEntry6);
            RapidFireProjectileEntity projectileEntry7 = new RapidFireProjectileEntity(ProjectileManager.getInstance().oldProjectileTypes.get(RapidFireProjectileEntity.class), EntityScorchfireball.class, this.func_130014_f_(), (LivingEntity)this, 15, 3);
            projectileEntry7.offsetY -= 10.0;
            projectileEntry7.setProjectileScale(0.25f);
            projectiles.add(projectileEntry7);
            for (RapidFireProjectileEntity projectile : projectiles) {
                projectile.setProjectileScale(1.0f);
                projectile.func_70107_b(projectile.func_213303_ch().func_82615_a(), projectile.func_213303_ch().func_82617_b() - (double)(this.func_213305_a((Pose)Pose.STANDING).field_220316_b / 4.0f), projectile.func_213303_ch().func_82616_c());
                this.func_184185_a(projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                this.func_130014_f_().func_217376_c((Entity)projectile);
            }
            this.triggerAttackCooldown();
        }
        this.applyStaminaCost();
    }

    @Override
    public float getStaminaCost() {
        return 2.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 40;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 1.0f;
    }

    public float func_70013_c() {
        if (this.isAttackOnCooldown()) {
            return 1.0f;
        }
        return super.func_70013_c();
    }
}

