/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.client.TextureManager;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.StealthGoal;
import com.lycanitesmobs.core.info.ObjectLists;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityGrue
extends TameableCreatureEntity
implements IMob {
    private int teleportTime = 60;

    public EntityGrue(EntityType<? extends EntityGrue> entityType, World world) {
        super((EntityType<? extends TameableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223222_a_;
        this.hasAttackSound = true;
        this.spawnsInWater = true;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextPriorityGoalIndex++, (Goal)new StealthGoal(this).setStealthTime(20).setStealthAttack(true).setStealthMove(true));
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)new AttackMeleeGoal(this).setLongMemory(true));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K && this.hasAttackTarget() && this.teleportTime-- <= 0) {
            this.teleportTime = 60 + this.func_70681_au().nextInt(40);
            BlockPos teleportPosition = this.getFacingPosition((Entity)this.func_70638_az(), (double)(-this.func_70638_az().func_213305_a((Pose)Pose.STANDING).field_220315_a) - 1.0, 0.0);
            if (this.canTeleportTo(teleportPosition)) {
                this.playJumpSound();
                this.func_70107_b(teleportPosition.func_177958_n(), teleportPosition.func_177956_o(), teleportPosition.func_177952_p());
            }
        }
        if (this.func_130014_f_().field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197607_R, this.func_213303_ch().func_82615_a() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, this.func_213303_ch().func_82617_b() + this.field_70146_Z.nextDouble() * (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b, this.func_213303_ch().func_82616_c() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean canTeleportTo(BlockPos pos) {
        for (int y = 0; y <= 1; ++y) {
            BlockState blockState = this.func_130014_f_().func_180495_p(pos.func_177982_a(0, y, 0));
            if (!blockState.func_200132_m()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canStealth() {
        if (this.func_130014_f_().field_72995_K) {
            return false;
        }
        if (this.isMoving()) {
            return false;
        }
        return this.testLightLevel() <= 0;
    }

    @Override
    public void startStealth() {
        if (this.func_130014_f_().field_72995_K) {
            BasicParticleType particle = ParticleTypes.field_197607_R;
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            for (int i = 0; i < 100; ++i) {
                this.func_130014_f_().func_195594_a((IParticleData)particle, this.func_213303_ch().func_82615_a() + (double)(this.field_70146_Z.nextFloat() * this.func_213305_a((Pose)Pose.STANDING).field_220315_a * 2.0f) - (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, this.func_213303_ch().func_82617_b() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213305_a((Pose)Pose.STANDING).field_220316_b), this.func_213303_ch().func_82616_c() + (double)(this.field_70146_Z.nextFloat() * this.func_213305_a((Pose)Pose.STANDING).field_220315_a * 2.0f) - (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, d0, d1, d2);
            }
        }
        super.startStealth();
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        if (this.getSubspeciesIndex() > 2 && target instanceof LivingEntity) {
            LivingEntity targetLiving = (LivingEntity)target;
            ArrayList<Effect> goodEffects = new ArrayList<Effect>();
            for (EffectInstance effectInstance : targetLiving.func_70651_bq()) {
                if (!ObjectLists.inEffectList("buffs", effectInstance.func_188419_a())) continue;
                goodEffects.add(effectInstance.func_188419_a());
            }
            if (goodEffects.size() > 0) {
                if (goodEffects.size() > 1) {
                    targetLiving.func_195063_d((Effect)goodEffects.get(this.func_70681_au().nextInt(goodEffects.size())));
                } else {
                    targetLiving.func_195063_d((Effect)goodEffects.get(0));
                }
                float leeching = Math.max(1.0f, this.getAttackDamage(damageScale) / 2.0f);
                this.func_70691_i(leeching);
            }
        }
        return true;
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean isStrongSwimmer() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public boolean isInvulnerableTo(String type, DamageSource source, float damage) {
        if (type.equals("inWall")) {
            return false;
        }
        return super.isInvulnerableTo(type, source, damage);
    }

    @Override
    public boolean daylightBurns() {
        return false;
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public ResourceLocation getTexture(String suffix) {
        if (!this.func_145818_k_() || !"Shadow Clown".equals(this.func_200201_e().func_150254_d())) {
            return super.getTexture(suffix);
        }
        String textureName = this.getTextureName() + "_shadowclown";
        if (!"".equals(suffix)) {
            textureName = textureName + "_" + suffix;
        }
        if (TextureManager.getTexture(textureName) == null) {
            TextureManager.addTexture(textureName, this.creatureInfo.modInfo, "textures/entity/" + textureName.toLowerCase() + ".png");
        }
        return TextureManager.getTexture(textureName);
    }
}

