/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.api.IFusable;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.creature.EntityAegis;
import com.lycanitesmobs.core.entity.creature.EntityArgus;
import com.lycanitesmobs.core.entity.creature.EntityCinder;
import com.lycanitesmobs.core.entity.creature.EntityDjinn;
import com.lycanitesmobs.core.entity.creature.EntityJengu;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.targeting.FindAttackTargetGoal;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ObjectLists;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.SilverfishEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;

public class EntityGeonach
extends TameableCreatureEntity
implements IMob,
IFusable {
    public int blockBreakRadius = 0;
    public float fireDamageAbsorbed = 0.0f;
    protected IFusable fusionTarget;

    public EntityGeonach(EntityType<? extends EntityGeonach> entityType, World world) {
        super((EntityType<? extends TameableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223222_a_;
        this.hasAttackSound = true;
        this.setupMob();
        this.field_70138_W = 1.0f;
        this.attackPhaseMax = (byte)3;
        this.setAttackCooldownMax(10);
    }

    @Override
    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(this.nextFindTargetIndex++, (Goal)new FindAttackTargetGoal(this).addTargets(EntityType.field_200740_af));
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)new AttackMeleeGoal(this).setLongMemory(true));
    }

    @Override
    public void loadCreatureFlags() {
        this.blockBreakRadius = this.creatureInfo.getFlag("blockBreakRadius", this.blockBreakRadius);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.getSubspeciesIndex() == 3 && !this.isPetType("familiar") && this.hasAttackTarget() && this.func_70032_d((Entity)this.func_70638_az()) > 1.0f && this.func_70681_au().nextInt(20) == 0) {
                if (this.func_213303_ch().func_82617_b() - 1.0 > this.func_70638_az().func_213303_ch().func_82617_b()) {
                    this.leap(6.0f, -1.0, (Entity)this.func_70638_az());
                } else if (this.func_213303_ch().func_82617_b() + 1.0 < this.func_70638_az().func_213303_ch().func_82617_b()) {
                    this.leap(6.0f, 1.0, (Entity)this.func_70638_az());
                } else {
                    this.leap(6.0f, 0.0, (Entity)this.func_70638_az());
                }
                if (this.func_130014_f_().func_82736_K().func_223586_b(GameRules.field_223599_b) && this.blockBreakRadius > -1 && !this.isTamed()) {
                    this.destroyArea((int)this.func_213303_ch().func_82615_a(), (int)this.func_213303_ch().func_82617_b(), (int)this.func_213303_ch().func_82616_c(), 10.0f, true, this.blockBreakRadius);
                }
            }
            if (!this.isTamed() && !this.isRareSubspecies()) {
                if (this.updateTick % 40L == 0L && this.func_180799_ab()) {
                    this.transform(CreatureManager.getInstance().getEntityType("volcan"), null, false);
                }
                if (this.fireDamageAbsorbed >= 10.0f) {
                    this.transform(CreatureManager.getInstance().getEntityType("volcan"), null, false);
                }
            }
        }
        if (this.func_130014_f_().field_72995_K && !CreatureManager.getInstance().config.disableBlockParticles) {
            for (int i = 0; i < 2; ++i) {
                this.func_130014_f_().func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_150348_b.func_176223_P()), this.func_213303_ch().func_82615_a() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, this.func_213303_ch().func_82617_b() + this.field_70146_Z.nextDouble() * (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b, this.func_213303_ch().func_82616_c() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public float getAISpeedModifier() {
        if (this.hasAttackTarget() && this.func_70638_az() instanceof SilverfishEntity) {
            return 4.0f;
        }
        return super.getAISpeedModifier();
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        if (target instanceof SilverfishEntity) {
            target.func_70106_y();
        }
        this.nextAttackPhase();
        return true;
    }

    @Override
    public int getMeleeCooldown() {
        if (this.getAttackPhase() == 2) {
            return super.getMeleeCooldown() * 3;
        }
        return super.getMeleeCooldown();
    }

    @Override
    public int getRangedCooldown() {
        if (this.getAttackPhase() == 2) {
            return super.getRangedCooldown() * 3;
        }
        return super.getRangedCooldown();
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76346_g() != null) {
            LivingEntity entityLiving;
            ItemStack heldItem = ItemStack.field_190927_a;
            if (damageSrc.func_76346_g() instanceof LivingEntity && !(entityLiving = (LivingEntity)damageSrc.func_76346_g()).func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
                heldItem = entityLiving.func_184586_b(Hand.MAIN_HAND);
            }
            if (ObjectLists.isPickaxe(heldItem)) {
                return 3.0f;
            }
        }
        return super.getDamageModifier(damageSrc);
    }

    @Override
    public boolean isInvulnerableTo(String type, DamageSource source, float damage) {
        if (type.equals("cactus") || type.equals("inWall")) {
            return false;
        }
        if (source.func_76347_k()) {
            this.fireDamageAbsorbed += damage;
            return false;
        }
        return super.isInvulnerableTo(type, source, damage);
    }

    @Override
    public boolean canBurn() {
        return true;
    }

    @Override
    public IFusable getFusionTarget() {
        return this.fusionTarget;
    }

    @Override
    public void setFusionTarget(IFusable fusionTarget) {
        this.fusionTarget = fusionTarget;
    }

    @Override
    public EntityType<? extends LivingEntity> getFusionType(IFusable fusable) {
        if (fusable instanceof EntityCinder) {
            return CreatureManager.getInstance().getEntityType("volcan");
        }
        if (fusable instanceof EntityJengu) {
            return CreatureManager.getInstance().getEntityType("spriggan");
        }
        if (fusable instanceof EntityDjinn) {
            return CreatureManager.getInstance().getEntityType("banshee");
        }
        if (fusable instanceof EntityAegis) {
            return CreatureManager.getInstance().getEntityType("vapula");
        }
        if (fusable instanceof EntityArgus) {
            return CreatureManager.getInstance().getEntityType("tremor");
        }
        return null;
    }
}

