/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.RideableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.entity.projectile.EntityMudshot;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityErepede
extends RideableCreatureEntity {
    public EntityErepede(EntityType<? extends EntityErepede> entityType, World world) {
        super((EntityType<? extends RideableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223222_a_;
        this.hasAttackSound = false;
        this.attackCooldownMax = 10;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)new AttackRangedGoal(this).setSpeed(0.75).setRange(14.0f).setMinChaseDistance(6.0f));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
    }

    @Override
    public float getAISpeedModifier() {
        BlockState blockState;
        if (this.hasRiderTarget() && ((blockState = this.func_130014_f_().func_180495_p(this.func_180425_c().func_177982_a(0, -1, 0))).func_185904_a() == Material.field_151595_p || blockState.func_185904_a() == Material.field_151579_a && this.func_130014_f_().func_180495_p(this.func_180425_c().func_177982_a(0, -2, 0)).func_185904_a() == Material.field_151595_p)) {
            return 1.8f;
        }
        return 1.0f;
    }

    @Override
    public double func_70042_X() {
        return (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b * 0.9;
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.abilityToggled) {
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        if (rider instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)rider;
            EntityMudshot projectile = new EntityMudshot(ProjectileManager.getInstance().oldProjectileTypes.get(EntityMudshot.class), this.func_130014_f_(), (LivingEntity)player);
            this.func_130014_f_().func_217376_c((Entity)projectile);
            this.func_184185_a(projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.triggerAttackCooldown();
        }
        this.applyStaminaCost();
    }

    @Override
    public float getStaminaCost() {
        return 5.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 0;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 1.0f;
    }

    @Override
    public void attackRanged(Entity target, float range) {
        this.fireProjectile(EntityMudshot.class, target, range, 0.0f, new Vec3d(0.0, 0.0, 0.0), 1.2f, 2.0f, 1.0f);
        super.attackRanged(target, range);
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 15;
    }

    @Override
    public boolean isInvulnerableTo(String type, DamageSource source, float damage) {
        if (type.equals("cactus")) {
            return false;
        }
        return super.isInvulnerableTo(type, source, damage);
    }

    @Override
    public float getFallResistance() {
        return 10.0f;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }
}

