/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.client.TextureManager;
import com.lycanitesmobs.core.entity.RideableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.entity.projectile.EntityBloodleech;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;

public class EntityEpion
extends RideableCreatureEntity
implements IMob {
    public boolean griefing = true;

    public EntityEpion(EntityType<? extends EntityEpion> entityType, World world) {
        super((EntityType<? extends RideableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223223_b_;
        this.hasAttackSound = false;
        this.flySoundSpeed = 20;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)new AttackRangedGoal(this).setSpeed(0.75).setRange(14.0f).setMinChaseDistance(6.0f));
    }

    @Override
    public void loadCreatureFlags() {
        this.griefing = this.creatureInfo.getFlag("griefing", this.griefing);
    }

    @Override
    public float getStafeSpeed() {
        return 1.0f;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!(this.func_130014_f_().field_72995_K || this.isTamed() || this.isMinion() || this.isRareSubspecies() || this.isFlying() || !this.field_70122_E && !this.func_70090_H() || !this.func_70089_S())) {
            int explosionRadius = 2;
            if (this.subspecies != null) {
                explosionRadius = 3;
            }
            explosionRadius = Math.max(2, Math.round((float)explosionRadius * (float)this.sizeScale));
            if (this.func_130014_f_().func_82736_K().func_223586_b(GameRules.field_223599_b) && this.griefing) {
                this.func_130014_f_().func_217385_a((Entity)this, this.func_213303_ch().func_82615_a(), this.func_213303_ch().func_82617_b(), this.func_213303_ch().func_82616_c(), (float)explosionRadius, Explosion.Mode.NONE);
            }
            this.func_70106_y();
        }
        if (this.func_130014_f_().field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197607_R, this.func_213303_ch().func_82615_a() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, this.func_213303_ch().func_82617_b() + this.field_70146_Z.nextDouble() * (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b, this.func_213303_ch().func_82616_c() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public boolean func_70685_l(Entity target) {
        if (this.isRareSubspecies()) {
            return true;
        }
        return super.func_70685_l(target);
    }

    @Override
    public void attackRanged(Entity target, float range) {
        this.fireProjectile(EntityBloodleech.class, target, range, 0.0f, new Vec3d(0.0, 0.0, 0.0), 1.2f, 2.0f, 1.0f);
        super.attackRanged(target, range);
    }

    @Override
    public boolean isFlying() {
        float brightness;
        if (this.func_130014_f_().field_72995_K) {
            return true;
        }
        return !this.daylightBurns() || !this.func_130014_f_().func_72935_r() || !this.func_130014_f_().func_82736_K().func_223586_b(GameRules.field_223599_b) || !this.griefing || !((brightness = this.func_70013_c()) > 0.5f) || !this.func_130014_f_().func_175710_j(this.func_180425_c());
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public boolean daylightBurns() {
        return !this.isMinion() && !this.hasMaster() && !this.isTamed() && !this.isRareSubspecies();
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        if (rider instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)rider;
            EntityBloodleech projectile = new EntityBloodleech(ProjectileManager.getInstance().oldProjectileTypes.get(EntityBloodleech.class), this.func_130014_f_(), (LivingEntity)player);
            this.func_130014_f_().func_217376_c((Entity)projectile);
            this.func_184185_a(projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.triggerAttackCooldown();
        }
        this.applyStaminaCost();
    }

    @Override
    public float getStaminaCost() {
        return 5.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 0;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 1.0f;
    }

    @Override
    public ResourceLocation getTexture() {
        if (!this.func_145818_k_() || !"Vampire Bat".equals(this.func_200201_e().func_150254_d())) {
            return super.getTexture();
        }
        String textureName = this.getTextureName() + "_vampirebat";
        if (TextureManager.getTexture(textureName) == null) {
            TextureManager.addTexture(textureName, this.creatureInfo.modInfo, "textures/entity/" + textureName.toLowerCase() + ".png");
        }
        return TextureManager.getTexture(textureName);
    }
}

