/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.StealthGoal;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.potion.Effect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityDarkling
extends TameableCreatureEntity
implements IMob {
    protected static final DataParameter<Integer> LATCH_TARGET = EntityDataManager.func_187226_a(EntityDarkling.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Float> LATCH_HEIGHT = EntityDataManager.func_187226_a(EntityDarkling.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> LATCH_ANGLE = EntityDataManager.func_187226_a(EntityDarkling.class, (IDataSerializer)DataSerializers.field_187193_c);
    LivingEntity latchEntity = null;
    int latchEntityID = 0;
    double latchHeight = 0.5;
    double latchAngle = 90.0;

    public EntityDarkling(EntityType<? extends EntityDarkling> entityType, World world) {
        super((EntityType<? extends TameableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223223_b_;
        this.hasAttackSound = true;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextPriorityGoalIndex++, (Goal)new StealthGoal(this).setStealthTime(20).setStealthAttack(true).setStealthMove(true));
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)new AttackMeleeGoal(this));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LATCH_TARGET, (Object)0);
        this.field_70180_af.func_187214_a(LATCH_HEIGHT, (Object)Float.valueOf((float)this.latchHeight));
        this.field_70180_af.func_187214_a(LATCH_ANGLE, (Object)Float.valueOf((float)this.latchAngle));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K && this.hasAttackTarget() && !this.hasLatchTarget() && this.field_70122_E && !this.func_130014_f_().field_72995_K && this.field_70146_Z.nextInt(10) == 0) {
            this.leap(6.0f, 0.6, (Entity)this.func_70638_az());
        }
        if (this.hasLatchTarget()) {
            this.field_70145_X = true;
            Vec3d latchPos = this.getFacingPositionDouble(this.getLatchTarget().func_213303_ch().func_82615_a(), this.getLatchTarget().func_213303_ch().func_82617_b() + (double)this.getLatchTarget().func_213305_a((Pose)Pose.STANDING).field_220316_b * this.latchHeight, this.getLatchTarget().func_213303_ch().func_82616_c(), (double)this.getLatchTarget().func_213305_a((Pose)Pose.STANDING).field_220315_a * 0.5, this.latchAngle);
            this.func_70107_b(latchPos.field_72450_a, latchPos.field_72448_b, latchPos.field_72449_c);
            double distanceX = this.getLatchTarget().func_213303_ch().func_82615_a() - this.func_213303_ch().func_82615_a();
            double distanceZ = this.getLatchTarget().func_213303_ch().func_82616_c() - this.func_213303_ch().func_82616_c();
            this.field_70761_aq = this.field_70177_z = -((float)MathHelper.func_181159_b((double)distanceX, (double)distanceZ)) * 57.295776f;
            if (!this.func_130014_f_().field_72995_K) {
                if (this.getLatchTarget().func_70089_S() && !this.func_70090_H()) {
                    if (this.updateTick % 40L == 0L) {
                        float damage = this.getAttackDamage(1.0);
                        if (this.attackMelee((Entity)this.getLatchTarget(), damage)) {
                            this.func_70691_i(damage * 2.0f);
                        }
                    }
                } else {
                    this.func_70107_b(this.getLatchTarget().func_213303_ch().func_82615_a(), this.getLatchTarget().func_213303_ch().func_82617_b(), this.getLatchTarget().func_213303_ch().func_82616_c());
                    this.setLatchTarget(null);
                    this.field_70145_X = false;
                }
            } else {
                for (int i = 0; i < 2; ++i) {
                    this.func_130014_f_().func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, this.func_213303_ch().func_82615_a() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, this.func_213303_ch().func_82617_b() + this.field_70146_Z.nextDouble() * (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b, this.func_213303_ch().func_82616_c() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, 0.0, 0.0, 0.0);
                }
            }
        } else {
            this.field_70145_X = false;
        }
    }

    public LivingEntity getLatchTarget() {
        try {
            if (this.func_130014_f_().field_72995_K) {
                this.latchHeight = ((Float)this.field_70180_af.func_187225_a(LATCH_HEIGHT)).floatValue();
                this.latchAngle = ((Float)this.field_70180_af.func_187225_a(LATCH_ANGLE)).floatValue();
                int latchEntityID = (Integer)this.func_184212_Q().func_187225_a(LATCH_TARGET);
                if (latchEntityID != this.latchEntityID) {
                    Entity possilbeLatchEntity;
                    this.latchEntity = null;
                    this.latchEntityID = latchEntityID;
                    if (latchEntityID != 0 && (possilbeLatchEntity = this.func_130014_f_().func_73045_a(latchEntityID)) != null && possilbeLatchEntity instanceof LivingEntity) {
                        this.latchEntity = (LivingEntity)possilbeLatchEntity;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.latchEntity;
    }

    public void setLatchTarget(LivingEntity entity) {
        this.latchEntity = entity;
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (entity == null) {
            this.func_184212_Q().func_187227_b(LATCH_TARGET, (Object)0);
            return;
        }
        if (ObjectManager.getEffect("repulsion") != null && entity.func_70644_a((Effect)ObjectManager.getEffect("repulsion"))) {
            this.func_184212_Q().func_187227_b(LATCH_TARGET, (Object)0);
            this.latchEntity = null;
            return;
        }
        this.func_184212_Q().func_187227_b(LATCH_TARGET, (Object)entity.func_145782_y());
        this.latchHeight = 0.25 + 0.75 * this.func_70681_au().nextDouble();
        this.latchAngle = 360.0 * this.func_70681_au().nextDouble();
        this.field_70180_af.func_187227_b(LATCH_HEIGHT, (Object)Float.valueOf((float)this.latchHeight));
        this.field_70180_af.func_187227_b(LATCH_ANGLE, (Object)Float.valueOf((float)this.latchAngle));
    }

    public boolean hasLatchTarget() {
        return this.getLatchTarget() != null;
    }

    @Override
    public boolean func_213358_a(EntityType targetType) {
        if (this.hasLatchTarget()) {
            return false;
        }
        return super.func_213358_a(targetType);
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        double targetKnockbackResistance = 0.0;
        if (target instanceof LivingEntity) {
            targetKnockbackResistance = ((LivingEntity)target).func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e();
            ((LivingEntity)target).func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        }
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        if (target instanceof LivingEntity) {
            ((LivingEntity)target).func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(targetKnockbackResistance);
        }
        if (!this.hasLatchTarget() && target instanceof LivingEntity && !this.func_70090_H()) {
            this.setLatchTarget((LivingEntity)target);
        }
        return true;
    }

    @Override
    public boolean canClimb() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public boolean canStealth() {
        if (this.func_130014_f_().field_72995_K) {
            return false;
        }
        if (this.isMoving()) {
            return false;
        }
        return this.testLightLevel() <= 0;
    }

    @Override
    public void startStealth() {
        if (this.func_130014_f_().field_72995_K) {
            BasicParticleType particle = ParticleTypes.field_197607_R;
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            for (int i = 0; i < 100; ++i) {
                this.func_130014_f_().func_195594_a((IParticleData)particle, this.func_213303_ch().func_82615_a() + (double)(this.field_70146_Z.nextFloat() * this.func_213305_a((Pose)Pose.STANDING).field_220315_a * 2.0f) - (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, this.func_213303_ch().func_82617_b() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213305_a((Pose)Pose.STANDING).field_220316_b), this.func_213303_ch().func_82616_c() + (double)(this.field_70146_Z.nextFloat() * this.func_213305_a((Pose)Pose.STANDING).field_220315_a * 2.0f) - (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, d0, d1, d2);
            }
        }
        super.startStealth();
    }

    @Override
    public boolean isInvulnerableTo(String type, DamageSource source, float damage) {
        if (type.equals("inWall")) {
            return false;
        }
        return super.isInvulnerableTo(type, source, damage);
    }

    @Override
    public float getFallResistance() {
        return 10.0f;
    }
}

