/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.AgeableCreatureEntity;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.creature.EntityConcapedeHead;
import com.lycanitesmobs.core.entity.goals.actions.FollowParentGoal;
import com.lycanitesmobs.core.info.CreatureManager;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityConcapedeSegment
extends AgeableCreatureEntity {
    UUID parentUUID = null;
    public BaseCreatureEntity backSegment;

    public EntityConcapedeSegment(EntityType<? extends EntityConcapedeSegment> entityType, World world) {
        super((EntityType<? extends AgeableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223224_c_;
        this.hasAttackSound = true;
        this.hasStepSound = false;
        this.canGrow = true;
        this.babySpawnChance = 0.0;
        this.isAggressiveByDefault = false;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(this.nextTravelGoalIndex++, (Goal)new FollowParentGoal(this).setSpeed(1.0).setStrayDistance(0.0));
        super.func_184651_r();
    }

    @Override
    public boolean environmentSpawnCheck(World world, BlockPos pos) {
        if (this.getNearbyEntities(EntityConcapedeHead.class, null, CreatureManager.getInstance().spawnConfig.spawnLimitRange).size() <= 0) {
            return false;
        }
        return super.environmentSpawnCheck(world, pos);
    }

    @Override
    public void getRandomSubspecies() {
        if (this.subspecies == null && !this.hasParent()) {
            this.subspecies = this.creatureInfo.getRandomSubspecies((LivingEntity)this);
        }
        if (this.hasParent() && this.getParentTarget() instanceof BaseCreatureEntity) {
            this.applySubspecies(((BaseCreatureEntity)this.getParentTarget()).getSubspeciesIndex());
        }
    }

    @Override
    protected boolean canDespawnNaturally() {
        if (!super.canDespawnNaturally()) {
            return false;
        }
        return !this.hasParent();
    }

    @Override
    public void func_70636_d() {
        if (!this.func_130014_f_().field_72995_K && !this.hasParent() && this.parentUUID != null && this.updateTick > 0L && this.updateTick % 40L == 0L) {
            double range = 64.0;
            List connections = this.func_130014_f_().func_217357_a(AgeableCreatureEntity.class, this.func_174813_aQ().func_72314_b(range, range, range));
            for (AgeableCreatureEntity possibleConnection : connections) {
                if (possibleConnection == this || !possibleConnection.func_110124_au().equals(this.parentUUID)) continue;
                this.setParentTarget((LivingEntity)possibleConnection);
                break;
            }
            this.parentUUID = null;
        }
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.backSegment != null && !this.backSegment.func_70089_S()) {
                this.backSegment = null;
            }
            if (this.hasParent() && !this.getParentTarget().func_70089_S()) {
                this.setParentTarget(null);
            }
            if (this.hasParent()) {
                this.func_70625_a((Entity)this.getParentTarget(), 360.0f, 360.0f);
                double segmentDistance = 0.65;
                Vec3d pos = this.getParentTarget() instanceof BaseCreatureEntity ? ((BaseCreatureEntity)this.getParentTarget()).getFacingPositionDouble(this.getParentTarget().func_213303_ch().func_82615_a(), this.getParentTarget().func_213303_ch().func_82617_b(), this.getParentTarget().func_213303_ch().func_82616_c(), -0.25, 0.0) : new Vec3d(this.getParentTarget().func_213303_ch().func_82615_a(), this.getParentTarget().func_213303_ch().func_82617_b(), this.getParentTarget().func_213303_ch().func_82616_c());
                double followX = this.func_213303_ch().func_82615_a();
                double followY = this.func_213303_ch().func_82617_b();
                double followZ = this.func_213303_ch().func_82616_c();
                if (this.func_213303_ch().func_82615_a() - pos.field_72450_a > segmentDistance) {
                    followX = pos.field_72450_a + segmentDistance;
                } else if (this.func_213303_ch().func_82615_a() - pos.field_72450_a < -segmentDistance) {
                    followX = pos.field_72450_a - segmentDistance;
                }
                if (this.func_213303_ch().func_82617_b() - pos.field_72448_b > segmentDistance) {
                    followY = pos.field_72448_b;
                } else if (this.func_213303_ch().func_82617_b() - pos.field_72448_b < -(segmentDistance / 2.0)) {
                    followY = pos.field_72448_b;
                }
                if (this.func_213303_ch().func_82616_c() - pos.field_72449_c > segmentDistance) {
                    followZ = pos.field_72449_c + segmentDistance;
                } else if (this.func_213303_ch().func_82616_c() - pos.field_72449_c < -segmentDistance) {
                    followZ = pos.field_72449_c - segmentDistance;
                }
                this.func_70107_b(followX, followY, followZ);
            }
            if (this.hasParent()) {
                this.func_70671_ap().func_75651_a((Entity)this.getParentTarget(), 30.0f, 30.0f);
            }
            if (!this.func_130014_f_().field_72995_K && this.getGrowingAge() <= 0) {
                this.setGrowingAge(-this.growthTime);
            }
        }
    }

    @Override
    public boolean rollWanderChance() {
        if (this.hasParent()) {
            return false;
        }
        return super.rollWanderChance();
    }

    @Override
    public void setGrowingAge(int age) {
        if (this.hasParent()) {
            age = -this.growthTime;
        }
        super.setGrowingAge(age);
        if (age == 0 && !this.func_130014_f_().field_72995_K) {
            EntityConcapedeHead concapedeHead = (EntityConcapedeHead)CreatureManager.getInstance().getCreature("concapede").createEntity(this.func_130014_f_());
            concapedeHead.func_82149_j((Entity)this);
            concapedeHead.firstSpawn = false;
            concapedeHead.setGrowingAge(-this.growthTime / 4);
            concapedeHead.setSizeScale(this.sizeScale);
            concapedeHead.applySubspecies(this.getSubspeciesIndex());
            this.func_130014_f_().func_217376_c((Entity)concapedeHead);
            if (this.backSegment != null) {
                this.backSegment.setParentTarget((LivingEntity)concapedeHead);
            }
            this.func_70106_y();
        }
    }

    @Override
    public boolean shouldFollowParent() {
        return true;
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        BlockState blockState = this.func_130014_f_().func_180495_p(new BlockPos(x, y - 1, z));
        Block block = blockState.func_177230_c();
        if (block != Blocks.field_150350_a) {
            if (blockState.func_185904_a() == Material.field_151577_b) {
                return 10.0f;
            }
            if (blockState.func_185904_a() == Material.field_151578_c) {
                return 7.0f;
            }
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean func_184652_a(PlayerEntity player) {
        return !this.hasParent();
    }

    @Override
    public double getFallingMod() {
        if (this.func_130014_f_().field_72995_K) {
            return 0.0;
        }
        if (this.hasParent() && this.getParentTarget().func_213303_ch().func_82617_b() > this.func_213303_ch().func_82617_b()) {
            return 0.0;
        }
        return super.getFallingMod();
    }

    @Override
    public boolean useDirectNavigator() {
        return this.hasParent();
    }

    @Override
    public void setParentTarget(LivingEntity setTarget) {
        if (setTarget != this) {
            if (setTarget instanceof EntityConcapedeSegment) {
                ((EntityConcapedeSegment)setTarget).backSegment = this;
            }
            if (setTarget instanceof EntityConcapedeHead) {
                ((EntityConcapedeHead)setTarget).backSegment = this;
            }
        }
        super.setParentTarget(setTarget);
    }

    @Override
    public boolean renderSubspeciesNameTag() {
        return !this.hasParent();
    }

    @Override
    public boolean canClimb() {
        return true;
    }

    @Override
    public boolean isInvulnerableTo(String type, DamageSource source, float damage) {
        if (type.equals("inWall")) {
            return false;
        }
        return super.isInvulnerableTo(type, source, damage);
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }

    @Override
    public AgeableCreatureEntity createChild(AgeableCreatureEntity partner) {
        return null;
    }

    @Override
    public boolean breed() {
        if (!this.canBreed()) {
            return false;
        }
        this.setGrowingAge(0);
        return true;
    }

    @Override
    public boolean canBreed() {
        return !this.hasParent();
    }

    @Override
    public boolean shouldFindParent() {
        return false;
    }

    @Override
    public void func_70037_a(CompoundNBT nbtTagCompound) {
        if (nbtTagCompound.func_74764_b("ParentUUIDMost")) {
            this.parentUUID = nbtTagCompound.func_186857_a("ParentUUID");
        }
        super.func_70037_a(nbtTagCompound);
    }

    @Override
    public void func_213281_b(CompoundNBT nbtTagCompound) {
        super.func_213281_b(nbtTagCompound);
        if (this.hasParent()) {
            nbtTagCompound.func_186854_a("ParentUUID", this.getParentTarget().func_110124_au());
        }
    }
}

