/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.AgeableCreatureEntity;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.creature.EntityConcapedeSegment;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.TemptGoal;
import com.lycanitesmobs.core.info.CreatureManager;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityConcapedeHead
extends AgeableCreatureEntity {
    public static int CONCAPEDE_SIZE_MAX = 10;
    public BaseCreatureEntity backSegment;
    public boolean isHungry = true;

    public EntityConcapedeHead(EntityType<? extends EntityConcapedeHead> entityType, World world) {
        super((EntityType<? extends AgeableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223224_c_;
        this.hasAttackSound = true;
        this.canGrow = true;
        this.babySpawnChance = 0.0;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextDistractionGoalIndex++, (Goal)new TemptGoal(this).setIncludeDiet(true));
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)new AttackMeleeGoal(this).setLongMemory(false));
    }

    @Override
    public void loadCreatureFlags() {
        CONCAPEDE_SIZE_MAX = this.creatureInfo.getFlag("sizeMax", CONCAPEDE_SIZE_MAX);
    }

    @Override
    public void onFirstSpawn() {
        if (!this.func_130014_f_().field_72995_K && this.backSegment == null) {
            this.setGrowingAge(-this.growthTime / 4);
            int segmentCount = this.func_70681_au().nextInt(CONCAPEDE_SIZE_MAX);
            AgeableCreatureEntity parentSegment = this;
            for (int segment = 0; segment < segmentCount; ++segment) {
                EntityConcapedeSegment segmentEntity = (EntityConcapedeSegment)CreatureManager.getInstance().getCreature("concapedesegment").createEntity(parentSegment.func_130014_f_());
                segmentEntity.func_70012_b(parentSegment.func_213303_ch().func_82615_a(), parentSegment.func_213303_ch().func_82617_b(), parentSegment.func_213303_ch().func_82616_c(), 0.0f, 0.0f);
                segmentEntity.setParentTarget((LivingEntity)parentSegment);
                segmentEntity.setSubspecies(this.getSubspeciesIndex());
                segmentEntity.setSizeScale(this.sizeScale);
                segmentEntity.spawnEventType = this.spawnEventType;
                segmentEntity.firstSpawn = false;
                parentSegment.func_130014_f_().func_217376_c((Entity)segmentEntity);
                parentSegment = segmentEntity;
            }
        }
        super.onFirstSpawn();
    }

    @Override
    public boolean shouldFollowParent() {
        return false;
    }

    @Override
    public void setGrowingAge(int age) {
        if (!(this.func_130014_f_().field_72995_K || this.firstSpawn || age != 0 || this.isHungry || CreatureManager.getInstance().getCreature("concapedesegment") == null)) {
            age = -(this.growthTime / 4);
            this.isHungry = true;
            int size = 0;
            BaseCreatureEntity lastSegment = this;
            while (size <= CONCAPEDE_SIZE_MAX) {
                ++size;
                BaseCreatureEntity trailingSegment = null;
                if (lastSegment instanceof EntityConcapedeHead) {
                    trailingSegment = lastSegment.backSegment;
                } else if (lastSegment instanceof EntityConcapedeSegment) {
                    trailingSegment = ((EntityConcapedeSegment)lastSegment).backSegment;
                }
                if (trailingSegment == null || trailingSegment == lastSegment) break;
                lastSegment = trailingSegment;
            }
            if (size < CONCAPEDE_SIZE_MAX) {
                EntityConcapedeSegment segmentEntity = (EntityConcapedeSegment)CreatureManager.getInstance().getCreature("concapedesegment").createEntity(lastSegment.func_130014_f_());
                segmentEntity.func_70012_b(lastSegment.func_213303_ch().func_82615_a(), lastSegment.func_213303_ch().func_82617_b(), lastSegment.func_213303_ch().func_82616_c(), 0.0f, 0.0f);
                segmentEntity.setParentTarget((LivingEntity)lastSegment);
                segmentEntity.applySubspecies(this.getSubspeciesIndex());
                segmentEntity.setSizeScale(this.sizeScale);
                segmentEntity.spawnEventType = this.spawnEventType;
                segmentEntity.firstSpawn = false;
                lastSegment.func_130014_f_().func_217376_c((Entity)segmentEntity);
            }
        }
        super.setGrowingAge(age);
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        BlockState blockState = this.func_130014_f_().func_180495_p(new BlockPos(x, y - 1, z));
        Block block = blockState.func_177230_c();
        if (block != Blocks.field_150350_a) {
            if (blockState.func_185904_a() == Material.field_151577_b) {
                return 10.0f;
            }
            if (blockState.func_185904_a() == Material.field_151578_c) {
                return 7.0f;
            }
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean func_184652_a(PlayerEntity player) {
        return true;
    }

    @Override
    public boolean func_213336_c(LivingEntity target) {
        if (target instanceof EntityConcapedeSegment) {
            return false;
        }
        return super.func_213336_c(target);
    }

    @Override
    public boolean func_213398_dR() {
        if (this.isInLove()) {
            return false;
        }
        this.func_130014_f_();
        if (this.isDaytime()) {
            return this.testLightLevel() < 2;
        }
        return super.func_213398_dR();
    }

    @Override
    public boolean isProtective(Entity entity) {
        if (this.isInLove()) {
            return false;
        }
        if (entity instanceof EntityConcapedeSegment) {
            BaseCreatureEntity checkCreature = (BaseCreatureEntity)entity;
            while (checkCreature.hasParent()) {
                if (checkCreature.getParentTarget() == this) {
                    return true;
                }
                if (!(checkCreature.getParentTarget() instanceof BaseCreatureEntity)) break;
                checkCreature = (BaseCreatureEntity)checkCreature.getParentTarget();
            }
        }
        return false;
    }

    @Override
    public boolean canClimb() {
        return true;
    }

    @Override
    public AgeableCreatureEntity createChild(AgeableCreatureEntity partner) {
        return null;
    }

    @Override
    public boolean canBreed() {
        return this.getGrowingAge() >= 0;
    }

    @Override
    public boolean breed() {
        if (super.breed()) {
            this.isHungry = false;
            if (this.getAge() == 0) {
                this.setGrowingAge(0);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canMate() {
        return false;
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }

    @Override
    public void func_70037_a(CompoundNBT nbtTagCompound) {
        if (nbtTagCompound.func_74764_b("IsHungry")) {
            this.isHungry = nbtTagCompound.func_74767_n("IsHungry");
        }
        super.func_70037_a(nbtTagCompound);
    }

    @Override
    public void func_213281_b(CompoundNBT nbtTagCompound) {
        super.func_213281_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("IsHungry", this.isHungry);
    }
}

