/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.creature.EntityVespid;
import com.lycanitesmobs.core.entity.creature.EntityVespidQueen;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.entity.goals.actions.AvoidGoal;
import com.lycanitesmobs.core.entity.goals.targeting.FindAvoidTargetGoal;
import com.lycanitesmobs.core.entity.projectile.EntityPoop;
import com.lycanitesmobs.core.info.CreatureManager;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class EntityConba
extends TameableCreatureEntity
implements IMob {
    AttackRangedGoal aiAttackRanged;
    AttackMeleeGoal aiAttackMelee;
    AvoidGoal aiAvoid;
    public boolean vespidInfection = false;
    public int vespidInfectionTime = 0;

    public EntityConba(EntityType<? extends EntityConba> entityType, World world) {
        super((EntityType<? extends TameableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223222_a_;
        this.hasAttackSound = true;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        this.aiAttackMelee = new AttackMeleeGoal(this).setLongMemory(true).setEnabled(false);
        this.field_70714_bg.func_75776_a(this.nextPriorityGoalIndex++, (Goal)this.aiAttackMelee);
        super.func_184651_r();
        this.aiAvoid = new AvoidGoal(this).setNearSpeed(1.5).setFarSpeed(1.3).setNearDistance(5.0).setFarDistance(9.0);
        this.field_70714_bg.func_75776_a(this.nextPriorityGoalIndex++, (Goal)this.aiAvoid);
        this.aiAttackRanged = new AttackRangedGoal(this).setSpeed(1.0).setRange(16.0f).setMinChaseDistance(10.0f).setChaseTime(-1);
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)this.aiAttackRanged);
        this.field_70715_bh.func_75776_a(this.nextSpecialTargetIndex++, (Goal)new FindAvoidTargetGoal(this).setTargetClass(PlayerEntity.class));
        this.field_70715_bh.func_75776_a(this.nextSpecialTargetIndex++, (Goal)new FindAvoidTargetGoal(this).setTargetClass(VillagerEntity.class));
        this.field_70715_bh.func_75776_a(this.nextSpecialTargetIndex++, (Goal)new FindAvoidTargetGoal(this).setTargetClass(PillagerEntity.class));
    }

    @Override
    public ITextComponent getSpeciesName() {
        String entityName;
        StringTextComponent infection = new StringTextComponent("");
        if (this.vespidInfection && (entityName = this.creatureInfo.getName()) != null) {
            infection = new TranslationTextComponent("entity." + this.creatureInfo.modInfo.modid + "." + entityName + ".infected", new Object[0]);
            infection.func_150258_a(" ");
        }
        return infection.func_150257_a(super.getSpeciesName());
    }

    @Override
    public String getTextureName() {
        if (this.vespidInfection) {
            return super.getTextureName() + "_infected";
        }
        return super.getTextureName();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70122_E && !this.func_130014_f_().field_72995_K) {
            if (this.hasAvoidTarget()) {
                if (this.field_70146_Z.nextInt(10) == 0) {
                    this.leap(1.0f, 0.6, (Entity)this.func_70638_az());
                }
            } else if (this.field_70146_Z.nextInt(50) == 0 && this.isMoving()) {
                this.leap(1.0, 0.6);
            }
        }
        if (!this.func_130014_f_().field_72995_K) {
            if (!this.vespidInfection && "theswarm".equals(this.spawnEventType)) {
                this.vespidInfection = true;
            }
            if (this.vespidInfection && !this.func_130014_f_().field_72995_K) {
                this.aiAttackMelee.setEnabled(true);
                this.aiAttackRanged.setEnabled(false);
                if (this.vespidInfectionTime++ >= 1200) {
                    this.spawnVespidSwarm();
                    this.func_70106_y();
                }
            } else {
                this.aiAttackMelee.setEnabled(false);
                this.aiAttackRanged.setEnabled(true);
            }
        }
        if (this.func_130014_f_().field_72995_K) {
            this.vespidInfection = this.extraAnimation01();
            if (this.vespidInfection) {
                for (int i = 0; i < 2; ++i) {
                    this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197607_R, this.func_213303_ch().func_82615_a() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, this.func_213303_ch().func_82617_b() + this.field_70146_Z.nextDouble() * (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b, this.func_213303_ch().func_82616_c() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public void func_70619_bc() {
        if (!this.func_130014_f_().field_72995_K && this.func_70638_az() != null && this.func_70638_az() != this.getAvoidTarget()) {
            this.setAvoidTarget(this.func_70638_az());
        }
        super.func_70619_bc();
    }

    @Override
    public boolean shouldCreatureGroupFlee(LivingEntity target) {
        if (this.isTamed()) {
            return false;
        }
        return super.shouldCreatureGroupFlee(target);
    }

    @Override
    public boolean func_213336_c(LivingEntity target) {
        if (target instanceof EntityVespid || target instanceof EntityVespidQueen) {
            return false;
        }
        return super.func_213336_c(target);
    }

    @Override
    public void attackRanged(Entity target, float range) {
        this.fireProjectile(EntityPoop.class, target, range, 0.0f, new Vec3d(0.0, 0.0, 0.0), 1.2f, 2.0f, 1.0f);
        super.attackRanged(target, range);
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        if (!this.func_130014_f_().field_72995_K && this.vespidInfection) {
            this.spawnVespidSwarm();
        }
        super.func_70645_a(damageSource);
    }

    public void spawnVespidSwarm() {
        int j = 2 + this.field_70146_Z.nextInt(5) + this.func_130014_f_().func_175659_aa().func_151525_a() - 1;
        for (int k = 0; k < j; ++k) {
            float f = ((float)(k % 2) - 0.5f) * this.func_213305_a((Pose)Pose.STANDING).field_220315_a / 4.0f;
            float f1 = ((float)(k / 2) - 0.5f) * this.func_213305_a((Pose)Pose.STANDING).field_220315_a / 4.0f;
            EntityVespid vespid = (EntityVespid)CreatureManager.getInstance().getCreature("vespid").createEntity(this.func_130014_f_());
            vespid.func_70012_b(this.func_213303_ch().func_82615_a() + (double)f, this.func_213303_ch().func_82617_b() + 0.5, this.func_213303_ch().func_82616_c() + (double)f1, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
            vespid.applySubspecies(this.getSubspeciesIndex());
            vespid.setGrowingAge(vespid.growthTime);
            vespid.spawnEventType = this.spawnEventType;
            this.func_130014_f_().func_217376_c((Entity)vespid);
            if (this.func_70638_az() == null) continue;
            vespid.func_70604_c(this.func_70638_az());
        }
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public boolean extraAnimation01() {
        if (!this.func_130014_f_().field_72995_K) {
            return this.vespidInfection;
        }
        return this.extraAnimation01;
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }

    @Override
    public void func_70037_a(CompoundNBT nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("VespidInfection")) {
            this.vespidInfection = nbtTagCompound.func_74767_n("VespidInfection");
        }
        if (nbtTagCompound.func_74764_b("VespidInfectionTime")) {
            this.vespidInfectionTime = nbtTagCompound.func_74762_e("VespidInfectionTime");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT nbtTagCompound) {
        super.func_213281_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("VespidInfection", this.vespidInfection);
        if (this.vespidInfection) {
            nbtTagCompound.func_74768_a("VespidInfectionTime", this.vespidInfectionTime);
        }
    }
}

