/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.AgeableCreatureEntity;
import com.lycanitesmobs.core.entity.CustomItemEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.TemptGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityCephignis
extends AgeableCreatureEntity {
    WanderGoal wanderAI;

    public EntityCephignis(EntityType<? extends EntityCephignis> entityType, World world) {
        super((EntityType<? extends AgeableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223222_a_;
        this.spawnsOnLand = false;
        this.spawnsInWater = true;
        this.isLavaCreature = true;
        this.hasAttackSound = false;
        this.babySpawnChance = 0.01;
        this.canGrow = true;
        this.fleeHealthPercent = 1.0f;
        this.isAggressiveByDefault = false;
        this.setupMob();
        this.func_184644_a(PathNodeType.LAVA, 0.0f);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextDistractionGoalIndex++, (Goal)new TemptGoal(this).setIncludeDiet(true));
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)new AttackMeleeGoal(this).setLongMemory(false));
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        int waterWeight = 10;
        BlockPos pos = new BlockPos(x, y, z);
        if (this.func_130014_f_().func_180495_p(pos).func_177230_c() == ObjectManager.getBlock("purelava")) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 2);
        }
        if (this.func_130014_f_().func_180495_p(pos).func_177230_c() == Blocks.field_150353_l) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.func_70638_az() != null) {
            return super.getBlockPathWeight(x, y, z);
        }
        if (this.lavaContact()) {
            return -999999.0f;
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean isStrongSwimmer() {
        return true;
    }

    @Override
    public boolean canWalk() {
        return false;
    }

    @Override
    public boolean func_184652_a(PlayerEntity player) {
        return true;
    }

    @Override
    public boolean canBeTempted() {
        if (this.func_70086_ai() <= -100) {
            return false;
        }
        return super.canBeTempted();
    }

    @Override
    public boolean isInvulnerableTo(String type, DamageSource source, float damage) {
        if (type.equals("inWall")) {
            return false;
        }
        return super.isInvulnerableTo(type, source, damage);
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public boolean waterDamage() {
        return true;
    }

    @Override
    public boolean canBreatheUnderlava() {
        return true;
    }

    @Override
    public boolean canBreatheAir() {
        return false;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76347_k()) {
            return 0.0f;
        }
        return super.getDamageModifier(damageSrc);
    }

    @Override
    public void applyDropEffects(CustomItemEntity entityitem) {
        entityitem.setCanBurn(false);
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBrightnessForRender() {
        return 0xF000F0;
    }
}

