/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.RideableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.entity.projectile.EntityArcaneLaserStorm;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import java.util.ArrayList;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityBeholder
extends RideableCreatureEntity {
    public boolean griefing = true;

    public EntityBeholder(EntityType<? extends EntityBeholder> entityType, World world) {
        super((EntityType<? extends RideableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223222_a_;
        this.hasAttackSound = false;
        this.setAttackCooldownMax(20);
        this.solidCollision = true;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)new AttackRangedGoal(this).setSpeed(0.25).setRange(40.0f).setMinChaseDistance(10.0f).setLongMemory(false));
    }

    @Override
    public void loadCreatureFlags() {
        this.griefing = this.creatureInfo.getFlag("griefing", this.griefing);
    }

    @Override
    public void riderEffects(LivingEntity rider) {
        if (rider.func_70644_a(Effects.field_76419_f)) {
            rider.func_195063_d(Effects.field_76419_f);
        }
        if (rider.func_70644_a((Effect)ObjectManager.getEffect("weight"))) {
            rider.func_195063_d((Effect)ObjectManager.getEffect("weight"));
        }
    }

    @Override
    public void onDamage(DamageSource damageSrc, float damage) {
        super.onDamage(damageSrc, damage);
        Entity damageEntity = damageSrc.func_76346_g();
        if (damageEntity != null && ("mob".equals(damageSrc.field_76373_n) || "player".equals(damageSrc.field_76373_n)) && damageEntity instanceof LivingEntity) {
            LivingEntity targetLiving = (LivingEntity)damageEntity;
            ArrayList<Effect> goodEffects = new ArrayList<Effect>();
            for (EffectInstance effect : targetLiving.func_70651_bq()) {
                if (!ObjectLists.inEffectList("buffs", effect.func_188419_a())) continue;
                goodEffects.add(effect.func_188419_a());
            }
            if (goodEffects.size() > 0 && this.func_70681_au().nextBoolean()) {
                if (goodEffects.size() > 1) {
                    targetLiving.func_195063_d((Effect)goodEffects.get(this.func_70681_au().nextInt(goodEffects.size())));
                } else {
                    targetLiving.func_195063_d((Effect)goodEffects.get(0));
                }
                float leeching = damage * 1.1f;
                this.func_70691_i(leeching);
            }
        }
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 5;
    }

    @Override
    public void attackRanged(Entity target, float range) {
        this.fireProjectile(EntityArcaneLaserStorm.class, target, range, 0.0f, new Vec3d(0.0, 0.0, 0.0), 0.6f, 2.0f, 1.0f);
        super.attackRanged(target, range);
    }

    @Override
    public boolean isInvulnerableTo(Entity entity) {
        if (entity instanceof EntityBeholder) {
            return false;
        }
        return super.isInvulnerableTo(entity);
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public double func_70042_X() {
        return (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b * 0.9;
    }

    @Override
    public double getMountedZOffset() {
        return (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a * -0.2;
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.abilityToggled) {
            return;
        }
        if (this.hasPickupEntity()) {
            this.dropPickupEntity();
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        if (rider instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)rider;
            EntityArcaneLaserStorm projectile = new EntityArcaneLaserStorm(ProjectileManager.getInstance().oldProjectileTypes.get(EntityArcaneLaserStorm.class), this.func_130014_f_(), (LivingEntity)player);
            this.func_130014_f_().func_217376_c((Entity)projectile);
            this.func_184185_a(projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.triggerAttackCooldown();
        }
        this.applyStaminaCost();
    }

    @Override
    public float getStaminaCost() {
        return 10.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 40;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 1.0f;
    }

    public float func_70013_c() {
        if (this.isAttackOnCooldown()) {
            return 1.0f;
        }
        return super.func_70013_c();
    }
}

