/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.api.IGroupBoss;
import com.lycanitesmobs.api.IGroupHeavy;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.creature.EntityAstaroth;
import com.lycanitesmobs.core.entity.creature.EntityCacodemon;
import com.lycanitesmobs.core.entity.creature.EntityTrite;
import com.lycanitesmobs.core.entity.creature.EntityWraith;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.SummonMinionsGoal;
import com.lycanitesmobs.core.entity.navigate.ArenaNode;
import com.lycanitesmobs.core.entity.navigate.ArenaNodeNetwork;
import com.lycanitesmobs.core.entity.navigate.ArenaNodeNetworkGrid;
import com.lycanitesmobs.core.entity.projectile.EntityDevilGatling;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.ZombiePigmanEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityAsmodeus
extends BaseCreatureEntity
implements IMob,
IGroupHeavy,
IGroupBoss {
    protected static final DataParameter<Byte> ANIMATION_STATES = EntityDataManager.func_187226_a(EntityAsmodeus.class, (IDataSerializer)DataSerializers.field_187191_a);
    public AttackRangedGoal aiRangedAttack;
    public List<PlayerEntity> playerTargets = new ArrayList<PlayerEntity>();
    public boolean firstPlayerTargetCheck = false;
    public List<EntityAstaroth> astarothMinions = new ArrayList<EntityAstaroth>();
    public List<EntityCacodemon> cacodemonMinions = new ArrayList<EntityCacodemon>();
    public int devilstarStreamTime = 0;
    public int devilstarStreamTimeMax = 100;
    public int devilstarStreamCharge = 400;
    public int devilstarStreamChargeMax = 400;
    public int hellshieldAstarothRespawnTime = 0;
    public int hellshieldAstarothRespawnTimeMax = 30;
    public int rebuildAstarothRespawnTime = 0;
    public int rebuildAstarothRespawnTimeMax = 40;
    public ArenaNodeNetwork arenaNodeNetwork;
    public ArenaNode currentArenaNode;
    public int arenaNodeChangeCooldown = 0;
    public int arenaNodeChangeCooldownMax = 200;
    public int arenaJumpingTime = 0;
    public int arenaJumpingTimeMax = 60;
    protected double jumpHeight = 6.0;

    public EntityAsmodeus(EntityType<? extends EntityAsmodeus> entityType, World world) {
        super(entityType, world);
        this.attribute = CreatureAttribute.field_223222_a_;
        this.hasAttackSound = false;
        this.setAttackCooldownMax(30);
        this.hasJumpSound = true;
        this.solidCollision = true;
        this.field_70144_Y = 1.0f;
        this.setupMob();
        this.hitAreaWidthScale = 2.0f;
        this.damageMax = BaseCreatureEntity.BOSS_DAMAGE_LIMIT;
        this.damageLimit = BaseCreatureEntity.BOSS_DAMAGE_LIMIT;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.aiRangedAttack = new AttackRangedGoal(this).setSpeed(1.0).setStaminaTime(200).setStaminaDrainRate(3).setRange(90.0f).setChaseTime(0).setCheckSight(false);
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)this.aiRangedAttack);
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex, (Goal)new SummonMinionsGoal(this).setMinionInfo("trite").setSummonRate(60).setSummonCap(3).setPerPlayer(true).setPhase(0));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ANIMATION_STATES, (Object)0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_72314_b(200.0, 50.0, 200.0).func_72317_d(0.0, -25.0, 0.0);
    }

    @Override
    public boolean isPersistant() {
        if (this.getMasterTarget() != null && this.getMasterTarget() instanceof EntityAsmodeus) {
            return true;
        }
        return super.isPersistant();
    }

    @Override
    public void onFirstSpawn() {
        super.onFirstSpawn();
        if (this.getArenaCenter() == null) {
            this.setArenaCenter(this.func_180425_c());
        }
    }

    @Override
    public void setArenaCenter(BlockPos pos) {
        super.setArenaCenter(pos);
        this.arenaNodeNetwork = new ArenaNodeNetworkGrid(this.func_130014_f_(), pos, 3, 1, 3, 60);
        this.currentArenaNode = this.arenaNodeNetwork.getClosestNode(this.func_180425_c());
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.updateTick % 200L == 0L || !this.firstPlayerTargetCheck) {
                this.firstPlayerTargetCheck = true;
                this.playerTargets = this.getNearbyEntities(PlayerEntity.class, null, 64.0);
            }
            if (this.updateTick % 20L == 0L && this.playerTargets.isEmpty()) {
                this.func_70691_i(50.0f);
            }
        }
        if (!this.func_130014_f_().field_72995_K) {
            this.updatePhases();
            this.updateCurrentArenaNode();
            this.updateArenaMovement();
        }
        if (!this.func_130014_f_().field_72995_K && this.updateTick % 20L == 0L) {
            for (PlayerEntity target : this.playerTargets) {
                if (target.field_71075_bZ.field_75102_a || target.func_175149_v() || !(CreatureManager.getInstance().config.bossAntiFlight > 0.0) || !(target.func_213303_ch().func_82617_b() > this.func_213303_ch().func_82617_b() + CreatureManager.getInstance().config.bossAntiFlight + 1.0)) continue;
                for (int i = 0; i < 3; ++i) {
                    EntityWraith entityWraith = (EntityWraith)CreatureManager.getInstance().getCreature("wraith").createEntity(this.func_130014_f_());
                    this.summonMinion((LivingEntity)entityWraith, this.func_70681_au().nextDouble() * 360.0, 5.0);
                    entityWraith.func_70624_b((LivingEntity)target);
                }
            }
        }
        if (this.func_130014_f_().field_72995_K && this.updateTick % 200L == 0L) {
            if (!this.astarothMinions.isEmpty()) {
                for (TameableCreatureEntity tameableCreatureEntity : this.astarothMinions.toArray(new EntityAstaroth[this.astarothMinions.size()])) {
                    if (tameableCreatureEntity != null && tameableCreatureEntity.func_70089_S() && tameableCreatureEntity.getMasterTarget() == this) continue;
                    this.astarothMinions.remove((Object)tameableCreatureEntity);
                }
            }
            if (!this.cacodemonMinions.isEmpty()) {
                for (TameableCreatureEntity tameableCreatureEntity : this.cacodemonMinions.toArray(new EntityCacodemon[this.cacodemonMinions.size()])) {
                    if (tameableCreatureEntity != null && tameableCreatureEntity.func_70089_S() && tameableCreatureEntity.getMasterTarget() == this) continue;
                    this.cacodemonMinions.remove((Object)tameableCreatureEntity);
                }
            }
        }
        if (!this.func_130014_f_().field_72995_K) {
            byte animationState = 0;
            if (this.aiRangedAttack != null && this.aiRangedAttack.attackOnCooldown) {
                animationState = (byte)(animationState + ANIMATION_STATES_ID.COOLDOWN.id);
            }
            this.field_70180_af.func_187227_b(ANIMATION_STATES, (Object)animationState);
        }
        if (this.func_130014_f_().field_72995_K && ((Byte)this.field_70180_af.func_187225_a(ANIMATION_STATES) & ANIMATION_STATES_ID.COOLDOWN.id) > 0) {
            BlockPos particlePos = this.getFacingPosition((Entity)this, 13.0, this.func_70079_am() - this.field_70177_z);
            for (int i = 0; i < 4; ++i) {
                this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)particlePos.func_177958_n() + (this.field_70146_Z.nextDouble() - 0.5) * 2.0, (double)particlePos.func_177956_o() + (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b * 0.2 + this.field_70146_Z.nextDouble() * 2.0, (double)particlePos.func_177952_p() + (this.field_70146_Z.nextDouble() - 0.5) * 2.0, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public boolean rollWanderChance() {
        return false;
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    public void updateCurrentArenaNode() {
        if (!this.hasArenaCenter()) {
            return;
        }
        if (this.arenaNodeChangeCooldown > 0) {
            --this.arenaNodeChangeCooldown;
            return;
        }
        if (this.func_70638_az() == null || !this.func_70638_az().func_70089_S()) {
            this.setCurrentArenaNode(this.arenaNodeNetwork.centralNode);
            return;
        }
        if (this.currentArenaNode != null) {
            this.setCurrentArenaNode(this.currentArenaNode.getClosestAdjacentNode(this.func_70638_az().func_180425_c()));
        } else {
            this.setCurrentArenaNode(this.arenaNodeNetwork.getClosestNode(this.func_70638_az().func_180425_c()));
        }
    }

    public void setCurrentArenaNode(ArenaNode arenaNode) {
        this.arenaNodeChangeCooldown = this.arenaNodeChangeCooldownMax;
        if (this.currentArenaNode == arenaNode) {
            return;
        }
        this.currentArenaNode = arenaNode;
        if (this.currentArenaNode != null && this.currentArenaNode.pos != null) {
            this.arenaJumpingTime = this.arenaJumpingTimeMax;
            this.leap(200.0f, this.jumpHeight, this.currentArenaNode.pos);
            if (this.hasJumpSound) {
                this.playJumpSound();
            }
        }
    }

    public void updateArenaMovement() {
        this.field_70145_X = false;
        if (this.currentArenaNode == null || this.currentArenaNode.pos == null) {
            return;
        }
        if (this.arenaJumpingTime > 0) {
            --this.arenaJumpingTime;
            if (this.updateTick % 4L == 0L) {
                double dropForce = -0.5;
                boolean bl = this.field_70145_X = this.func_213303_ch().func_82617_b() > (double)(this.currentArenaNode.pos.func_177956_o() + 8);
                if (this.func_213303_ch().func_82617_b() < (double)this.currentArenaNode.pos.func_177956_o()) {
                    this.func_70107_b(this.func_213303_ch().func_82615_a(), this.currentArenaNode.pos.func_177956_o(), this.func_213303_ch().func_82616_c());
                    dropForce = 0.0;
                }
                this.leap(200.0f, dropForce, this.currentArenaNode.pos);
            }
            if (this.arenaJumpingTime == 0) {
                this.func_180429_a(this.currentArenaNode.pos.func_177977_b(), this.func_130014_f_().func_180495_p(this.currentArenaNode.pos.func_177977_b()));
            }
            return;
        }
        BlockPos arenaPos = this.currentArenaNode.pos;
        double arenaY = this.func_213303_ch().func_82617_b();
        if (this.func_130014_f_().func_175623_d(arenaPos)) {
            arenaY = arenaPos.func_177956_o();
        } else if (this.func_130014_f_().func_175623_d(arenaPos.func_177982_a(0, 1, 0))) {
            arenaY = arenaPos.func_177982_a(0, 1, 0).func_177956_o();
        }
        if (this.func_213303_ch().func_82615_a() != (double)arenaPos.func_177958_n() || this.func_213303_ch().func_82617_b() != arenaY || this.func_213303_ch().func_82616_c() != (double)arenaPos.func_177952_p()) {
            this.func_70107_b(arenaPos.func_177958_n(), arenaY, arenaPos.func_177952_p());
        }
    }

    public void updatePhases() {
        int playerCount = Math.max(this.playerTargets.size(), 1);
        if (this.getBattlePhase() == 0) {
            if (this.devilstarStreamTime > 0) {
                --this.devilstarStreamTime;
                if (this.updateTick % 10L == 0L) {
                    for (float angle = 0.0f; angle < 360.0f; angle += 10.0f) {
                        this.attackDevilstar(angle);
                    }
                }
            } else if (this.devilstarStreamCharge > 0) {
                --this.devilstarStreamCharge;
            } else {
                this.devilstarStreamCharge = this.devilstarStreamChargeMax;
                this.devilstarStreamTime = this.devilstarStreamTimeMax;
            }
        } else if (this.getBattlePhase() == 1 && this.updateTick % 20L == 0L) {
            if (this.astarothMinions.isEmpty() && this.hellshieldAstarothRespawnTime-- <= 0) {
                for (int i = 0; i < 2 * playerCount; ++i) {
                    EntityAstaroth minion = (EntityAstaroth)CreatureManager.getInstance().getCreature("astaroth").createEntity(this.func_130014_f_());
                    this.summonMinion((LivingEntity)minion, this.func_70681_au().nextDouble() * 360.0, 0.0);
                    minion.setSizeScale(2.5);
                    this.astarothMinions.add(minion);
                }
                this.hellshieldAstarothRespawnTime = this.hellshieldAstarothRespawnTimeMax;
            }
        } else if (this.updateTick % 20L == 0L) {
            TameableCreatureEntity minion;
            int i;
            if (this.astarothMinions.size() < playerCount * 4 && this.rebuildAstarothRespawnTime-- <= 0) {
                for (i = 0; i < playerCount; ++i) {
                    minion = (EntityAstaroth)CreatureManager.getInstance().getCreature("astaroth").createEntity(this.func_130014_f_());
                    this.summonMinion((LivingEntity)minion, this.func_70681_au().nextDouble() * 360.0, 0.0);
                    minion.setSizeScale(2.5);
                    this.astarothMinions.add((EntityAstaroth)minion);
                }
                this.rebuildAstarothRespawnTime = this.rebuildAstarothRespawnTimeMax;
            }
            if (this.cacodemonMinions.size() < playerCount * 6 && this.updateTick % 10L * 20L == 0L) {
                for (i = 0; i < 5 * playerCount; ++i) {
                    minion = (EntityCacodemon)CreatureManager.getInstance().getCreature("cacodemon").createEntity(this.func_130014_f_());
                    this.summonMinion((LivingEntity)minion, this.func_70681_au().nextDouble() * 360.0, 10.0);
                    minion.func_70107_b(minion.func_213303_ch().func_82615_a(), minion.func_213303_ch().func_82617_b() + 10.0 + (double)this.func_70681_au().nextInt(20), minion.func_213303_ch().func_82616_c());
                    this.cacodemonMinions.add((EntityCacodemon)minion);
                }
            }
            if (!this.astarothMinions.isEmpty()) {
                float healAmount = this.astarothMinions.size();
                if ((double)((this.func_110143_aJ() + healAmount) / this.func_110138_aP()) <= 0.2) {
                    this.func_70691_i(healAmount * 2.0f);
                }
            }
        }
    }

    @Override
    public void updateBattlePhase() {
        double healthNormal = this.func_110143_aJ() / this.func_110138_aP();
        if (healthNormal <= 0.2) {
            this.setBattlePhase(2);
            return;
        }
        if (healthNormal <= 0.6) {
            this.setBattlePhase(1);
            return;
        }
        this.setBattlePhase(0);
    }

    @Override
    public boolean func_213336_c(LivingEntity target) {
        if (target instanceof EntityTrite || target instanceof EntityCacodemon || target instanceof EntityAstaroth) {
            return false;
        }
        return super.func_213336_c(target);
    }

    @Override
    public void attackRanged(Entity target, float range) {
        this.fireProjectile(EntityDevilGatling.class, target, range, 0.0f, new Vec3d(0.0, 8.0, 0.0), 1.2f, 6.0f, 0.0f);
        super.attackRanged(target, range);
    }

    public void attackDevilstar(float angle) {
        ProjectileInfo projectileInfo = ProjectileManager.getInstance().getProjectile("devilstar");
        if (projectileInfo == null) {
            return;
        }
        BaseProjectileEntity projectile = projectileInfo.createProjectile(this.func_130014_f_(), (LivingEntity)this);
        projectile.setProjectileScale(4.0f);
        BlockPos offset = this.getFacingPosition((Entity)this, 8.0, angle);
        projectile.func_70107_b(offset.func_177958_n(), (double)offset.func_177956_o() + (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b * 0.5, offset.func_177952_p());
        float range = 20.0f + 20.0f * this.func_70681_au().nextFloat();
        BlockPos target = this.getFacingPosition((Entity)this, range, angle);
        double d0 = (double)target.func_177958_n() - projectile.func_213303_ch().func_82615_a();
        double d1 = (double)target.func_177956_o() - projectile.func_213303_ch().func_82617_b();
        double d2 = (double)target.func_177952_p() - projectile.func_213303_ch().func_82616_c();
        float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.1f;
        float velocity = 1.2f;
        projectile.func_70186_c(d0, d1 + (double)f1, d2, velocity, 0.0f);
        this.func_184185_a(projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.func_130014_f_().func_217376_c((Entity)projectile);
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        if (!this.func_130014_f_().field_72995_K && CreatureManager.getInstance().getCreature((String)"trite").enabled) {
            int j = 6 + this.field_70146_Z.nextInt(20) + this.func_130014_f_().func_175659_aa().func_151525_a() * 4;
            for (int k = 0; k < j; ++k) {
                float f = ((float)(k % 2) - 0.5f) * this.func_213305_a((Pose)Pose.STANDING).field_220315_a / 4.0f;
                float f1 = ((float)(k / 2) - 0.5f) * this.func_213305_a((Pose)Pose.STANDING).field_220315_a / 4.0f;
                EntityTrite trite = (EntityTrite)CreatureManager.getInstance().getCreature("trite").createEntity(this.func_130014_f_());
                trite.func_70012_b(this.func_213303_ch().func_82615_a() + (double)f, this.func_213303_ch().func_82617_b() + 0.5, this.func_213303_ch().func_82616_c() + (double)f1, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                trite.setMinion(true);
                trite.applySubspecies(this.getSubspeciesIndex());
                this.func_130014_f_().func_217376_c((Entity)trite);
                if (this.func_70638_az() == null) continue;
                trite.func_70604_c(this.func_70638_az());
            }
        }
        super.func_70645_a(damageSource);
    }

    @Override
    public void onMinionDeath(LivingEntity minion, DamageSource damageSource) {
        if (minion instanceof EntityAstaroth && this.astarothMinions.contains(minion)) {
            this.astarothMinions.remove(minion);
        }
        if (minion instanceof EntityCacodemon && this.cacodemonMinions.contains(minion)) {
            this.cacodemonMinions.remove(minion);
        }
        super.onMinionDeath(minion, damageSource);
    }

    @Override
    public boolean func_180431_b(DamageSource source) {
        if (this.isBlocking()) {
            return true;
        }
        return super.func_180431_b(source);
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public boolean isBlocking() {
        if (this.func_130014_f_().field_72995_K) {
            return super.isBlocking();
        }
        return this.getBattlePhase() == 1 && !this.astarothMinions.isEmpty();
    }

    @Override
    public boolean canAttackWhileBlocking() {
        return true;
    }

    @Override
    public boolean isInvulnerableTo(Entity entity) {
        if (entity instanceof ZombiePigmanEntity) {
            entity.func_70106_y();
            return false;
        }
        if (entity instanceof IronGolemEntity) {
            entity.func_70106_y();
            return false;
        }
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            if (!player.field_71075_bZ.field_75102_a && player.func_213303_ch().func_82617_b() > this.func_213303_ch().func_82617_b() + CreatureManager.getInstance().config.bossAntiFlight) {
                return false;
            }
        }
        return super.isInvulnerableTo(entity);
    }

    @Override
    public boolean func_70097_a(DamageSource damageSrc, float damageAmount) {
        if (this.playerTargets != null && damageSrc.func_76346_g() != null && damageSrc.func_76346_g() instanceof PlayerEntity && !this.playerTargets.contains(damageSrc.func_76346_g())) {
            this.playerTargets.add((PlayerEntity)damageSrc.func_76346_g());
        }
        return super.func_70097_a(damageSrc, damageAmount);
    }

    @Override
    public void func_70037_a(CompoundNBT nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("DevilstarStreamCharge")) {
            this.devilstarStreamCharge = nbtTagCompound.func_74762_e("DevilstarStreamCharge");
        }
        if (nbtTagCompound.func_74764_b("DevilstarStreamTime")) {
            this.devilstarStreamTime = nbtTagCompound.func_74762_e("DevilstarStreamTime");
        }
        if (nbtTagCompound.func_74764_b("AstarothIDs")) {
            ListNBT astarothIDs = nbtTagCompound.func_150295_c("AstarothIDs", 10);
            for (int i = 0; i < astarothIDs.size(); ++i) {
                Entity entity;
                CompoundNBT astarothID = astarothIDs.func_150305_b(i);
                if (!astarothID.func_74764_b("ID") || (entity = this.func_130014_f_().func_73045_a(astarothID.func_74762_e("ID"))) == null || !(entity instanceof EntityAstaroth)) continue;
                this.astarothMinions.add((EntityAstaroth)entity);
            }
        }
    }

    @Override
    public void func_213281_b(CompoundNBT nbtTagCompound) {
        super.func_213281_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("DevilstarStreamCharge", this.devilstarStreamCharge);
        nbtTagCompound.func_74768_a("DevilstarStreamTime", this.devilstarStreamTime);
        if (this.getBattlePhase() > 0) {
            ListNBT astarothIDs = new ListNBT();
            for (EntityAstaroth entityAstaroth : this.astarothMinions) {
                CompoundNBT astarothID = new CompoundNBT();
                astarothID.func_74768_a("ID", entityAstaroth.func_145782_y());
                astarothIDs.add((Object)astarothID);
            }
            nbtTagCompound.func_218657_a("AstarothIDs", (INBT)astarothIDs);
        }
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBrightnessForRender() {
        return 0xF000F0;
    }

    public static enum ANIMATION_STATES_ID {
        SNAP_TO_ARENA(1),
        COOLDOWN(2);

        public final byte id;

        private ANIMATION_STATES_ID(byte value) {
            this.id = value;
        }

        public byte getValue() {
            return this.id;
        }
    }
}

