/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupBoss;
import com.lycanitesmobs.api.IGroupHeavy;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.creature.EntityBanshee;
import com.lycanitesmobs.core.entity.creature.EntityEpion;
import com.lycanitesmobs.core.entity.creature.EntityGeist;
import com.lycanitesmobs.core.entity.creature.EntityReaper;
import com.lycanitesmobs.core.entity.goals.actions.FindNearbyPlayersGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.EffectAuraGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.FaceTargetGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.FireProjectilesGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.ForceGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.GrowGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.HealWhenNoPlayersGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.SuicideGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.SummonMinionsGoal;
import com.lycanitesmobs.core.entity.goals.targeting.CopyMasterAttackTargetGoal;
import com.lycanitesmobs.core.entity.projectile.EntitySpectralbolt;
import com.lycanitesmobs.core.info.CreatureManager;
import net.minecraft.block.Block;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.ZombiePigmanEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityAmalgalich
extends BaseCreatureEntity
implements IMob,
IGroupHeavy,
IGroupBoss {
    private ForceGoal consumptionGoalP0;
    private ForceGoal consumptionGoalP2;
    private int consumptionDuration = 300;
    private int consumptionWindUp = 60;
    private int consumptionAnimationTime = 0;

    public EntityAmalgalich(EntityType<? extends EntityAmalgalich> entityType, World world) {
        super(entityType, world);
        this.attribute = CreatureAttribute.field_223223_b_;
        this.hasAttackSound = true;
        this.setAttackCooldownMax(30);
        this.hasJumpSound = false;
        this.field_70144_Y = 1.0f;
        this.setupMob();
        this.hitAreaWidthScale = 2.0f;
        this.damageMax = BaseCreatureEntity.BOSS_DAMAGE_LIMIT;
        this.damageLimit = BaseCreatureEntity.BOSS_DAMAGE_LIMIT;
    }

    @Override
    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(this.nextFindTargetIndex, (Goal)new FindNearbyPlayersGoal(this));
        this.consumptionDuration = 300;
        this.consumptionWindUp = 60;
        this.consumptionAnimationTime = 0;
        int consumptionCooldown = 400;
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex, (Goal)new FaceTargetGoal(this));
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex, (Goal)new HealWhenNoPlayersGoal(this));
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex, (Goal)new SummonMinionsGoal(this).setMinionInfo("banshee").setAntiFlight(true));
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex, (Goal)new FireProjectilesGoal(this).setProjectile(EntitySpectralbolt.class).setFireRate(40).setVelocity(1.6f).setScale(8.0f).setAllPlayers(true));
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex, (Goal)new FireProjectilesGoal(this).setProjectile(EntitySpectralbolt.class).setFireRate(60).setVelocity(1.6f).setScale(8.0f));
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex, (Goal)new EffectAuraGoal(this).setEffect("decay").setAmplifier(0).setEffectSeconds(5).setRange(52.0f).setCheckSight(false));
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex, (Goal)new SummonMinionsGoal(this).setMinionInfo("reaper").setSummonRate(100).setSummonCap(5).setPhase(0).setPerPlayer(true));
        this.consumptionGoalP0 = new ForceGoal(this).setRange(64.0f).setCooldown(consumptionCooldown).setDuration(this.consumptionDuration).setWindUp(this.consumptionWindUp).setForce(-1.0f).setPhase(0);
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex, (Goal)new EffectAuraGoal(this).setRange(1.0f).setCooldown(consumptionCooldown + this.consumptionWindUp).setDuration(this.consumptionDuration - this.consumptionWindUp).setTickRate(5).setDamageAmount(1000.0f).setCheckSight(false).setTargetAll(true).setPhase(0));
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex, (Goal)this.consumptionGoalP0);
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex, (Goal)new SummonMinionsGoal(this).setMinionInfo("geist").setSummonRate(100).setSummonCap(5).setPhase(1).setPerPlayer(true));
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex, (Goal)new SummonMinionsGoal(this).setMinionInfo("epion").setSummonRate(100).setSummonCap(3).setPhase(1).setPerPlayer(true));
        this.consumptionGoalP2 = new ForceGoal(this).setRange(64.0f).setCooldown(consumptionCooldown).setDuration(this.consumptionDuration).setWindUp(this.consumptionWindUp).setForce(-1.0f).setPhase(2);
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex, (Goal)this.consumptionGoalP2);
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex, (Goal)new EffectAuraGoal(this).setRange(1.0f).setCooldown(consumptionCooldown + this.consumptionWindUp).setDuration(this.consumptionDuration - this.consumptionWindUp).setTickRate(5).setDamageAmount(1000.0f).setCheckSight(false).setTargetAll(true).setPhase(2));
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex, (Goal)new FireProjectilesGoal(this).setProjectile("lobdarklings").setFireRate(200).setVelocity(0.8f).setScale(2.0f).setRandomCount(3).setAngle(360).setPhase(2));
        super.func_184651_r();
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_72314_b(200.0, 50.0, 200.0).func_72317_d(0.0, -25.0, 0.0);
    }

    @Override
    public void onFirstSpawn() {
        super.onFirstSpawn();
        if (this.getArenaCenter() == null) {
            this.setArenaCenter(this.func_180425_c());
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.hasArenaCenter()) {
            BlockPos arenaPos = this.getArenaCenter();
            double arenaY = this.func_213303_ch().func_82617_b();
            if (this.func_130014_f_().func_175623_d(arenaPos)) {
                arenaY = arenaPos.func_177956_o();
            } else if (this.func_130014_f_().func_175623_d(arenaPos.func_177982_a(0, 1, 0))) {
                arenaY = arenaPos.func_177982_a(0, 1, 0).func_177956_o();
            }
            if (this.func_213303_ch().func_82615_a() != (double)arenaPos.func_177958_n() || this.func_213303_ch().func_82617_b() != arenaY || this.func_213303_ch().func_82616_c() != (double)arenaPos.func_177952_p()) {
                this.func_70107_b(arenaPos.func_177958_n(), arenaY, arenaPos.func_177952_p());
            }
        }
        if (this.func_130014_f_().field_72995_K) {
            this.consumptionAnimationTime = !this.extraAnimation01() ? this.consumptionDuration : --this.consumptionAnimationTime;
        }
    }

    @Override
    public void updateBattlePhase() {
        double healthNormal = this.func_110143_aJ() / this.func_110138_aP();
        if (healthNormal <= 0.2) {
            this.setBattlePhase(2);
            return;
        }
        if (healthNormal <= 0.6) {
            this.setBattlePhase(1);
            return;
        }
        this.setBattlePhase(0);
    }

    @Override
    public boolean rollWanderChance() {
        return false;
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    @Override
    public boolean func_213336_c(LivingEntity target) {
        if (target instanceof EntityBanshee || target instanceof EntityReaper || target instanceof EntityGeist) {
            return false;
        }
        return super.func_213336_c(target);
    }

    @Override
    public void attackRanged(Entity target, float range) {
        this.fireProjectile(EntitySpectralbolt.class, target, range, 0.0f, new Vec3d(0.0, -12.0, 0.0), 1.2f, 8.0f, 0.0f);
        super.attackRanged(target, range);
    }

    public float getConsumptionAnimation() {
        if (this.consumptionAnimationTime >= this.consumptionDuration) {
            return 0.0f;
        }
        int windUpThreshhold = this.consumptionDuration - this.consumptionWindUp;
        if (this.consumptionAnimationTime > windUpThreshhold) {
            return 1.0f - (float)(this.consumptionAnimationTime - windUpThreshhold) / (float)this.consumptionWindUp;
        }
        float finishingTime = (float)this.consumptionWindUp / 2.0f;
        if ((float)this.consumptionAnimationTime < finishingTime) {
            return (float)this.consumptionAnimationTime / finishingTime;
        }
        return 1.0f;
    }

    @Override
    public boolean extraAnimation01() {
        if (this.func_130014_f_().field_72995_K) {
            return super.extraAnimation01();
        }
        if (this.getBattlePhase() == 0) {
            return this.consumptionGoalP0.cooldownTime <= 0;
        }
        if (this.getBattlePhase() == 2) {
            return this.consumptionGoalP2.cooldownTime <= 0;
        }
        return super.extraAnimation01();
    }

    @Override
    public boolean addMinion(LivingEntity minion) {
        boolean minionAdded = super.addMinion(minion);
        if (minionAdded && minion instanceof BaseCreatureEntity) {
            BaseCreatureEntity minionCreature = (BaseCreatureEntity)minion;
            minionCreature.field_70715_bh.func_75776_a(minionCreature.nextFindTargetIndex++, (Goal)new CopyMasterAttackTargetGoal(minionCreature));
            if (minion instanceof EntityGeist) {
                minionCreature.field_70714_bg.func_75776_a(minionCreature.nextIdleGoalIndex++, (Goal)new GrowGoal(minionCreature).setGrowthAmount(0.1f).setTickRate(20));
                minionCreature.field_70714_bg.func_75776_a(minionCreature.nextIdleGoalIndex++, (Goal)new SuicideGoal(minionCreature).setCountdown(400));
            }
        }
        return minionAdded;
    }

    @Override
    public void onMinionDeath(LivingEntity minion, DamageSource damageSource) {
        super.onMinionDeath(minion, damageSource);
        if (minion instanceof EntityEpion) {
            int extinguishWidth = 10;
            int extinguishHeight = 30;
            if (!this.func_130014_f_().field_72995_K) {
                for (int x = (int)minion.func_213303_ch().func_82615_a() - extinguishWidth; x <= (int)minion.func_213303_ch().func_82615_a() + extinguishWidth; ++x) {
                    for (int y = (int)minion.func_213303_ch().func_82617_b() - extinguishHeight; y <= (int)minion.func_213303_ch().func_82617_b() + 2; ++y) {
                        for (int z = (int)minion.func_213303_ch().func_82616_c() - extinguishWidth; z <= (int)minion.func_213303_ch().func_82616_c() + extinguishWidth; ++z) {
                            Block block = this.func_130014_f_().func_180495_p(new BlockPos(x, y, z)).func_177230_c();
                            if (block != ObjectManager.getBlock("shadowfire")) continue;
                            BlockPos placePos = new BlockPos(x, y, z);
                            this.func_130014_f_().func_217377_a(placePos, true);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void onTryToDamageMinion(LivingEntity minion, float damageAmount) {
        super.onTryToDamageMinion(minion, damageAmount);
        if (damageAmount >= 1000.0f) {
            minion.func_70106_y();
            this.func_70691_i(25.0f);
        }
    }

    @Override
    public boolean func_180431_b(DamageSource source) {
        if (this.isBlocking()) {
            return true;
        }
        return super.func_180431_b(source);
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public boolean isBlocking() {
        return super.isBlocking();
    }

    @Override
    public boolean canAttackWhileBlocking() {
        return true;
    }

    @Override
    public boolean isInvulnerableTo(Entity entity) {
        if (entity instanceof ZombiePigmanEntity) {
            entity.func_70106_y();
            return false;
        }
        if (entity instanceof IronGolemEntity) {
            entity.func_70106_y();
            return false;
        }
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            if (!player.field_71075_bZ.field_75102_a && player.func_213303_ch().func_82617_b() > this.func_213303_ch().func_82617_b() + CreatureManager.getInstance().config.bossAntiFlight) {
                return false;
            }
        }
        return super.isInvulnerableTo(entity);
    }

    @Override
    public boolean func_70097_a(DamageSource damageSrc, float damageAmount) {
        if (this.playerTargets != null && damageSrc.func_76346_g() != null && damageSrc.func_76346_g() instanceof PlayerEntity && !this.playerTargets.contains(damageSrc.func_76346_g())) {
            this.playerTargets.add((PlayerEntity)damageSrc.func_76346_g());
        }
        return super.func_70097_a(damageSrc, damageAmount);
    }

    @Override
    public void func_70037_a(CompoundNBT nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
    }

    @Override
    public void func_213281_b(CompoundNBT nbtTagCompound) {
        super.func_213281_b(nbtTagCompound);
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBrightnessForRender() {
        return 0xF000F0;
    }
}

