/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.api.IFusable;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.creature.EntityArgus;
import com.lycanitesmobs.core.entity.creature.EntityCinder;
import com.lycanitesmobs.core.entity.creature.EntityDjinn;
import com.lycanitesmobs.core.entity.creature.EntityGeonach;
import com.lycanitesmobs.core.entity.creature.EntityJengu;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.targeting.DefendEntitiesGoal;
import com.lycanitesmobs.core.entity.goals.targeting.DefendVillageGoal;
import com.lycanitesmobs.core.info.CreatureManager;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityAegis
extends TameableCreatureEntity
implements IFusable {
    protected IFusable fusionTarget;

    public EntityAegis(EntityType<? extends EntityAegis> entityType, World world) {
        super((EntityType<? extends TameableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223222_a_;
        this.hasAttackSound = true;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)new AttackMeleeGoal(this).setLongMemory(true));
        this.field_70715_bh.func_75776_a(this.nextSpecialTargetIndex++, (Goal)new DefendVillageGoal(this));
        this.field_70715_bh.func_75776_a(this.nextSpecialTargetIndex++, (Goal)new DefendEntitiesGoal(this, VillagerEntity.class));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K && !this.hasAttackTarget() && this.currentBlockingTime < 2) {
            this.setBlocking();
        }
    }

    @Override
    public boolean canBeTargetedBy(LivingEntity entity) {
        if (entity instanceof IronGolemEntity || entity instanceof VillagerEntity) {
            return false;
        }
        return super.canBeTargetedBy(entity);
    }

    @Override
    public boolean shouldCreatureGroupHunt(LivingEntity target) {
        if (target instanceof TameableCreatureEntity && ((TameableCreatureEntity)target).isTamed()) {
            return false;
        }
        return super.shouldCreatureGroupHunt(target);
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean canAttackWhileBlocking() {
        return false;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public boolean isInvulnerableTo(String type, DamageSource source, float damage) {
        if (type.equals("cactus") || type.equals("inWall")) {
            return false;
        }
        return super.isInvulnerableTo(type, source, damage);
    }

    @Override
    public void onDamage(DamageSource damageSrc, float damage) {
        if (this.func_70681_au().nextDouble() > 0.75 && this.func_110143_aJ() / this.func_110138_aP() > 0.25f) {
            this.setBlocking();
        }
        if (damageSrc.func_76346_g() != null && damageSrc.func_76346_g() instanceof MonsterEntity) {
            damage *= 0.5f;
        }
        super.onDamage(damageSrc, damage);
    }

    @Override
    public void setBlocking() {
        this.currentBlockingTime = this.blockingTime + this.func_70681_au().nextInt(this.blockingTime / 2);
    }

    @Override
    public IFusable getFusionTarget() {
        return this.fusionTarget;
    }

    @Override
    public void setFusionTarget(IFusable fusionTarget) {
        this.fusionTarget = fusionTarget;
    }

    @Override
    public EntityType<? extends LivingEntity> getFusionType(IFusable fusable) {
        if (fusable instanceof EntityCinder) {
            return CreatureManager.getInstance().getEntityType("wisp");
        }
        if (fusable instanceof EntityJengu) {
            return CreatureManager.getInstance().getEntityType("nymph");
        }
        if (fusable instanceof EntityGeonach) {
            return CreatureManager.getInstance().getEntityType("vapula");
        }
        if (fusable instanceof EntityDjinn) {
            return CreatureManager.getInstance().getEntityType("sylph");
        }
        if (fusable instanceof EntityArgus) {
            return CreatureManager.getInstance().getEntityType("spectre");
        }
        return null;
    }
}

