/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.entity.LaserProjectileEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class LaserEndProjectileEntity
extends BaseProjectileEntity {
    private double targetX;
    private double targetY;
    private double targetZ;
    private int posIDStart = 13;
    public LivingEntity shootingEntity;
    public LaserProjectileEntity laserEntity;
    private float projectileWidth = 0.2f;
    private float projectileHeight = 0.2f;
    private double projectileSpeed;
    protected static final DataParameter<Float> POS_X = EntityDataManager.func_187226_a(LaserEndProjectileEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> POS_Y = EntityDataManager.func_187226_a(LaserEndProjectileEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> POS_Z = EntityDataManager.func_187226_a(LaserEndProjectileEntity.class, (IDataSerializer)DataSerializers.field_187193_c);

    public LaserEndProjectileEntity(EntityType<? extends BaseProjectileEntity> entityType, World world) {
        super(entityType, world);
        this.setStats();
    }

    public LaserEndProjectileEntity(EntityType<? extends BaseProjectileEntity> entityType, World world, double par2, double par4, double par6, LaserProjectileEntity laser) {
        super(entityType, world, par2, par4, par6);
        this.laserEntity = laser;
        this.setStats();
    }

    public LaserEndProjectileEntity(EntityType<? extends BaseProjectileEntity> entityType, World world, LivingEntity shooter, LaserProjectileEntity laser) {
        super(entityType, world, shooter);
        this.shootingEntity = shooter;
        this.laserEntity = laser;
        this.setStats();
    }

    public void setStats() {
        this.setSpeed(1.0);
        if (this.laserEntity != null) {
            this.targetX = this.laserEntity.func_213303_ch().func_82615_a();
            this.targetY = this.laserEntity.func_213303_ch().func_82617_b();
            this.targetZ = this.laserEntity.func_213303_ch().func_82616_c();
        }
        this.field_70180_af.func_187214_a(POS_X, (Object)Float.valueOf((float)this.func_213303_ch().func_82615_a()));
        this.field_70180_af.func_187214_a(POS_Y, (Object)Float.valueOf((float)this.func_213303_ch().func_82617_b()));
        this.field_70180_af.func_187214_a(POS_Z, (Object)Float.valueOf((float)this.func_213303_ch().func_82616_c()));
        this.field_70145_X = true;
    }

    @Override
    public void func_70071_h_() {
        if (this.func_130014_f_().field_72995_K) {
            this.func_70107_b(((Float)this.field_70180_af.func_187225_a(POS_X)).floatValue(), ((Float)this.field_70180_af.func_187225_a(POS_Y)).floatValue(), ((Float)this.field_70180_af.func_187225_a(POS_Z)).floatValue());
            return;
        }
        if ((this.laserEntity == null || !this.laserEntity.func_70089_S()) && this.func_70089_S()) {
            this.func_70106_y();
        }
        if (this.func_70089_S()) {
            this.moveToTarget();
        }
        this.field_70180_af.func_187227_b(POS_X, (Object)Float.valueOf((float)this.func_213303_ch().func_82615_a()));
        this.field_70180_af.func_187227_b(POS_Y, (Object)Float.valueOf((float)this.func_213303_ch().func_82617_b()));
        this.field_70180_af.func_187227_b(POS_Z, (Object)Float.valueOf((float)this.func_213303_ch().func_82616_c()));
    }

    public void onUpdateEnd(double newTargetX, double newTargetY, double newTargetZ) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        this.targetX = newTargetX;
        this.targetY = newTargetY;
        this.targetZ = newTargetZ;
        if (this.getLaunchSound() != null) {
            this.func_184185_a(this.getLaunchSound(), 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        }
    }

    @Override
    protected float func_70185_h() {
        return 0.0f;
    }

    public void moveToTarget() {
        this.func_70107_b(this.targetX, this.targetY, this.targetZ);
    }

    public double moveCoordToTarget(double coord, double targetCoord, double originCoord) {
        double distance = targetCoord - coord;
        double moveSpeed = this.projectileSpeed;
        if (distance > 0.0) {
            if (distance < moveSpeed + 1.0) {
                moveSpeed = distance;
            }
            if (targetCoord - originCoord > coord - originCoord) {
                return coord + moveSpeed;
            }
            return targetCoord;
        }
        if (distance < 0.0) {
            if (distance > -moveSpeed - 1.0) {
                moveSpeed = -distance;
            }
            if (targetCoord - originCoord < coord - originCoord) {
                return coord - moveSpeed;
            }
            return targetCoord;
        }
        return targetCoord;
    }

    @Override
    protected void func_70184_a(RayTraceResult rayTraceResult) {
    }

    public void setSpeed(double speed) {
        this.projectileSpeed = speed;
    }

    @Override
    public ResourceLocation getTexture() {
        return null;
    }
}

