/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.EffectBase;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.inventory.InventoryCreature;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FearEntity
extends BaseCreatureEntity {
    public LivingEntity fearedEntity;

    public FearEntity(EntityType<? extends FearEntity> entityType, World world) {
        super(entityType, world);
        this.hasStepSound = false;
        this.hasAttackSound = false;
        this.spreadFire = false;
        this.setupMob();
    }

    public FearEntity(EntityType<? extends FearEntity> entityType, World world, LivingEntity feared) {
        this(entityType, world);
        this.setFearedEntity(feared);
    }

    @Override
    public void setupMob() {
        this.field_70728_aV = 0;
        this.inventory = new InventoryCreature(this.func_200200_C_().toString(), this);
    }

    @Override
    public void loadItemDrops() {
    }

    @Override
    protected boolean canDespawnNaturally() {
        return false;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.fearedEntity == null || !this.fearedEntity.func_70089_S() || !(this.fearedEntity instanceof LivingEntity)) {
            this.func_70106_y();
            return;
        }
        LivingEntity fearedLivingEntity = this.fearedEntity;
        if (this.canPickupEntity(this.fearedEntity)) {
            this.pickupEntity(this.fearedEntity);
        }
        if (this.hasPickupEntity() && !(this.getPickupEntity() instanceof PlayerEntity)) {
            this.getPickupEntity().field_70177_z = this.field_70177_z;
            this.getPickupEntity().field_70125_A = this.field_70125_A;
        }
        if (this.getPickupEntity() == null) {
            this.func_70107_b(this.fearedEntity.func_213303_ch().func_82615_a(), this.fearedEntity.func_213303_ch().func_82617_b(), this.fearedEntity.func_213303_ch().func_82616_c());
            this.func_213317_d(this.fearedEntity.func_213322_ci());
            this.field_70143_R = 0.0f;
        }
        if (ObjectManager.getEffect("fear") == null || !this.fearedEntity.func_70644_a((Effect)ObjectManager.getEffect("fear"))) {
            this.func_70106_y();
            return;
        }
        if (this.fearedEntity != null) {
            EffectBase instability;
            if (this.fearedEntity.func_70644_a(Effects.field_188424_y)) {
                EffectInstance activeDebuff = this.fearedEntity.func_70660_b(Effects.field_188424_y);
                this.func_195064_c(new EffectInstance(Effects.field_188424_y, activeDebuff.func_76459_b(), activeDebuff.func_76458_c()));
            }
            if ((instability = ObjectManager.getEffect("instability")) != null && this.fearedEntity.func_70644_a((Effect)instability)) {
                EffectInstance activeDebuff = this.fearedEntity.func_70660_b((Effect)instability);
                this.func_195064_c(new EffectInstance((Effect)instability, activeDebuff.func_76459_b(), activeDebuff.func_76458_c()));
            }
        }
    }

    @Override
    public boolean rollWanderChance() {
        return true;
    }

    public void setFearedEntity(LivingEntity feared) {
        this.fearedEntity = feared;
        this.field_70145_X = feared.field_70145_X;
        this.field_70138_W = feared.field_70138_W;
        this.func_70012_b(feared.func_213303_ch().func_82615_a(), feared.func_213303_ch().func_82617_b(), feared.func_213303_ch().func_82616_c(), feared.field_70177_z, feared.field_70125_A);
        if (!(feared instanceof PlayerEntity)) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(feared.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b());
        }
    }

    @Override
    public boolean isInvulnerableTo(String type, DamageSource source, float damage) {
        return false;
    }

    @Override
    public boolean func_70687_e(EffectInstance effectInstance) {
        return false;
    }

    @Override
    public boolean isFlying() {
        if (this.pickupEntity != null) {
            if (this.pickupEntity instanceof BaseCreatureEntity) {
                return ((BaseCreatureEntity)this.pickupEntity).isFlying();
            }
            if (this.pickupEntity instanceof FlyingEntity) {
                return true;
            }
            if (this.pickupEntity instanceof PlayerEntity) {
                return ((PlayerEntity)this.pickupEntity).field_71075_bZ.field_75098_d;
            }
        }
        return false;
    }

    public boolean func_82150_aj() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_98034_c(PlayerEntity player) {
        return true;
    }

    public boolean func_70067_L() {
        return false;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return ObjectManager.getSound("effect_fear");
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return ObjectManager.getSound("effect_fear");
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return ObjectManager.getSound("effect_fear");
    }

    @Override
    public void playFlySound() {
    }
}

