/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.EffectBase;
import com.lycanitesmobs.core.capabilities.IExtendedEntity;
import com.lycanitesmobs.core.config.ConfigAdmin;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.FearEntity;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.network.MessageEntityPerched;
import com.lycanitesmobs.core.network.MessageEntityPickedUp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.util.math.Vec3d;

public class ExtendedEntity
implements IExtendedEntity {
    public static Map<Entity, ExtendedEntity> clientExtendedEntities = new HashMap<Entity, ExtendedEntity>();
    public static List<? extends String> FORCE_REMOVE_ENTITY_IDS;
    public static int FORCE_REMOVE_ENTITY_TICKS;
    public LivingEntity entity;
    public int equipmentProjectileCooldown = 0;
    Vec3d lastSafePos;
    private boolean playerAllowFlyingSnapshot;
    private boolean playerIsFlyingSnapshot;
    public LivingEntity lastAttackedEntity;
    public int lastAttackedTime = 0;
    public Entity pickedUpByEntity;
    public Entity perchedByEntity;
    public boolean perchedEntityNoclip = false;
    public FearEntity fearEntity;
    boolean forceRemoveChecked = false;
    boolean forceRemove = false;
    int forceRemoveTicks = FORCE_REMOVE_ENTITY_TICKS;

    public static ExtendedEntity getForEntity(LivingEntity entity) {
        if (entity == null) {
            return null;
        }
        if (entity.func_130014_f_().field_72995_K) {
            if (clientExtendedEntities.containsKey(entity)) {
                ExtendedEntity extendedEntity = clientExtendedEntities.get(entity);
                extendedEntity.setEntity(entity);
                return extendedEntity;
            }
            ExtendedEntity extendedEntity = new ExtendedEntity();
            extendedEntity.setEntity(entity);
            clientExtendedEntities.put((Entity)entity, extendedEntity);
            return extendedEntity;
        }
        IExtendedEntity iExtendedEntity = (IExtendedEntity)entity.getCapability(LycanitesMobs.EXTENDED_ENTITY, null).orElse(null);
        if (!(iExtendedEntity instanceof ExtendedEntity)) {
            return null;
        }
        ExtendedEntity extendedEntity = (ExtendedEntity)iExtendedEntity;
        if (extendedEntity.getEntity() != entity) {
            extendedEntity.setEntity(entity);
        }
        return extendedEntity;
    }

    public void setEntity(LivingEntity entity) {
        this.entity = entity;
    }

    public LivingEntity getEntity() {
        return this.entity;
    }

    public void setLastAttackedEntity(LivingEntity target) {
        this.lastAttackedEntity = target;
        this.lastAttackedTime = this.entity.field_70173_aa;
    }

    public void onUpdate() {
        if (this.entity == null) {
            return;
        }
        if (this.equipmentProjectileCooldown > 0) {
            --this.equipmentProjectileCooldown;
        }
        FORCE_REMOVE_ENTITY_IDS = (List)ConfigAdmin.INSTANCE.forceRemoveEntityIds.get();
        FORCE_REMOVE_ENTITY_TICKS = 40;
        if (!this.entity.func_130014_f_().field_72995_K && FORCE_REMOVE_ENTITY_IDS != null && FORCE_REMOVE_ENTITY_IDS.size() > 0 && !this.forceRemoveChecked) {
            LycanitesMobs.logDebug("ForceRemoveEntity", "Forced entity removal, checking: " + this.entity.func_200200_C_());
            for (String string : FORCE_REMOVE_ENTITY_IDS) {
                if (!string.equalsIgnoreCase(this.entity.func_200600_R().getRegistryName().toString())) continue;
                this.forceRemove = true;
                break;
            }
            this.forceRemoveChecked = true;
        }
        if (this.forceRemove && this.forceRemoveTicks-- <= 0) {
            this.entity.func_70106_y();
        }
        if (this.lastSafePos == null) {
            this.lastSafePos = new Vec3d(this.entity.func_213303_ch().func_82615_a(), this.entity.func_213303_ch().func_82617_b(), this.entity.func_213303_ch().func_82616_c());
        }
        if (!this.entity.func_130014_f_().func_180495_p(this.entity.func_180425_c()).func_185904_a().func_76220_a()) {
            this.lastSafePos = new Vec3d(Math.floor(this.entity.func_213303_ch().func_82615_a()) + 0.5, (double)this.entity.func_180425_c().func_177956_o(), Math.floor(this.entity.func_213303_ch().func_82616_c()) + 0.5);
        }
        if (this.fearEntity != null && !this.fearEntity.func_70089_S()) {
            this.fearEntity = null;
        }
        try {
            this.updatePickedUpByEntity();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.updatedPerchedByEntity();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onDeath() {
        this.setPickedUpByEntity(null);
    }

    public void updatePickedUpByEntity() {
        if (this.pickedUpByEntity == null) {
            return;
        }
        if (!this.entity.func_130014_f_().field_72995_K) {
            if (!this.pickedUpByEntity.func_70089_S()) {
                this.setPickedUpByEntity(null);
                return;
            }
            if (this.pickedUpByEntity instanceof LivingEntity && ((LivingEntity)this.pickedUpByEntity).func_110143_aJ() <= 0.0f) {
                this.setPickedUpByEntity(null);
                return;
            }
            EffectBase weight = ObjectManager.getEffect("weight");
            if (weight != null && this.entity.func_70644_a((Effect)weight)) {
                this.setPickedUpByEntity(null);
                return;
            }
            if ((double)this.entity.func_70032_d(this.pickedUpByEntity) > 32.0) {
                this.setPickedUpByEntity(null);
                return;
            }
        }
        if (this.pickedUpByEntity != null) {
            double[] pickupOffset = this.getPickedUpOffset();
            this.entity.func_70107_b(this.pickedUpByEntity.func_213303_ch().func_82615_a() + pickupOffset[0], this.pickedUpByEntity.func_213303_ch().func_82617_b() + pickupOffset[1], this.pickedUpByEntity.func_213303_ch().func_82616_c() + pickupOffset[2]);
            this.entity.func_213317_d(this.pickedUpByEntity.func_213322_ci());
            this.entity.field_70143_R = 0.0f;
            if (!this.entity.func_130014_f_().field_72995_K && this.entity instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)this.entity;
                player.field_71075_bZ.field_75101_c = true;
                this.entity.field_70145_X = true;
            }
        }
    }

    public void setPickedUpByEntity(Entity pickedUpByEntity) {
        if (this.pickedUpByEntity == pickedUpByEntity || this.entity == null) {
            return;
        }
        this.pickedUpByEntity = pickedUpByEntity;
        if (!this.entity.func_130014_f_().field_72995_K) {
            if (this.entity instanceof PlayerEntity) {
                if (pickedUpByEntity != null) {
                    this.playerAllowFlyingSnapshot = ((PlayerEntity)this.entity).field_71075_bZ.field_75101_c;
                    this.playerIsFlyingSnapshot = ((PlayerEntity)this.entity).field_71075_bZ.field_75100_b;
                } else {
                    ((PlayerEntity)this.entity).field_71075_bZ.field_75101_c = this.playerAllowFlyingSnapshot;
                    ((PlayerEntity)this.entity).field_71075_bZ.field_75100_b = this.playerIsFlyingSnapshot;
                    this.entity.field_70145_X = false;
                }
            }
            if (this.pickedUpByEntity != null && !(this.entity instanceof PlayerEntity)) {
                double[] pickupOffset = this.getPickedUpOffset();
                this.entity.func_223102_j(this.pickedUpByEntity.func_213303_ch().func_82615_a() + pickupOffset[0], this.pickedUpByEntity.func_213303_ch().func_82617_b() + pickupOffset[1], this.pickedUpByEntity.func_213303_ch().func_82616_c() + pickupOffset[2]);
            }
            MessageEntityPickedUp message = new MessageEntityPickedUp((Entity)this.entity, pickedUpByEntity);
            LycanitesMobs.packetHandler.sendToWorld(message, this.entity.func_130014_f_());
        }
        if (pickedUpByEntity == null) {
            if (this.lastSafePos != null) {
                this.entity.func_70107_b(this.lastSafePos.func_82615_a(), this.lastSafePos.func_82617_b(), this.lastSafePos.func_82616_c());
            }
            this.entity.func_213293_j(0.0, 0.0, 0.0);
            this.entity.field_70143_R = 0.0f;
        }
    }

    public double[] getPickedUpOffset() {
        double[] pickupOffset = new double[]{0.0, 0.0, 0.0};
        if (this.pickedUpByEntity instanceof BaseCreatureEntity) {
            pickupOffset = ((BaseCreatureEntity)this.pickedUpByEntity).getPickupOffset((Entity)this.entity);
        }
        if (CreatureManager.getInstance().config.disablePickupOffsets && this.entity instanceof PlayerEntity) {
            return new double[]{0.0, 0.0, 0.0};
        }
        return pickupOffset;
    }

    public boolean isPickedUp() {
        return this.pickedUpByEntity != null;
    }

    public boolean isFeared() {
        return this.pickedUpByEntity instanceof FearEntity;
    }

    public void setPerchedByEntity(Entity perchedByEntity) {
        if (this.perchedByEntity != null) {
            this.perchedByEntity.field_70145_X = this.perchedEntityNoclip;
            if (this.perchedByEntity instanceof BaseCreatureEntity) {
                ((BaseCreatureEntity)this.perchedByEntity).setPerchTarget(null);
            }
        }
        this.perchedByEntity = perchedByEntity;
        if (perchedByEntity != null) {
            this.perchedEntityNoclip = perchedByEntity.field_70145_X;
            perchedByEntity.field_70145_X = true;
            if (perchedByEntity instanceof BaseCreatureEntity) {
                ((BaseCreatureEntity)perchedByEntity).setPerchTarget(this.entity);
            }
        }
        if (!this.entity.func_130014_f_().field_72995_K) {
            MessageEntityPerched message = new MessageEntityPerched((Entity)this.entity, this.perchedByEntity);
            LycanitesMobs.packetHandler.sendToWorld(message, this.entity.func_130014_f_());
        }
    }

    public Entity getPerchedByEntity() {
        return this.perchedByEntity;
    }

    public Vec3d getPerchPosition() {
        double entityWidth = this.entity.func_213305_a((Pose)this.entity.func_213283_Z()).field_220315_a;
        double entityHeight = this.entity.func_213305_a((Pose)this.entity.func_213283_Z()).field_220316_b;
        double angle = Math.toRadians(this.entity.field_70177_z) + 90.0;
        double xPerchPos = this.entity.func_213303_ch().func_82615_a();
        double zPerchPos = this.entity.func_213303_ch().func_82616_c();
        double distance = entityWidth * 0.7;
        if (distance != 0.0) {
            xPerchPos += distance * -Math.sin(angle);
            zPerchPos += distance * Math.cos(angle);
        }
        return new Vec3d(xPerchPos, this.entity.func_213303_ch().func_82617_b() + entityHeight * 0.78, zPerchPos);
    }

    public void updatedPerchedByEntity() {
        Entity perchedByEntity = this.getPerchedByEntity();
        if (perchedByEntity != null) {
            Vec3d perchPosition = this.getPerchPosition();
            perchedByEntity.func_70107_b(perchPosition.func_82615_a(), perchPosition.func_82617_b(), perchPosition.func_82616_c());
            perchedByEntity.func_213317_d(this.entity.func_213322_ci());
            perchedByEntity.field_70177_z = this.entity.field_70177_z;
            perchedByEntity.field_70145_X = true;
        }
    }

    public void readNBT(CompoundNBT nbtTagCompound) {
    }

    public void writeNBT(CompoundNBT nbtTagCompound) {
    }

    static {
        FORCE_REMOVE_ENTITY_TICKS = 40;
    }
}

