/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.lycanitesmobs.LycanitesMobs;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;

public class EntityFactory
implements EntityType.IFactory<Entity> {
    public static EntityFactory INSTANCE;
    public Map<EntityType, Constructor<? extends Entity>> entityTypeConstructorMap = new HashMap<EntityType, Constructor<? extends Entity>>();
    public Map<Constructor<? extends Entity>, EntityType> entityConstructorTypeMap = new HashMap<Constructor<? extends Entity>, EntityType>();
    public Map<String, EntityType> entityTypeNetworkMap = new HashMap<String, EntityType>();
    public BiFunction<FMLPlayMessages.SpawnEntity, World, Entity> createOnClientFunction = this::createOnClient;

    public static EntityFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EntityFactory();
        }
        return INSTANCE;
    }

    public void addEntityType(EntityType entityType, Constructor<? extends Entity> entityClass, String networkName) {
        LycanitesMobs.logDebug("Entity", "Adding entity: " + entityClass + " Type: " + entityType.func_212546_e() + " Classification: " + entityType.func_220339_d());
        this.entityTypeConstructorMap.put(entityType, entityClass);
        this.entityConstructorTypeMap.put(entityClass, entityType);
        this.entityTypeNetworkMap.put(networkName, entityType);
    }

    public Entity create(EntityType entityType, World world) {
        if (!this.entityTypeConstructorMap.containsKey(entityType)) {
            LycanitesMobs.logWarning("", "Unable to find constructor for Entity Type: " + entityType);
            return null;
        }
        LycanitesMobs.logDebug("Entity", "Spawning entity: " + this.entityTypeConstructorMap.get(entityType) + " - " + entityType.func_220339_d());
        Constructor<? extends Entity> constructor = this.entityTypeConstructorMap.get(entityType);
        try {
            return constructor.newInstance(entityType, world);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public Entity createOnClient(FMLPlayMessages.SpawnEntity spawnPacket, World world) {
        LycanitesMobs.logDebug("", "Client factory called!");
        return null;
    }
}

