/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.info.ElementInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import com.lycanitesmobs.core.info.projectile.behaviours.ProjectileBehaviour;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CustomProjectileEntity
extends BaseProjectileEntity {
    protected static final DataParameter<String> PROJECTILE_NAME = EntityDataManager.func_187226_a(CustomProjectileEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    public ProjectileInfo projectileInfo;

    public CustomProjectileEntity(EntityType<? extends BaseProjectileEntity> entityType, World world) {
        super(entityType, world);
        this.modInfo = LycanitesMobs.modInfo;
    }

    public CustomProjectileEntity(EntityType<? extends BaseProjectileEntity> entityType, World world, ProjectileInfo projectileInfo) {
        super(entityType, world);
        this.modInfo = LycanitesMobs.modInfo;
        this.setProjectileInfo(projectileInfo);
    }

    public CustomProjectileEntity(EntityType<? extends BaseProjectileEntity> entityType, World world, LivingEntity entityLiving, ProjectileInfo projectileInfo) {
        super(entityType, world, entityLiving);
        if (projectileInfo != null) {
            this.func_184538_a((Entity)entityLiving, entityLiving.field_70125_A, entityLiving.field_70177_z, 0.0f, (float)projectileInfo.velocity, 1.0f);
        }
        this.modInfo = LycanitesMobs.modInfo;
        this.setProjectileInfo(projectileInfo);
    }

    public CustomProjectileEntity(EntityType<? extends BaseProjectileEntity> entityType, World world, double x, double y, double z, ProjectileInfo projectileInfo) {
        super(entityType, world, x, y, z);
        this.modInfo = LycanitesMobs.modInfo;
        this.setProjectileInfo(projectileInfo);
    }

    @Override
    public EntityType func_200600_R() {
        if (this.projectileInfo == null) {
            return super.func_200600_R();
        }
        return this.projectileInfo.getEntityType();
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PROJECTILE_NAME, (Object)"");
    }

    public void loadProjectileInfo(String projectileName) {
        this.setProjectileInfo(ProjectileManager.getInstance().getProjectile(projectileName));
    }

    public void setProjectileInfo(ProjectileInfo projectileInfo) {
        this.projectileInfo = projectileInfo;
        if (this.projectileInfo == null) {
            return;
        }
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(PROJECTILE_NAME, (Object)this.projectileInfo.getName());
        }
        this.modInfo = this.projectileInfo.modInfo;
        this.entityName = this.projectileInfo.getName();
        this.setProjectileScale(this.projectileInfo.scale);
        this.projectileLife = this.projectileInfo.lifetime;
        this.setDamage(this.projectileInfo.damage);
        this.setPierce(this.projectileInfo.pierce);
        this.knockbackChance = this.projectileInfo.knockbackChance;
        this.weight = this.projectileInfo.weight;
        this.spinSpeed = this.projectileInfo.spinSpeed;
        this.waterProof = this.projectileInfo.waterproof;
        this.lavaProof = this.projectileInfo.lavaproof;
        this.cutsGrass = this.projectileInfo.cutGrass;
        this.ripper = this.projectileInfo.ripper;
        this.pierceBlocks = this.projectileInfo.pierceBlocks;
    }

    @Override
    public void func_70071_h_() {
        if (this.func_130014_f_().field_72995_K && this.projectileInfo == null) {
            this.loadProjectileInfo(this.getStringFromDataManager(PROJECTILE_NAME));
        }
        super.func_70071_h_();
        if (this.projectileInfo != null && !this.func_130014_f_().field_72995_K) {
            for (ProjectileBehaviour behaviour : this.projectileInfo.behaviours) {
                behaviour.onProjectileUpdate(this);
            }
        }
    }

    @Override
    public void onDamage(LivingEntity target, float damage, boolean attackSuccess) {
        super.onDamage(target, damage, attackSuccess);
        if (!this.func_130014_f_().field_72995_K && attackSuccess && this.projectileInfo != null) {
            for (ElementInfo element : this.projectileInfo.elements) {
                element.debuffEntity(target, this.projectileInfo.effectDuration * 20, this.projectileInfo.effectAmplifier);
            }
        }
    }

    @Override
    public void onImpactComplete(BlockPos impactPos) {
        super.onImpactComplete(impactPos);
        if (this.projectileInfo == null) {
            return;
        }
        for (ProjectileBehaviour behaviour : this.projectileInfo.behaviours) {
            behaviour.onProjectileImpact(this, this.func_130014_f_(), impactPos);
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.projectileInfo != null) {
            compound.func_74778_a("ProjectileName", this.projectileInfo.getName());
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("ProjectileName")) {
            this.loadProjectileInfo(compound.func_74779_i("ProjectileName"));
        }
    }

    @Override
    public String getTextureName() {
        return this.entityName;
    }

    public float func_70013_c() {
        if (this.projectileInfo == null || !this.projectileInfo.glow) {
            return super.func_70013_c();
        }
        return 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBrightnessForRender() {
        if (this.projectileInfo == null || !this.projectileInfo.glow) {
            return super.func_226263_P_();
        }
        return 0xF000F0;
    }

    @Override
    public SoundEvent getLaunchSound() {
        if (this.projectileInfo != null) {
            return this.projectileInfo.getLaunchSound();
        }
        return super.getLaunchSound();
    }

    @Override
    public SoundEvent getImpactSound() {
        if (this.projectileInfo != null) {
            return this.projectileInfo.getImpactSound();
        }
        return super.getImpactSound();
    }
}

