/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.Subspecies;
import net.minecraft.world.Difficulty;

public class CreatureStats {
    public static String[] STAT_NAMES = new String[]{"health", "defense", "armor", "speed", "damage", "attackSpeed", "rangedSpeed", "effect", "amplifier", "pierce", "sight"};
    public BaseCreatureEntity entity;

    public CreatureStats(BaseCreatureEntity entity) {
        this.entity = entity;
    }

    public double getHealth() {
        String statName = "health";
        double statValue = this.entity.creatureInfo.health;
        if (!this.entity.isTamed()) {
            statValue *= this.getDifficultyMultiplier(statName);
            statValue *= this.getSubspeciesMultiplier(statName);
            if (this.entity.extraMobBehaviour != null) {
                statValue *= this.entity.extraMobBehaviour.multiplierHealth;
                statValue += (double)this.entity.extraMobBehaviour.boostHealth;
            }
        } else {
            statValue *= CreatureManager.getInstance().tamedHealthMultiplier;
        }
        return Math.max(0.0, statValue *= this.getLevelMultiplier(statName));
    }

    public double getDefense() {
        String statName = "defense";
        double statValue = this.entity.creatureInfo.defense;
        if (!this.entity.isTamed()) {
            statValue *= this.getDifficultyMultiplier(statName);
            statValue *= this.getSubspeciesMultiplier(statName);
            if (this.entity.extraMobBehaviour != null) {
                statValue *= this.entity.extraMobBehaviour.multiplierDefense;
                statValue += (double)this.entity.extraMobBehaviour.boostDefense;
            }
        }
        return statValue;
    }

    public double getArmor() {
        String statName = "armor";
        double statValue = this.entity.creatureInfo.armor;
        if (!this.entity.isTamed()) {
            statValue *= this.getDifficultyMultiplier(statName);
            statValue *= this.getSubspeciesMultiplier(statName);
            if (this.entity.extraMobBehaviour != null) {
                statValue *= this.entity.extraMobBehaviour.multiplierArmor;
                statValue += (double)this.entity.extraMobBehaviour.boostArmor;
            }
        }
        return statValue;
    }

    public double getSpeed() {
        String statName = "speed";
        double statValue = this.entity.creatureInfo.speed / 100.0;
        if (!this.entity.isTamed()) {
            statValue *= this.getDifficultyMultiplier(statName);
            statValue *= this.getSubspeciesMultiplier(statName);
            if (this.entity.extraMobBehaviour != null) {
                statValue *= this.entity.extraMobBehaviour.multiplierSpeed;
                statValue += (double)this.entity.extraMobBehaviour.boostSpeed;
            }
        }
        return statValue;
    }

    public double getDamage() {
        String statName = "damage";
        double statValue = this.entity.creatureInfo.damage;
        if (!this.entity.isTamed()) {
            statValue *= this.getDifficultyMultiplier(statName);
            statValue *= this.getSubspeciesMultiplier(statName);
            if (this.entity.extraMobBehaviour != null) {
                statValue *= this.entity.extraMobBehaviour.multiplierDamage;
                statValue += (double)this.entity.extraMobBehaviour.boostDamage;
            }
        }
        return statValue;
    }

    public double getAttackSpeed() {
        String statName = "attackSpeed";
        double statValue = this.entity.creatureInfo.attackSpeed;
        if (!this.entity.isTamed()) {
            statValue *= this.getDifficultyMultiplier(statName);
            statValue *= this.getSubspeciesMultiplier(statName);
            if (this.entity.extraMobBehaviour != null) {
                statValue *= this.entity.extraMobBehaviour.multiplierHaste;
                statValue += (double)this.entity.extraMobBehaviour.boostHaste;
            }
        }
        return statValue;
    }

    public double getRangedSpeed() {
        String statName = "rangedSpeed";
        double statValue = this.entity.creatureInfo.rangedSpeed;
        if (!this.entity.isTamed()) {
            statValue *= this.getDifficultyMultiplier(statName);
            statValue *= this.getSubspeciesMultiplier(statName);
            if (this.entity.extraMobBehaviour != null) {
                statValue *= this.entity.extraMobBehaviour.multiplierHaste;
                statValue += (double)this.entity.extraMobBehaviour.boostHaste;
            }
        }
        return statValue;
    }

    public double getEffect() {
        String statName = "effect";
        double statValue = this.entity.creatureInfo.effectDuration;
        if (!this.entity.isTamed()) {
            statValue *= this.getDifficultyMultiplier(statName);
            statValue *= this.getSubspeciesMultiplier(statName);
            if (this.entity.extraMobBehaviour != null) {
                statValue *= this.entity.extraMobBehaviour.multiplierEffect;
                statValue += (double)this.entity.extraMobBehaviour.boostEffect;
            }
        }
        return statValue;
    }

    public double getAmplifier() {
        String statName = "amplifier";
        double statValue = this.entity.creatureInfo.effectAmplifier;
        if (!this.entity.isTamed()) {
            statValue *= this.getDifficultyMultiplier(statName);
            statValue *= this.getSubspeciesMultiplier(statName);
        }
        return statValue;
    }

    public double getPierce() {
        String statName = "pierce";
        double statValue = this.entity.creatureInfo.pierce;
        if (!this.entity.isTamed()) {
            statValue *= this.getDifficultyMultiplier(statName);
            statValue *= this.getSubspeciesMultiplier(statName);
            if (this.entity.extraMobBehaviour != null) {
                statValue *= this.entity.extraMobBehaviour.multiplierPierce;
                statValue += (double)this.entity.extraMobBehaviour.boostPierce;
            }
        }
        return statValue;
    }

    public double getSight() {
        String statName = "sight";
        double statValue = this.entity.creatureInfo.sight;
        if (!this.entity.isTamed()) {
            statValue *= this.getDifficultyMultiplier(statName);
            statValue *= this.getSubspeciesMultiplier(statName);
        }
        return statValue;
    }

    public double getKnockbackResistance() {
        return this.entity.creatureInfo.knockbackResistance;
    }

    protected double getDifficultyMultiplier(String stat) {
        Difficulty difficulty = this.entity.func_130014_f_().func_175659_aa();
        String difficultyName = "Easy";
        if (difficulty.func_151525_a() >= 3) {
            difficultyName = "Hard";
        } else if (difficulty == Difficulty.NORMAL) {
            difficultyName = "Normal";
        }
        return CreatureManager.getInstance().getDifficultyMultiplier(difficultyName.toUpperCase(), stat.toUpperCase());
    }

    protected double getSubspeciesMultiplier(String stat) {
        if (this.entity.getSubspecies() != null && Subspecies.statMultipliers.containsKey(this.entity.getSubspecies().rarity.toUpperCase() + "-" + stat.toUpperCase())) {
            return Subspecies.statMultipliers.get(this.entity.getSubspecies().rarity.toUpperCase() + "-" + stat.toUpperCase());
        }
        return 1.0;
    }

    protected double getLevelMultiplier(String stat) {
        double statLevel = Math.max(0, this.entity.getLevel() - 1);
        return 1.0 + statLevel * CreatureManager.getInstance().getLevelMultiplier(stat.toUpperCase());
    }
}

